/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.operator.learner.SimpleBinaryPredictionModel;

public class LogisticRegressionModel
extends SimpleBinaryPredictionModel {
    private static final long serialVersionUID = -966943348790852574L;
    private double[] beta = null;
    private double[] standardError = null;
    private double[] waldStatistic = null;
    private String[] attributeNames;
    private boolean interceptAdded;

    public LogisticRegressionModel(ExampleSet exampleSet, double[] beta, double[] variance, boolean interceptAdded) {
        super(exampleSet, 0.5);
        this.attributeNames = Tools.getRegularAttributeNames(exampleSet);
        this.beta = beta;
        this.interceptAdded = interceptAdded;
        this.standardError = new double[variance.length];
        this.waldStatistic = new double[variance.length];
        for (int j = 0; j < beta.length; ++j) {
            this.standardError[j] = Math.sqrt(variance[j]);
            this.waldStatistic[j] = beta[j] * beta[j] / variance[j];
        }
    }

    @Override
    public double predict(Example example) {
        double eta = 0.0;
        int i = 0;
        for (Attribute attribute : example.getAttributes()) {
            double value = example.getValue(attribute);
            eta += this.beta[i] * value;
            ++i;
        }
        if (this.interceptAdded) {
            eta += this.beta[this.beta.length - 1];
        }
        return Math.exp(eta) / (1.0 + Math.exp(eta));
    }

    @Override
    public String toString() {
        int j;
        StringBuffer result = new StringBuffer();
        if (this.interceptAdded) {
            result.append("Bias (offset): " + com.rapidminer.tools.Tools.formatNumber(this.beta[this.beta.length - 1]));
            result.append("  \t(SE: " + com.rapidminer.tools.Tools.formatNumber(this.standardError[this.standardError.length - 1]));
            result.append(", Wald: " + com.rapidminer.tools.Tools.formatNumber(this.waldStatistic[this.waldStatistic.length - 1]) + ")" + com.rapidminer.tools.Tools.getLineSeparators(2));
        }
        result.append("Coefficients:" + com.rapidminer.tools.Tools.getLineSeparator());
        for (j = 0; j < this.beta.length - 1; ++j) {
            result.append("beta(" + this.attributeNames[j] + ") = " + com.rapidminer.tools.Tools.formatNumber(this.beta[j]));
            result.append(" \t\t(SE: " + com.rapidminer.tools.Tools.formatNumber(this.standardError[j]));
            result.append(", Wald: " + com.rapidminer.tools.Tools.formatNumber(this.waldStatistic[j]) + ")" + com.rapidminer.tools.Tools.getLineSeparator());
        }
        result.append(com.rapidminer.tools.Tools.getLineSeparator() + "Odds Ratios:" + com.rapidminer.tools.Tools.getLineSeparator());
        for (j = 0; j < this.beta.length - 1; ++j) {
            result.append("odds_ratio(" + this.attributeNames[j] + ") = " + com.rapidminer.tools.Tools.formatNumber(Math.exp(this.beta[j])) + com.rapidminer.tools.Tools.getLineSeparator());
        }
        return result.toString();
    }

    public String[] getAttributeNames() {
        return this.attributeNames;
    }

    public double[] getCoefficients() {
        return this.beta;
    }

    public String getFirstLabel() {
        return this.getTrainingHeader().getAttributes().getLabel().getMapping().getNegativeString();
    }

    public String getSecondLabel() {
        return this.getTrainingHeader().getAttributes().getLabel().getMapping().getPositiveString();
    }
}

