/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions;

import Jama.Matrix;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.OperatorCapability;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.learner.AbstractLearner;
import com.rapidminer.operator.learner.PredictionModel;
import com.rapidminer.operator.learner.functions.LinearRegressionModel;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import com.rapidminer.tools.math.FDistribution;
import java.util.Iterator;
import java.util.List;

public class LinearRegression
extends AbstractLearner {
    public static final String PARAMETER_FEATURE_SELECTION = "feature_selection";
    public static final String PARAMETER_ELIMINATE_COLINEAR_FEATURES = "eliminate_colinear_features";
    public static final String PARAMETER_USE_BIAS = "use_bias";
    public static final String PARAMETER_MIN_STANDARDIZED_COEFFICIENT = "min_standardized_coefficient";
    public static final String PARAMETER_RIDGE = "ridge";
    public static final String[] FEATURE_SELECTION_METHODS = new String[]{"none", "M5 prime", "greedy"};
    public static final int NO_SELECTION = 0;
    public static final int M5_PRIME = 1;
    public static final int GREEDY = 2;
    private OutputPort weightOutput = (OutputPort)this.getOutputPorts().createPort("weights");

    public LinearRegression(OperatorDescription description) {
        super(description);
        this.getTransformer().addGenerationRule(this.weightOutput, AttributeWeights.class);
    }

    @Override
    public Model learn(ExampleSet exampleSet) throws OperatorException {
        double[] coefficients;
        Attribute label;
        Attribute workingLabel = label = exampleSet.getAttributes().getLabel();
        boolean cleanUpLabel = false;
        String firstClassName = null;
        String secondClassName = null;
        boolean useBias = this.getParameterAsBoolean(PARAMETER_USE_BIAS);
        boolean removeColinearAttributes = this.getParameterAsBoolean(PARAMETER_ELIMINATE_COLINEAR_FEATURES);
        double ridge = this.getParameterAsDouble(PARAMETER_RIDGE);
        double minStandardizedCoefficient = this.getParameterAsDouble(PARAMETER_MIN_STANDARDIZED_COEFFICIENT);
        if (label.isNominal() && label.getMapping().size() == 2) {
            firstClassName = label.getMapping().getNegativeString();
            secondClassName = label.getMapping().getPositiveString();
            int firstIndex = label.getMapping().getNegativeIndex();
            workingLabel = AttributeFactory.createAttribute("regression_label", 4);
            exampleSet.getExampleTable().addAttribute(workingLabel);
            for (Example example : exampleSet) {
                double index = example.getValue(label);
                if (index == (double)firstIndex) {
                    example.setValue(workingLabel, 0.0);
                    continue;
                }
                example.setValue(workingLabel, 1.0);
            }
            exampleSet.getAttributes().setLabel(workingLabel);
            cleanUpLabel = true;
        }
        int numberOfAttributes = exampleSet.getAttributes().size();
        boolean[] attributeSelection = new boolean[numberOfAttributes];
        int counter = 0;
        String[] attributeNames = new String[numberOfAttributes];
        for (Attribute attribute : exampleSet.getAttributes()) {
            attributeSelection[counter] = attribute.isNumerical();
            attributeNames[counter] = attribute.getName();
            ++counter;
        }
        exampleSet.recalculateAllAttributeStatistics();
        double[] means = new double[numberOfAttributes];
        double[] standardDeviations = new double[numberOfAttributes];
        counter = 0;
        for (Attribute attribute : exampleSet.getAttributes()) {
            if (attributeSelection[counter]) {
                means[counter] = exampleSet.getStatistics(attribute, "average_weighted");
                standardDeviations[counter] = Math.sqrt(exampleSet.getStatistics(attribute, "variance_weighted"));
                if (standardDeviations[counter] == 0.0) {
                    attributeSelection[counter] = false;
                }
            }
            ++counter;
        }
        double labelMean = exampleSet.getStatistics(workingLabel, "average_weighted");
        double classStandardDeviation = Math.sqrt(exampleSet.getStatistics(workingLabel, "variance_weighted"));
        int numberOfExamples = exampleSet.size();
        do {
            coefficients = this.performRegression(exampleSet, attributeSelection, means, labelMean, ridge);
        } while (removeColinearAttributes && this.deselectAttributeWithHighestCoefficient(attributeSelection, coefficients, standardDeviations, classStandardDeviation, minStandardizedCoefficient));
        int currentlySelectedAttributes = 1;
        for (int i = 0; i < attributeSelection.length; ++i) {
            if (!attributeSelection[i]) continue;
            ++currentlySelectedAttributes;
        }
        double error = this.getSquaredError(exampleSet, attributeSelection, coefficients, useBias);
        double akaike = numberOfExamples - currentlySelectedAttributes + 2 * currentlySelectedAttributes;
        int currentNumberOfAttributes = currentlySelectedAttributes;
        double currentError = Double.NaN;
        switch (this.getParameterAsInt(PARAMETER_FEATURE_SELECTION)) {
            case 2: {
                boolean improved;
                do {
                    boolean[] currentlySelected = (boolean[])attributeSelection.clone();
                    improved = false;
                    --currentNumberOfAttributes;
                    for (int i = 0; i < attributeSelection.length; ++i) {
                        if (!currentlySelected[i]) continue;
                        currentlySelected[i] = false;
                        double[] currentCoeffs = this.performRegression(exampleSet, currentlySelected, means, labelMean, ridge);
                        currentError = this.getSquaredError(exampleSet, currentlySelected, currentCoeffs, useBias);
                        double currentAkaike = currentError / error * (double)(numberOfExamples - currentlySelectedAttributes) + (double)(2 * currentNumberOfAttributes);
                        if (currentAkaike < akaike) {
                            improved = true;
                            akaike = currentAkaike;
                            System.arraycopy(currentlySelected, 0, attributeSelection, 0, attributeSelection.length);
                            coefficients = currentCoeffs;
                        }
                        currentlySelected[i] = true;
                    }
                } while (improved);
                break;
            }
            case 1: {
                boolean improved;
                do {
                    improved = false;
                    --currentNumberOfAttributes;
                    double minStadardizedCoefficient = 0.0;
                    int attribute2Deselect = -1;
                    int coefficientIndex = 0;
                    for (int i = 0; i < attributeSelection.length; ++i) {
                        if (!attributeSelection[i]) continue;
                        double standardizedCoefficient = Math.abs(coefficients[coefficientIndex] * standardDeviations[i] / classStandardDeviation);
                        if (coefficientIndex == 0 || standardizedCoefficient < minStadardizedCoefficient) {
                            minStadardizedCoefficient = standardizedCoefficient;
                            attribute2Deselect = i;
                        }
                        ++coefficientIndex;
                    }
                    if (attribute2Deselect < 0) continue;
                    attributeSelection[attribute2Deselect] = false;
                    double[] currentCoefficients = this.performRegression(exampleSet, attributeSelection, means, labelMean, ridge);
                    currentError = this.getSquaredError(exampleSet, attributeSelection, currentCoefficients, useBias);
                    double currentAkaike = currentError / error * (double)(numberOfExamples - currentlySelectedAttributes) + (double)(2 * currentNumberOfAttributes);
                    if (currentAkaike < akaike) {
                        improved = true;
                        akaike = currentAkaike;
                        coefficients = currentCoefficients;
                        continue;
                    }
                    attributeSelection[attribute2Deselect] = true;
                } while (improved);
                break;
            }
            case 0: {
                currentError = error;
            }
        }
        if (cleanUpLabel) {
            exampleSet.getAttributes().remove(workingLabel);
            exampleSet.getExampleTable().removeAttribute(workingLabel);
            exampleSet.getAttributes().setLabel(label);
        }
        FDistribution fdistribution = new FDistribution(1, exampleSet.size() - coefficients.length);
        int length = coefficients.length;
        double[] standardErrors = new double[length - 1];
        double[] standardizedCoefficients = new double[length - 1];
        double[] tStatistics = new double[length - 1];
        double[] pValues = new double[length - 1];
        int index = 0;
        for (int i = 0; i < attributeSelection.length; ++i) {
            if (!attributeSelection[i]) continue;
            standardErrors[index] = Math.sqrt(currentError) / (standardDeviations[i] * (double)(exampleSet.size() - coefficients.length));
            standardizedCoefficients[index] = coefficients[index] * standardDeviations[i] / classStandardDeviation;
            tStatistics[index] = coefficients[index] / standardErrors[index];
            double probability = fdistribution.getProbabilityForValue(tStatistics[index] * tStatistics[index]);
            pValues[index] = probability < 0.0 ? 1.0 : 1.0 - probability;
            ++index;
        }
        if (this.weightOutput.isConnected()) {
            AttributeWeights weights = new AttributeWeights(exampleSet);
            int selectedAttributes = 0;
            for (int i = 0; i < attributeNames.length; ++i) {
                if (attributeSelection[i]) {
                    weights.setWeight(attributeNames[i], coefficients[selectedAttributes]);
                    ++selectedAttributes;
                    continue;
                }
                weights.setWeight(attributeNames[i], 0.0);
            }
            this.weightOutput.deliver(weights);
        }
        return new LinearRegressionModel(exampleSet, attributeSelection, coefficients, standardErrors, standardizedCoefficients, tStatistics, pValues, useBias, firstClassName, secondClassName);
    }

    private boolean deselectAttributeWithHighestCoefficient(boolean[] selectedAttributes, double[] coefficients, double[] standardDeviations, double classStandardDeviation, double minStandardizedCoefficient) throws UndefinedParameterError {
        int attribute2Deselect = -1;
        int coefficientIndex = 0;
        for (int i = 0; i < selectedAttributes.length; ++i) {
            if (!selectedAttributes[i]) continue;
            double standardizedCoefficient = Math.abs(coefficients[coefficientIndex] * standardDeviations[i] / classStandardDeviation);
            if (standardizedCoefficient > minStandardizedCoefficient) {
                minStandardizedCoefficient = standardizedCoefficient;
                attribute2Deselect = i;
            }
            ++coefficientIndex;
        }
        if (attribute2Deselect >= 0) {
            selectedAttributes[attribute2Deselect] = false;
            return true;
        }
        return false;
    }

    private double getSquaredError(ExampleSet exampleSet, boolean[] selectedAttributes, double[] coefficients, boolean useIntercept) {
        double error = 0.0;
        for (Example example : exampleSet) {
            double prediction = this.regressionPrediction(example, selectedAttributes, coefficients, useIntercept);
            double diff = prediction - example.getLabel();
            error += diff * diff;
        }
        return error;
    }

    private double regressionPrediction(Example example, boolean[] selectedAttributes, double[] coefficients, boolean useIntercept) {
        double prediction = 0.0;
        int index = 0;
        int counter = 0;
        for (Attribute attribute : example.getAttributes()) {
            if (!selectedAttributes[counter++]) continue;
            prediction += coefficients[index] * example.getValue(attribute);
            ++index;
        }
        if (useIntercept) {
            prediction += coefficients[index];
        }
        return prediction;
    }

    private double[] performRegression(ExampleSet exampleSet, boolean[] selectedAttributes, double[] means, double labelMean, double ridge) throws UndefinedParameterError {
        int currentlySelectedAttributes = 0;
        for (int i = 0; i < selectedAttributes.length; ++i) {
            if (!selectedAttributes[i]) continue;
            ++currentlySelectedAttributes;
        }
        Matrix independent = null;
        Matrix dependent = null;
        double[] weights = null;
        if (currentlySelectedAttributes > 0) {
            independent = new Matrix(exampleSet.size(), currentlySelectedAttributes);
            dependent = new Matrix(exampleSet.size(), 1);
            int exampleIndex = 0;
            Iterator i = exampleSet.iterator();
            weights = new double[exampleSet.size()];
            Attribute weightAttribute = exampleSet.getAttributes().getWeight();
            while (i.hasNext()) {
                Example example = (Example)i.next();
                int attributeIndex = 0;
                dependent.set(exampleIndex, 0, example.getLabel());
                int counter = 0;
                for (Attribute attribute : exampleSet.getAttributes()) {
                    if (selectedAttributes[counter]) {
                        double value = example.getValue(attribute) - means[counter];
                        independent.set(exampleIndex, attributeIndex, value);
                        ++attributeIndex;
                    }
                    ++counter;
                }
                weights[exampleIndex] = weightAttribute != null ? example.getValue(weightAttribute) : 1.0;
                ++exampleIndex;
            }
        }
        double[] coefficients = new double[currentlySelectedAttributes + 1];
        if (currentlySelectedAttributes > 0) {
            double[] coefficientsWithoutIntercept = com.rapidminer.tools.math.LinearRegression.performRegression(independent, dependent, weights, ridge);
            System.arraycopy(coefficientsWithoutIntercept, 0, coefficients, 0, currentlySelectedAttributes);
        }
        coefficients[currentlySelectedAttributes] = labelMean;
        int coefficientIndex = 0;
        for (int i = 0; i < selectedAttributes.length; ++i) {
            if (!selectedAttributes[i]) continue;
            int n = coefficients.length - 1;
            coefficients[n] = coefficients[n] - coefficients[coefficientIndex] * means[i];
            ++coefficientIndex;
        }
        return coefficients;
    }

    @Override
    public Class<? extends PredictionModel> getModelClass() {
        return LinearRegressionModel.class;
    }

    @Override
    public boolean supportsCapability(OperatorCapability lc) {
        if (lc.equals((Object)OperatorCapability.NUMERICAL_ATTRIBUTES)) {
            return true;
        }
        if (lc.equals((Object)OperatorCapability.NUMERICAL_LABEL)) {
            return true;
        }
        if (lc.equals((Object)OperatorCapability.BINOMINAL_LABEL)) {
            return true;
        }
        return lc == OperatorCapability.WEIGHTED_EXAMPLES;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeCategory(PARAMETER_FEATURE_SELECTION, "The feature selection method used during regression.", FEATURE_SELECTION_METHODS, 1));
        types.add(new ParameterTypeBoolean(PARAMETER_ELIMINATE_COLINEAR_FEATURES, "Indicates if the algorithm should try to delete colinear features during the regression.", true));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_BIAS, "Indicates if an intercept value should be calculated.", true));
        types.add(new ParameterTypeDouble(PARAMETER_MIN_STANDARDIZED_COEFFICIENT, "The minimum standardized coefficient for the removal of colinear feature elimination.", 0.0, Double.POSITIVE_INFINITY, 1.5));
        types.add(new ParameterTypeDouble(PARAMETER_RIDGE, "The ridge parameter used during ridge regression.", 0.0, Double.POSITIVE_INFINITY, 1.0E-8));
        return types;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getExampleSetInputPort(), LinearRegression.class, null);
    }
}

