/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.SimpleDataTable;
import com.rapidminer.datatable.SimpleDataTableRow;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.SimplePredictionModel;
import com.rapidminer.tools.math.kernels.DotKernel;
import com.rapidminer.tools.math.kernels.Kernel;

public class HyperplaneModel
extends SimplePredictionModel {
    private static final long serialVersionUID = -4990692589416639697L;
    private String[] coefficientNames;
    private double[] coefficients;
    private double intercept;
    private String classNegative;
    private String classPositive;
    private Kernel kernel;

    public HyperplaneModel(ExampleSet exampleSet) {
        this(exampleSet, null, null);
    }

    public HyperplaneModel(ExampleSet exampleSet, String classNegative, String classPositive) {
        this(exampleSet, classNegative, classPositive, new DotKernel());
    }

    public HyperplaneModel(ExampleSet exampleSet, String classNegative, String classPositive, Kernel kernel) {
        super(exampleSet);
        this.coefficientNames = Tools.getRegularAttributeNames(exampleSet);
        this.classNegative = classNegative;
        this.classPositive = classPositive;
        this.kernel = kernel;
    }

    @Override
    public double predict(Example example) throws OperatorException {
        int i = 0;
        double distance = this.intercept;
        double[] values = new double[example.getAttributes().size()];
        for (Attribute currentAttribute : example.getAttributes()) {
            values[i] = example.getValue(currentAttribute);
            ++i;
        }
        distance += this.kernel.calculateDistance(values, this.coefficients);
        if (this.getLabel().isNominal()) {
            boolean isApplying;
            int positiveMapping = this.getLabel().getMapping().mapString(this.classPositive);
            int negativeMapping = this.getLabel().getMapping().mapString(this.classNegative);
            boolean bl = isApplying = example.getAttributes().getPredictedLabel() != null;
            if (isApplying) {
                example.setConfidence(this.classPositive, 1.0 / (1.0 + Math.exp(-distance)));
                example.setConfidence(this.classNegative, 1.0 / (1.0 + Math.exp(distance)));
            }
            if (distance < 0.0) {
                return negativeMapping;
            }
            return positiveMapping;
        }
        return distance;
    }

    public void init(double[] coefficients, double intercept) {
        this.coefficients = coefficients;
        this.intercept = intercept;
    }

    public double[] getCoefficients() {
        return this.coefficients;
    }

    public double getIntercept() {
        return this.intercept;
    }

    public void setCoefficients(double[] coefficients) {
        this.coefficients = coefficients;
    }

    public void setIntercept(double intercept) {
        this.intercept = intercept;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.classPositive != null && this.classNegative != null) {
            buffer.append("Hyperplane seperating " + this.classPositive + " and " + this.classNegative + "." + com.rapidminer.tools.Tools.getLineSeparator());
        } else {
            buffer.append("Hyperplane for linear regression." + com.rapidminer.tools.Tools.getLineSeparator());
        }
        buffer.append("Intercept: ");
        buffer.append(Double.toString(this.intercept));
        buffer.append(com.rapidminer.tools.Tools.getLineSeparator());
        buffer.append("Coefficients: " + com.rapidminer.tools.Tools.getLineSeparator());
        int counter = 0;
        for (double value : this.coefficients) {
            buffer.append("w(" + this.coefficientNames[counter] + ") = " + com.rapidminer.tools.Tools.formatIntegerIfPossible(value, 3) + com.rapidminer.tools.Tools.getLineSeparator());
            ++counter;
        }
        buffer.append(com.rapidminer.tools.Tools.getLineSeparator());
        return buffer.toString();
    }

    public DataTable createWeightsTable() {
        SimpleDataTable weightTable = new SimpleDataTable("Hyperplane Model Weights", new String[]{"Attribute", "Weight"});
        for (int j = 0; j < this.coefficientNames.length; ++j) {
            int nameIndex = weightTable.mapString(0, this.coefficientNames[j]);
            weightTable.add(new SimpleDataTableRow(new double[]{nameIndex, this.coefficients[j]}));
        }
        return weightTable;
    }
}

