/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.bayes;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.learner.bayes.DistributionModel;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.math.VectorMath;
import com.rapidminer.tools.math.distribution.DiscreteDistribution;
import com.rapidminer.tools.math.distribution.Distribution;
import com.rapidminer.tools.math.distribution.NormalDistribution;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class SimpleDistributionModel
extends DistributionModel {
    private static final long serialVersionUID = -402827845291958569L;
    private static final String UNKNOWN_VALUE_NAME = "unknown";
    public static final int INDEX_VALUE_SUM = 0;
    public static final int INDEX_SQUARED_VALUE_SUM = 1;
    public static final int INDEX_MISSING_WEIGHTS = 2;
    public static final int INDEX_MEAN = 0;
    public static final int INDEX_STANDARD_DEVIATION = 1;
    public static final int INDEX_LOG_FACTOR = 2;
    private int numberOfClasses;
    private int numberOfAttributes;
    private boolean[] nominal;
    private String className;
    private String[] classValues;
    private String[] attributeNames;
    private String[][] attributeValues;
    private double totalWeight;
    private double[] classWeights;
    private double[][][] weightSums;
    private double[] priors;
    private double[][][] distributionProperties;
    boolean laplaceCorrectionEnabled;
    private boolean modelRecentlyUpdated;

    public SimpleDistributionModel(ExampleSet headerSet, double[] classWeights, double[][][] weightSums) {
        super(headerSet);
        Attributes attributes = headerSet.getAttributes();
        Attribute labelAttribute = attributes.getLabel();
        this.className = labelAttribute.getName();
        this.numberOfClasses = labelAttribute.getMapping().size();
        this.classValues = new String[this.numberOfClasses];
        int i = 0;
        Iterator<Object> i$ = labelAttribute.getMapping().getValues().iterator();
        while (i$.hasNext()) {
            String value;
            this.classValues[i] = value = i$.next();
            ++i;
        }
        this.numberOfAttributes = attributes.size();
        this.attributeNames = new String[this.numberOfAttributes];
        this.attributeValues = new String[this.numberOfAttributes][];
        this.nominal = new boolean[this.numberOfAttributes];
        i = 0;
        for (Attribute attribute : attributes) {
            this.attributeNames[i] = attribute.getName();
            if (attribute.isNominal()) {
                this.nominal[i] = true;
                this.attributeValues[i] = new String[attribute.getMapping().size()];
                int j = 0;
                Iterator<String> i$2 = attribute.getMapping().getValues().iterator();
                while (i$2.hasNext()) {
                    String value;
                    this.attributeValues[i][j] = value = i$2.next();
                    ++j;
                }
            }
            ++i;
        }
        this.weightSums = weightSums;
        this.classWeights = classWeights;
        this.totalWeight = VectorMath.sum(classWeights);
        this.distributionProperties = new double[this.numberOfAttributes][this.numberOfClasses][];
        for (i = 0; i < this.numberOfAttributes; ++i) {
            for (int j = 0; j < this.numberOfClasses; ++j) {
                this.distributionProperties[i][j] = this.nominal[i] ? new double[this.attributeValues[i].length] : new double[3];
            }
        }
        this.priors = new double[this.numberOfClasses];
        this.updateDistributionProperties();
    }

    public SimpleDistributionModel(ExampleSet trainExampleSet) {
        this(trainExampleSet, true);
    }

    public SimpleDistributionModel(ExampleSet trainExampleSet, boolean laplaceCorrectionEnabled) {
        super(trainExampleSet);
        this.laplaceCorrectionEnabled = laplaceCorrectionEnabled;
        Attribute labelAttribute = trainExampleSet.getAttributes().getLabel();
        this.numberOfClasses = labelAttribute.getMapping().size();
        this.numberOfAttributes = trainExampleSet.getAttributes().size();
        this.nominal = new boolean[this.numberOfAttributes];
        this.attributeNames = new String[this.numberOfAttributes];
        this.attributeValues = new String[this.numberOfAttributes][];
        this.className = labelAttribute.getName();
        this.classValues = new String[this.numberOfClasses];
        for (int i = 0; i < this.numberOfClasses; ++i) {
            this.classValues[i] = labelAttribute.getMapping().mapIndex(i);
        }
        int attributeIndex = 0;
        this.weightSums = new double[this.numberOfAttributes][this.numberOfClasses][];
        this.distributionProperties = new double[this.numberOfAttributes][this.numberOfClasses][];
        for (Attribute attribute : trainExampleSet.getAttributes()) {
            this.attributeNames[attributeIndex] = attribute.getName();
            if (attribute.isNominal()) {
                int i;
                this.nominal[attributeIndex] = true;
                int mappingSize = attribute.getMapping().size() + 1;
                this.attributeValues[attributeIndex] = new String[mappingSize];
                for (i = 0; i < mappingSize - 1; ++i) {
                    this.attributeValues[attributeIndex][i] = attribute.getMapping().mapIndex(i);
                }
                this.attributeValues[attributeIndex][mappingSize - 1] = UNKNOWN_VALUE_NAME;
                for (i = 0; i < this.numberOfClasses; ++i) {
                    this.weightSums[attributeIndex][i] = new double[mappingSize];
                    this.distributionProperties[attributeIndex][i] = new double[mappingSize];
                }
            } else {
                this.nominal[attributeIndex] = false;
                for (int i = 0; i < this.numberOfClasses; ++i) {
                    this.weightSums[attributeIndex][i] = new double[3];
                    this.distributionProperties[attributeIndex][i] = new double[3];
                }
            }
            ++attributeIndex;
        }
        this.totalWeight = 0.0;
        this.classWeights = new double[this.numberOfClasses];
        this.priors = new double[this.numberOfClasses];
        this.update(trainExampleSet);
        this.updateDistributionProperties();
    }

    @Override
    public String[] getAttributeNames() {
        return this.attributeNames;
    }

    @Override
    public int getNumberOfAttributes() {
        return this.attributeNames.length;
    }

    @Override
    public void update(ExampleSet exampleSet) {
        Attribute weightAttribute = exampleSet.getAttributes().getWeight();
        for (Example example : exampleSet) {
            int classIndex;
            double weight = weightAttribute == null ? 1.0 : example.getWeight();
            this.totalWeight += weight;
            double labelValue = example.getLabel();
            if (Double.isNaN(labelValue)) continue;
            int n = classIndex = (int)example.getLabel();
            this.classWeights[n] = this.classWeights[n] + weight;
            int attributeIndex = 0;
            for (Attribute attribute : exampleSet.getAttributes()) {
                double attributeValue = example.getValue(attribute);
                if (this.nominal[attributeIndex]) {
                    if (!Double.isNaN(attributeValue)) {
                        if ((int)attributeValue < this.weightSums[attributeIndex][classIndex].length - 1) {
                            double[] dArray = this.weightSums[attributeIndex][classIndex];
                            int n2 = (int)attributeValue;
                            dArray[n2] = dArray[n2] + weight;
                        } else {
                            int i;
                            for (i = 0; i < this.numberOfClasses; ++i) {
                                double[] newWeightSums = new double[(int)attributeValue + 2];
                                newWeightSums[newWeightSums.length - 1] = this.weightSums[attributeIndex][i][this.weightSums[attributeIndex][i].length - 1];
                                for (int j = 0; j < this.weightSums[attributeIndex][i].length - 1; ++j) {
                                    newWeightSums[j] = this.weightSums[attributeIndex][i][j];
                                }
                                this.weightSums[attributeIndex][i] = newWeightSums;
                                this.distributionProperties[attributeIndex][i] = new double[(int)attributeValue + 2];
                            }
                            double[] dArray = this.weightSums[attributeIndex][classIndex];
                            int n3 = (int)attributeValue;
                            dArray[n3] = dArray[n3] + weight;
                            this.attributeValues[attributeIndex] = new String[(int)attributeValue + 2];
                            for (i = 0; i < this.attributeValues[attributeIndex].length - 1; ++i) {
                                this.attributeValues[attributeIndex][i] = attribute.getMapping().mapIndex(i);
                            }
                            this.attributeValues[attributeIndex][this.attributeValues[attributeIndex].length - 1] = UNKNOWN_VALUE_NAME;
                        }
                    } else {
                        double[] dArray = this.weightSums[attributeIndex][classIndex];
                        int n4 = this.weightSums[attributeIndex][classIndex].length - 1;
                        dArray[n4] = dArray[n4] + weight;
                    }
                } else if (attribute.isNumerical()) {
                    if (!Double.isNaN(attributeValue)) {
                        double[] dArray = this.weightSums[attributeIndex][classIndex];
                        dArray[0] = dArray[0] + weight * attributeValue;
                        double[] dArray2 = this.weightSums[attributeIndex][classIndex];
                        dArray2[1] = dArray2[1] + weight * attributeValue * attributeValue;
                    } else {
                        double[] dArray = this.weightSums[attributeIndex][classIndex];
                        dArray[2] = dArray[2] + weight;
                    }
                }
                ++attributeIndex;
            }
        }
        this.modelRecentlyUpdated = true;
    }

    private void updateDistributionProperties() {
        int i;
        double f = this.laplaceCorrectionEnabled ? 1.0 / this.totalWeight : Double.MIN_VALUE;
        double logFactorCoefficient = Math.sqrt(Math.PI * 2);
        for (i = 0; i < this.numberOfClasses; ++i) {
            this.priors[i] = Math.log(this.classWeights[i] / this.totalWeight);
        }
        for (i = 0; i < this.numberOfAttributes; ++i) {
            int j;
            if (this.nominal[i]) {
                for (j = 0; j < this.numberOfClasses; ++j) {
                    for (int k = 0; k < this.weightSums[i][j].length; ++k) {
                        this.distributionProperties[i][j][k] = Math.log((this.weightSums[i][j][k] + f) / (this.classWeights[j] + f * (double)this.weightSums[i][j].length));
                    }
                }
                continue;
            }
            for (j = 0; j < this.numberOfClasses; ++j) {
                double classWeight = this.classWeights[j] - this.weightSums[i][j][2];
                this.distributionProperties[i][j][0] = this.weightSums[i][j][0] / classWeight;
                double standardDeviationSquared = (this.weightSums[i][j][1] - this.weightSums[i][j][0] * this.weightSums[i][j][0] / classWeight) / (classWeight - 1.0);
                double standardDeviation = 0.001;
                if (standardDeviationSquared > 0.0 && (Double.isNaN(standardDeviation = Math.sqrt(standardDeviationSquared)) || standardDeviation <= 0.001)) {
                    standardDeviation = 0.001;
                }
                this.distributionProperties[i][j][1] = standardDeviation;
                this.distributionProperties[i][j][2] = Math.log(this.distributionProperties[i][j][1] * logFactorCoefficient);
            }
        }
        this.modelRecentlyUpdated = false;
    }

    public ExampleSet performPredictionOld(ExampleSet exampleSet, Attribute predictedLabel) {
        if (this.modelRecentlyUpdated) {
            this.updateDistributionProperties();
        }
        for (Example example : exampleSet) {
            int i;
            double[] probabilities = new double[this.numberOfClasses];
            double maxLogProbability = Double.NEGATIVE_INFINITY;
            double probabilitySum = 0.0;
            int mostProbableClass = 0;
            for (i = 0; i < this.numberOfClasses; ++i) {
                double logProbability = this.priors[i];
                if (!Double.isNaN(logProbability)) {
                    int j = 0;
                    for (Attribute attribute : exampleSet.getAttributes()) {
                        double value = example.getValue(attribute);
                        if (this.nominal[j]) {
                            logProbability = !Double.isNaN(value) && (int)value < this.distributionProperties[j][i].length ? (logProbability += this.distributionProperties[j][i][(int)value]) : (logProbability += this.distributionProperties[j][i][this.distributionProperties[j][i].length - 1]);
                        } else if (!Double.isNaN(value)) {
                            double base = (value - this.distributionProperties[j][i][0]) / this.distributionProperties[j][i][1];
                            logProbability -= this.distributionProperties[j][i][2] + 0.5 * (base * base);
                        }
                        ++j;
                    }
                    if (logProbability > maxLogProbability) {
                        maxLogProbability = logProbability;
                        mostProbableClass = i;
                    }
                    probabilities[i] = logProbability;
                    continue;
                }
                probabilities[i] = Double.NaN;
            }
            for (i = 0; i < this.numberOfClasses; ++i) {
                if (!Double.isNaN(probabilities[i])) {
                    probabilities[i] = Math.exp(probabilities[i] - maxLogProbability);
                    probabilitySum += probabilities[i];
                    continue;
                }
                probabilities[i] = 0.0;
            }
            if (maxLogProbability == Double.NEGATIVE_INFINITY) {
                example.setPredictedLabel(Double.NaN);
                for (i = 0; i < this.numberOfClasses; ++i) {
                    example.setConfidence(this.classValues[i], Double.NaN);
                }
                continue;
            }
            example.setPredictedLabel(mostProbableClass);
            for (i = 0; i < this.numberOfClasses; ++i) {
                example.setConfidence(this.classValues[i], probabilities[i] / probabilitySum);
            }
        }
        return exampleSet;
    }

    @Override
    public ExampleSet performPrediction(ExampleSet exampleSet, Attribute predictedLabel) {
        if (this.modelRecentlyUpdated) {
            this.updateDistributionProperties();
        }
        double[] probabilities = new double[this.numberOfClasses];
        for (Example example : exampleSet) {
            int i;
            double maxLogProbability = Double.NEGATIVE_INFINITY;
            double probabilitySum = 0.0;
            int mostProbableClass = 0;
            int j = 0;
            for (i = 0; i < this.numberOfClasses; ++i) {
                probabilities[i] = this.priors[i];
            }
            for (Attribute attribute : exampleSet.getAttributes()) {
                int i2;
                double value = example.getValue(attribute);
                if (this.nominal[j]) {
                    if (!Double.isNaN(value)) {
                        int intValue = (int)value;
                        for (int i3 = 0; i3 < this.numberOfClasses; ++i3) {
                            if (intValue >= this.distributionProperties[j][i3].length) continue;
                            int n = i3;
                            probabilities[n] = probabilities[n] + this.distributionProperties[j][i3][intValue];
                        }
                    } else {
                        for (i2 = 0; i2 < this.numberOfClasses; ++i2) {
                            int n = i2;
                            probabilities[n] = probabilities[n] + this.distributionProperties[j][i2][this.distributionProperties[j][i2].length - 1];
                        }
                    }
                } else if (!Double.isNaN(value)) {
                    for (i2 = 0; i2 < this.numberOfClasses; ++i2) {
                        double base = (value - this.distributionProperties[j][i2][0]) / this.distributionProperties[j][i2][1];
                        int n = i2;
                        probabilities[n] = probabilities[n] - (this.distributionProperties[j][i2][2] + 0.5 * base * base);
                    }
                }
                ++j;
            }
            for (i = 0; i < this.numberOfClasses; ++i) {
                if (Double.isNaN(probabilities[i]) || !(probabilities[i] > maxLogProbability)) continue;
                maxLogProbability = probabilities[i];
                mostProbableClass = i;
            }
            for (i = 0; i < this.numberOfClasses; ++i) {
                if (!Double.isNaN(probabilities[i])) {
                    probabilities[i] = Math.exp(probabilities[i] - maxLogProbability);
                    probabilitySum += probabilities[i];
                    continue;
                }
                probabilities[i] = 0.0;
            }
            if (maxLogProbability == Double.NEGATIVE_INFINITY) {
                example.setPredictedLabel(Double.NaN);
                for (i = 0; i < this.numberOfClasses; ++i) {
                    example.setConfidence(this.classValues[i], Double.NaN);
                }
                continue;
            }
            example.setPredictedLabel(mostProbableClass);
            for (i = 0; i < this.numberOfClasses; ++i) {
                example.setConfidence(this.classValues[i], probabilities[i] / probabilitySum);
            }
        }
        return exampleSet;
    }

    public void setLaplaceCorrectionEnabled(boolean laplaceCorrectionEnabled) {
        this.laplaceCorrectionEnabled = laplaceCorrectionEnabled;
    }

    public boolean getLaplaceCorrectionEnabled() {
        return this.laplaceCorrectionEnabled;
    }

    @Override
    public double getLowerBound(int attributeIndex) {
        if (!this.nominal[attributeIndex]) {
            double lowerBound = Double.POSITIVE_INFINITY;
            for (int i = 0; i < this.numberOfClasses; ++i) {
                double currentLowerBound = NormalDistribution.getLowerBound(this.distributionProperties[attributeIndex][i][0], this.distributionProperties[attributeIndex][i][1]);
                if (Double.isNaN(currentLowerBound)) continue;
                lowerBound = Math.min(lowerBound, currentLowerBound);
            }
            return lowerBound;
        }
        return Double.NaN;
    }

    @Override
    public double getUpperBound(int attributeIndex) {
        if (!this.nominal[attributeIndex]) {
            double upperBound = Double.NEGATIVE_INFINITY;
            for (int i = 0; i < this.numberOfClasses; ++i) {
                double currentUpperBound = NormalDistribution.getUpperBound(this.distributionProperties[attributeIndex][i][0], this.distributionProperties[attributeIndex][i][1]);
                if (Double.isNaN(currentUpperBound)) continue;
                upperBound = Math.max(upperBound, currentUpperBound);
            }
            return upperBound;
        }
        return Double.NaN;
    }

    @Override
    public boolean isDiscrete(int attributeIndex) {
        if (attributeIndex >= 0 && attributeIndex < this.nominal.length) {
            return this.nominal[attributeIndex];
        }
        return false;
    }

    @Override
    public Collection<Integer> getClassIndices() {
        ArrayList<Integer> classValueIndices = new ArrayList<Integer>(this.numberOfClasses);
        for (int i = 0; i < this.numberOfClasses; ++i) {
            classValueIndices.add(i);
        }
        return classValueIndices;
    }

    @Override
    public int getNumberOfClasses() {
        return this.numberOfClasses;
    }

    @Override
    public String getClassName(int index) {
        return this.classValues[index];
    }

    public double[] getRawDistributionParameter(int classIndex, int attributeIndex) {
        return this.distributionProperties[attributeIndex][classIndex];
    }

    @Override
    public Distribution getDistribution(int classIndex, int attributeIndex) {
        if (this.nominal[attributeIndex]) {
            double[] probabilities = new double[this.distributionProperties[attributeIndex][classIndex].length];
            for (int i = 0; i < probabilities.length; ++i) {
                probabilities[i] = Math.exp(this.distributionProperties[attributeIndex][classIndex][i]);
            }
            return new DiscreteDistribution(this.attributeNames[attributeIndex], probabilities, this.attributeValues[attributeIndex]);
        }
        return new NormalDistribution(this.distributionProperties[attributeIndex][classIndex][0], this.distributionProperties[attributeIndex][classIndex][1]);
    }

    public double getTotalWeight() {
        return this.totalWeight;
    }

    public double[] getClassWeights() {
        return this.classWeights;
    }

    public double[] getAprioriProbabilities() {
        return this.priors;
    }

    @Override
    public String toString() {
        if (this.modelRecentlyUpdated) {
            this.updateDistributionProperties();
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("Distribution model for label attribute " + this.className);
        buffer.append(Tools.getLineSeparators(2));
        for (int i = 0; i < this.numberOfClasses; ++i) {
            String classTitle = "Class " + this.classValues[i] + " (" + Tools.formatNumber(Math.exp(this.priors[i])) + ")";
            buffer.append(Tools.getLineSeparator());
            buffer.append(classTitle);
            buffer.append(Tools.getLineSeparator());
            buffer.append(this.attributeNames.length + " distributions");
            buffer.append(Tools.getLineSeparator());
        }
        return buffer.toString();
    }
}

