/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.bayes;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.OperatorCapability;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.annotation.ResourceConsumptionEstimator;
import com.rapidminer.operator.learner.AbstractLearner;
import com.rapidminer.operator.learner.PredictionModel;
import com.rapidminer.operator.learner.bayes.DistributionModel;
import com.rapidminer.operator.learner.bayes.SimpleDistributionModel;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.tools.OperatorResourceConsumptionHandler;
import java.util.List;

public class NaiveBayes
extends AbstractLearner {
    public static final String PARAMETER_LAPLACE_CORRECTION = "laplace_correction";

    public NaiveBayes(OperatorDescription description) {
        super(description);
    }

    @Override
    public Model learn(ExampleSet exampleSet) throws OperatorException {
        return new SimpleDistributionModel(exampleSet, this.getParameterAsBoolean(PARAMETER_LAPLACE_CORRECTION));
    }

    @Override
    public Class<? extends PredictionModel> getModelClass() {
        return DistributionModel.class;
    }

    @Override
    public boolean supportsCapability(OperatorCapability lc) {
        switch (lc) {
            case POLYNOMINAL_ATTRIBUTES: 
            case BINOMINAL_ATTRIBUTES: 
            case NUMERICAL_ATTRIBUTES: 
            case POLYNOMINAL_LABEL: 
            case BINOMINAL_LABEL: 
            case WEIGHTED_EXAMPLES: 
            case UPDATABLE: 
            case MISSING_VALUES: {
                return true;
            }
        }
        return false;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeBoolean type = new ParameterTypeBoolean(PARAMETER_LAPLACE_CORRECTION, "Use Laplace correction to prevent high influence of zero probabilities.", true, false);
        type.setExpert(true);
        types.add(type);
        return types;
    }

    @Override
    public ResourceConsumptionEstimator getResourceConsumptionEstimator() {
        return OperatorResourceConsumptionHandler.getResourceConsumptionEstimator(this.getExampleSetInputPort(), NaiveBayes.class, null);
    }
}

