/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.bayes;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.learner.bayes.DistributionModel;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.math.distribution.DiscreteDistribution;
import com.rapidminer.tools.math.distribution.Distribution;
import com.rapidminer.tools.math.distribution.kernel.FullKernelDistribution;
import com.rapidminer.tools.math.distribution.kernel.GreedyKernelDistribution;
import com.rapidminer.tools.math.distribution.kernel.KernelDistribution;
import java.util.ArrayList;
import java.util.Collection;

public class KernelDistributionModel
extends DistributionModel {
    private static final long serialVersionUID = -402827845291958569L;
    private static final String UNKNOWN_VALUE_NAME = "unknown";
    private int numberOfClasses;
    private int numberOfAttributes;
    private boolean[] nominal;
    private String className;
    private String[] classValues;
    private String[] attributeNames;
    private String[][] attributeValues;
    private double totalWeight;
    private double[] classWeights;
    private double[][][] weightSums;
    private double[] priors;
    private double[][][] distributionProperties;
    private KernelDistribution[][] kernelDistributions;
    boolean laplaceCorrectionEnabled;
    private boolean modelRecentlyUpdated;
    private boolean useApplianceGrid;
    private double[][][] grid;
    private int gridSize = 200;

    public KernelDistributionModel(ExampleSet exampleSet, boolean laplaceCorrectionEnabled, int estimationMode, int bandwidthSelectionMode, double bandwidth, int numberOfKernels, int gridSize) {
        super(exampleSet);
        this.laplaceCorrectionEnabled = laplaceCorrectionEnabled;
        this.useApplianceGrid = gridSize > 10;
        this.gridSize = gridSize;
        Attribute labelAttribute = exampleSet.getAttributes().getLabel();
        this.numberOfClasses = labelAttribute.getMapping().size();
        this.numberOfAttributes = exampleSet.getAttributes().size();
        this.nominal = new boolean[this.numberOfAttributes];
        this.attributeNames = new String[this.numberOfAttributes];
        this.attributeValues = new String[this.numberOfAttributes][];
        this.className = labelAttribute.getName();
        this.classValues = new String[this.numberOfClasses];
        for (int i = 0; i < this.numberOfClasses; ++i) {
            this.classValues[i] = labelAttribute.getMapping().mapIndex(i);
        }
        int attributeIndex = 0;
        this.weightSums = new double[this.numberOfAttributes][this.numberOfClasses][];
        this.distributionProperties = new double[this.numberOfAttributes][this.numberOfClasses][];
        this.kernelDistributions = new KernelDistribution[this.numberOfAttributes][this.numberOfClasses];
        for (Attribute attribute : exampleSet.getAttributes()) {
            this.attributeNames[attributeIndex] = attribute.getName();
            if (attribute.isNominal()) {
                int i;
                this.nominal[attributeIndex] = true;
                int mappingSize = attribute.getMapping().size() + 1;
                this.attributeValues[attributeIndex] = new String[mappingSize];
                for (i = 0; i < mappingSize - 1; ++i) {
                    this.attributeValues[attributeIndex][i] = attribute.getMapping().mapIndex(i);
                }
                this.attributeValues[attributeIndex][mappingSize - 1] = UNKNOWN_VALUE_NAME;
                for (i = 0; i < this.numberOfClasses; ++i) {
                    this.weightSums[attributeIndex][i] = new double[mappingSize];
                    this.distributionProperties[attributeIndex][i] = new double[mappingSize];
                }
            } else {
                this.nominal[attributeIndex] = false;
                block12: for (int i = 0; i < this.numberOfClasses; ++i) {
                    switch (estimationMode) {
                        case 0: {
                            switch (bandwidthSelectionMode) {
                                case 0: {
                                    this.kernelDistributions[attributeIndex][i] = new FullKernelDistribution();
                                    break;
                                }
                                case 1: {
                                    this.kernelDistributions[attributeIndex][i] = new FullKernelDistribution(bandwidth);
                                }
                            }
                            continue block12;
                        }
                        case 1: {
                            this.kernelDistributions[attributeIndex][i] = new GreedyKernelDistribution(bandwidth, numberOfKernels);
                            continue block12;
                        }
                        default: {
                            this.kernelDistributions[attributeIndex][i] = new FullKernelDistribution();
                        }
                    }
                }
            }
            ++attributeIndex;
        }
        this.totalWeight = 0.0;
        this.classWeights = new double[this.numberOfClasses];
        this.priors = new double[this.numberOfClasses];
        if (this.useApplianceGrid) {
            this.grid = new double[this.numberOfAttributes][this.numberOfClasses][];
        }
        this.update(exampleSet);
        this.updateDistributionProperties();
    }

    @Override
    public String[] getAttributeNames() {
        return this.attributeNames;
    }

    @Override
    public int getNumberOfAttributes() {
        return this.attributeNames.length;
    }

    @Override
    public void update(ExampleSet exampleSet) {
        Attribute weightAttribute = exampleSet.getAttributes().getWeight();
        for (Example example : exampleSet) {
            int classIndex;
            double weight = weightAttribute == null ? 1.0 : example.getWeight();
            this.totalWeight += weight;
            double labelValue = example.getLabel();
            if (Double.isNaN(labelValue)) continue;
            int n = classIndex = (int)example.getLabel();
            this.classWeights[n] = this.classWeights[n] + weight;
            int attributeIndex = 0;
            for (Attribute attribute : exampleSet.getAttributes()) {
                double attributeValue = example.getValue(attribute);
                if (this.nominal[attributeIndex]) {
                    if (!Double.isNaN(attributeValue)) {
                        if ((int)attributeValue < this.weightSums[attributeIndex][classIndex].length - 1) {
                            double[] dArray = this.weightSums[attributeIndex][classIndex];
                            int n2 = (int)attributeValue;
                            dArray[n2] = dArray[n2] + weight;
                        } else {
                            int i;
                            for (i = 0; i < this.numberOfClasses; ++i) {
                                double[] newWeightSums = new double[(int)attributeValue + 2];
                                newWeightSums[newWeightSums.length - 1] = this.weightSums[attributeIndex][i][this.weightSums[attributeIndex][i].length - 1];
                                for (int j = 0; j < this.weightSums[attributeIndex][i].length - 1; ++j) {
                                    newWeightSums[j] = this.weightSums[attributeIndex][i][j];
                                }
                                this.weightSums[attributeIndex][i] = newWeightSums;
                                this.distributionProperties[attributeIndex][i] = new double[(int)attributeValue + 2];
                            }
                            double[] dArray = this.weightSums[attributeIndex][classIndex];
                            int n3 = (int)attributeValue;
                            dArray[n3] = dArray[n3] + weight;
                            this.attributeValues[attributeIndex] = new String[(int)attributeValue + 2];
                            for (i = 0; i < this.attributeValues[attributeIndex].length - 1; ++i) {
                                this.attributeValues[attributeIndex][i] = attribute.getMapping().mapIndex(i);
                            }
                            this.attributeValues[attributeIndex][this.attributeValues[attributeIndex].length - 1] = UNKNOWN_VALUE_NAME;
                        }
                    } else {
                        double[] dArray = this.weightSums[attributeIndex][classIndex];
                        int n4 = this.weightSums[attributeIndex][classIndex].length - 1;
                        dArray[n4] = dArray[n4] + weight;
                    }
                } else if (!Double.isNaN(attributeValue)) {
                    this.kernelDistributions[attributeIndex][classIndex].update(attributeValue, weight);
                }
                ++attributeIndex;
            }
        }
        this.modelRecentlyUpdated = true;
    }

    private void updateDistributionProperties() {
        int j;
        int i;
        double f = this.laplaceCorrectionEnabled ? 1.0 / this.totalWeight : Double.MIN_VALUE;
        for (i = 0; i < this.numberOfClasses; ++i) {
            this.priors[i] = Math.log(this.classWeights[i] / this.totalWeight);
        }
        for (i = 0; i < this.numberOfAttributes; ++i) {
            if (!this.nominal[i]) continue;
            for (j = 0; j < this.numberOfClasses; ++j) {
                for (int k = 0; k < this.weightSums[i][j].length; ++k) {
                    this.distributionProperties[i][j][k] = Math.log((this.weightSums[i][j][k] + f) / (this.classWeights[j] + f * (double)this.weightSums[i][j].length));
                }
            }
        }
        if (this.useApplianceGrid) {
            for (i = 0; i < this.numberOfClasses; ++i) {
                for (j = 0; j < this.numberOfAttributes; ++j) {
                    if (this.nominal[j]) continue;
                    double lowerBound = this.kernelDistributions[j][i].getLowerBound();
                    double upperBound = this.kernelDistributions[j][i].getUpperBound();
                    double precision = (upperBound - lowerBound) / (double)this.gridSize;
                    this.grid[j][i] = new double[this.gridSize + 1];
                    for (int k = 0; k < this.gridSize + 1; ++k) {
                        this.grid[j][i][k] = this.kernelDistributions[j][i].getProbability(lowerBound + (double)k * precision);
                    }
                }
            }
        }
        this.modelRecentlyUpdated = false;
    }

    @Override
    public ExampleSet performPrediction(ExampleSet exampleSet, Attribute predictedLabel) {
        if (this.modelRecentlyUpdated) {
            this.updateDistributionProperties();
        }
        for (Example example : exampleSet) {
            int i;
            double[] probabilities = new double[this.numberOfClasses];
            double maxLogProbability = Double.NEGATIVE_INFINITY;
            int mostProbableClass = 0;
            double probabilitySum = 0.0;
            for (i = 0; i < this.numberOfClasses; ++i) {
                double logProbability = this.priors[i];
                int j = 0;
                for (Attribute attribute : exampleSet.getAttributes()) {
                    double value = example.getValue(attribute);
                    if (this.nominal[j]) {
                        logProbability = !Double.isNaN(value) && (int)value < this.distributionProperties[j][i].length ? (logProbability += this.distributionProperties[j][i][(int)value]) : (logProbability += this.distributionProperties[j][i][this.distributionProperties[j][i].length - 1]);
                    } else if (!Double.isNaN(value)) {
                        if (this.useApplianceGrid) {
                            double upperBound = this.kernelDistributions[j][i].getUpperBound();
                            double lowerBound = this.kernelDistributions[j][i].getLowerBound();
                            double precision = (upperBound - lowerBound) / (double)this.gridSize;
                            logProbability = value >= lowerBound && value <= this.kernelDistributions[j][i].getUpperBound() ? (logProbability += Math.log(this.grid[j][i][(int)((value - lowerBound) / precision)])) : (logProbability += Math.log(this.kernelDistributions[j][i].getProbability(value)));
                        } else {
                            logProbability += Math.log(this.kernelDistributions[j][i].getProbability(value));
                        }
                    }
                    ++j;
                }
                if (!Double.isNaN(logProbability) && logProbability > maxLogProbability) {
                    maxLogProbability = logProbability;
                    mostProbableClass = i;
                }
                probabilities[i] = logProbability;
            }
            for (i = 0; i < this.numberOfClasses; ++i) {
                if (!Double.isNaN(probabilities[i])) {
                    probabilities[i] = Math.exp(probabilities[i] - maxLogProbability);
                    probabilitySum += probabilities[i];
                    continue;
                }
                probabilities[i] = 0.0;
            }
            if (maxLogProbability == Double.NEGATIVE_INFINITY) {
                example.setPredictedLabel(Double.NaN);
                for (i = 0; i < this.numberOfClasses; ++i) {
                    example.setConfidence(this.classValues[i], Double.NaN);
                }
                continue;
            }
            example.setPredictedLabel(mostProbableClass);
            for (i = 0; i < this.numberOfClasses; ++i) {
                example.setConfidence(this.classValues[i], probabilities[i] / probabilitySum);
            }
        }
        return exampleSet;
    }

    public void setLaplaceCorrectionEnabled(boolean laplaceCorrectionEnabled) {
        this.laplaceCorrectionEnabled = laplaceCorrectionEnabled;
    }

    public boolean getLaplaceCorrectionEnabled() {
        return this.laplaceCorrectionEnabled;
    }

    @Override
    public double getLowerBound(int attributeIndex) {
        if (!this.nominal[attributeIndex]) {
            double lowerBound = Double.POSITIVE_INFINITY;
            for (int i = 0; i < this.numberOfClasses; ++i) {
                double currentLowerBound = this.kernelDistributions[attributeIndex][i].getLowerBound();
                if (Double.isNaN(currentLowerBound)) continue;
                lowerBound = Math.min(lowerBound, currentLowerBound);
            }
            return lowerBound;
        }
        return Double.NaN;
    }

    @Override
    public double getUpperBound(int attributeIndex) {
        if (!this.nominal[attributeIndex]) {
            double upperBound = Double.NEGATIVE_INFINITY;
            for (int i = 0; i < this.numberOfClasses; ++i) {
                double currentUpperBound = this.kernelDistributions[attributeIndex][i].getUpperBound();
                if (Double.isNaN(currentUpperBound)) continue;
                upperBound = Math.max(upperBound, currentUpperBound);
            }
            return upperBound;
        }
        return Double.NaN;
    }

    @Override
    public boolean isDiscrete(int attributeIndex) {
        if (attributeIndex >= 0 && attributeIndex < this.nominal.length) {
            return this.nominal[attributeIndex];
        }
        return false;
    }

    @Override
    public Collection<Integer> getClassIndices() {
        ArrayList<Integer> classValueIndices = new ArrayList<Integer>(this.numberOfClasses);
        for (int i = 0; i < this.numberOfClasses; ++i) {
            classValueIndices.add(i);
        }
        return classValueIndices;
    }

    @Override
    public int getNumberOfClasses() {
        return this.numberOfClasses;
    }

    @Override
    public String getClassName(int index) {
        return this.classValues[index];
    }

    @Override
    public Distribution getDistribution(int classIndex, int attributeIndex) {
        if (this.nominal[attributeIndex]) {
            double[] probabilities = new double[this.distributionProperties[attributeIndex][classIndex].length];
            for (int i = 0; i < probabilities.length; ++i) {
                probabilities[i] = Math.exp(this.distributionProperties[attributeIndex][classIndex][i]);
            }
            return new DiscreteDistribution(this.attributeNames[attributeIndex], probabilities, this.attributeValues[attributeIndex]);
        }
        return this.kernelDistributions[attributeIndex][classIndex];
    }

    @Override
    public String toString() {
        if (this.modelRecentlyUpdated) {
            this.updateDistributionProperties();
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("Distribution model for label attribute " + this.className);
        buffer.append(Tools.getLineSeparators(2));
        for (int i = 0; i < this.numberOfClasses; ++i) {
            String classTitle = "Class " + this.classValues[i] + " (" + Tools.formatNumber(Math.exp(this.priors[i])) + ")";
            buffer.append(Tools.getLineSeparator());
            buffer.append(classTitle);
            buffer.append(Tools.getLineSeparator());
            buffer.append(this.attributeNames.length + " distributions");
            buffer.append(Tools.getLineSeparator());
        }
        return buffer.toString();
    }
}

