/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.associations.gsp;

import com.rapidminer.operator.learner.associations.gsp.Item;
import com.rapidminer.operator.learner.associations.gsp.Transaction;
import java.util.ArrayList;
import java.util.Iterator;

public class Sequence
extends ArrayList<Transaction>
implements Comparable<Sequence> {
    private static final long serialVersionUID = -5774432548086375L;

    public Sequence() {
    }

    public Sequence(Sequence sequence) {
        this.addAll(sequence);
    }

    public int getNumberOfItems() {
        int size = 0;
        for (Transaction transaction : this) {
            size += transaction.size();
        }
        return size;
    }

    public Item getItem(int n) {
        for (Transaction transaction : this) {
            if (n - transaction.size() < 0) {
                return (Item)transaction.get(n);
            }
            n -= transaction.size();
        }
        return null;
    }

    public Transaction getLastTransaction() {
        return (Transaction)this.get(this.size() - 1);
    }

    public boolean equals(int ignoreOwnElement, Sequence sequence, int ignoreItsElement) {
        Item itsItem;
        Item ownItem;
        int ownIndex = 0;
        int itsIndex = 0;
        Iterator<Item> ownIterator = this.itemIterator();
        Iterator<Item> itsIterator = sequence.itemIterator();
        do {
            if (ignoreOwnElement == ownIndex) {
                ownIterator.next();
                ++ownIndex;
            }
            if (ignoreItsElement == itsIndex) {
                itsIterator.next();
                ++itsIndex;
            }
            if (!ownIterator.hasNext() || !itsIterator.hasNext()) {
                return !ownIterator.hasNext() && !itsIterator.hasNext();
            }
            ownItem = ownIterator.next();
            itsItem = itsIterator.next();
            ++ownIndex;
            ++itsIndex;
        } while (ownItem.equals(itsItem));
        return false;
    }

    public Iterator<Item> itemIterator() {
        return new Iterator<Item>(){
            private Iterator<Transaction> transactionIterator;
            private Iterator<Item> itemIterator;
            {
                this.transactionIterator = Sequence.this.iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.transactionIterator.hasNext()) {
                    return true;
                }
                return this.itemIterator != null && this.itemIterator.hasNext();
            }

            @Override
            public Item next() {
                if (this.itemIterator == null) {
                    this.itemIterator = this.transactionIterator.next().iterator();
                }
                if (!this.itemIterator.hasNext()) {
                    this.itemIterator = this.transactionIterator.next().iterator();
                }
                return this.itemIterator.next();
            }

            @Override
            public void remove() {
            }
        };
    }

    public static Sequence appendTransaction(Sequence sequence1, Transaction lastTransaction) {
        Sequence result = new Sequence(sequence1);
        result.add(lastTransaction);
        return result;
    }

    public static Sequence appendItem(Sequence sequence1, Item lastItem) {
        Sequence result = new Sequence(sequence1);
        int lastIndex = result.size() - 1;
        Transaction newTransaction = new Transaction((Transaction)result.get(lastIndex));
        result.remove(lastIndex);
        newTransaction.add(lastItem);
        result.add(newTransaction);
        return result;
    }

    public static Sequence removeItem(Sequence candidate, int transactionIndex, int itemIndex) {
        Sequence result = new Sequence(candidate);
        Transaction newTransaction = new Transaction((Transaction)result.get(transactionIndex));
        newTransaction.remove(itemIndex);
        if (newTransaction.size() > 0) {
            result.set(transactionIndex, newTransaction);
        } else {
            result.remove(transactionIndex);
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (Transaction transaction : this) {
            buffer.append("<" + transaction.toString() + ">  ");
        }
        return buffer.toString();
    }

    @Override
    public int compareTo(Sequence o) {
        int mySize;
        int itsSize = o.getNumberOfItems();
        if (itsSize == (mySize = this.getNumberOfItems())) {
            Iterator<Item> myItem = this.itemIterator();
            Iterator<Item> itsItem = o.itemIterator();
            while (myItem.hasNext() && itsItem.hasNext()) {
                int myIndex;
                int itsIndex = itsItem.next().getIndex();
                if (itsIndex == (myIndex = myItem.next().getIndex())) continue;
                return myIndex > itsIndex ? 1 : -1;
            }
            return 0;
        }
        return mySize > itsSize ? 1 : -1;
    }
}

