/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.associations.gsp;

import com.rapidminer.operator.learner.associations.gsp.CountingInformations;
import com.rapidminer.operator.learner.associations.gsp.DataSequence;
import com.rapidminer.operator.learner.associations.gsp.HashTreeInnerNode;
import com.rapidminer.operator.learner.associations.gsp.HashTreeNode;
import com.rapidminer.operator.learner.associations.gsp.Item;
import com.rapidminer.operator.learner.associations.gsp.Sequence;
import java.util.ArrayList;

public class HashTreeLeafNode
implements HashTreeNode {
    private int[] candidateIndices = new int[128];
    private int candidateIndicesSize = 0;

    @Override
    public void addSequence(Sequence candidate, int candidateIndex, int depth, HashTreeNode father, ArrayList<Sequence> allCandidates) {
        ++this.candidateIndicesSize;
        if (this.candidateIndicesSize > this.candidateIndices.length) {
            if (depth < candidate.size() - 1) {
                HashTreeInnerNode newInner = new HashTreeInnerNode();
                father.replaceNode(candidate.getItem(depth - 1), newInner);
                for (int i = 0; i < this.candidateIndices.length; ++i) {
                    newInner.addSequence(allCandidates.get(this.candidateIndices[i]), this.candidateIndices[i], depth, father, allCandidates);
                }
                newInner.addSequence(allCandidates.get(candidateIndex), candidateIndex, depth, father, allCandidates);
            } else {
                int[] newIndices = new int[this.candidateIndices.length * 2];
                System.arraycopy(this.candidateIndices, 0, newIndices, 0, this.candidateIndices.length);
                this.candidateIndices = newIndices;
                this.candidateIndices[this.candidateIndicesSize - 1] = candidateIndex;
            }
        } else {
            this.candidateIndices[this.candidateIndicesSize - 1] = candidateIndex;
        }
    }

    @Override
    public void countCoveredCandidates(DataSequence sequence, double t, CountingInformations counting) {
        for (int i = 0; i < this.candidateIndicesSize; ++i) {
            counting.candidateCounter[this.candidateIndices[i]] = DataSequence.containsSequence(sequence, counting.allCandidates.get(this.candidateIndices[i]), counting);
        }
    }

    @Override
    public void replaceNode(Item which, HashTreeNode replacement) {
    }
}

