/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.associations.gsp;

import com.rapidminer.operator.learner.associations.gsp.CountingInformations;
import com.rapidminer.operator.learner.associations.gsp.DataSequence;
import com.rapidminer.operator.learner.associations.gsp.HashTreeLeafNode;
import com.rapidminer.operator.learner.associations.gsp.HashTreeNode;
import com.rapidminer.operator.learner.associations.gsp.Item;
import com.rapidminer.operator.learner.associations.gsp.Sequence;
import com.rapidminer.operator.learner.associations.gsp.Transaction;
import java.util.ArrayList;
import java.util.HashMap;

public class HashTreeInnerNode
implements HashTreeNode {
    protected HashMap<Item, HashTreeNode> children = new HashMap();

    @Override
    public void addSequence(Sequence candidate, int candidateIndex, int depth, HashTreeNode father, ArrayList<Sequence> allCandidates) {
        Item currentDepthItem = candidate.getItem(depth);
        HashTreeNode child = this.children.get(currentDepthItem);
        if (child == null) {
            child = new HashTreeLeafNode();
            this.children.put(currentDepthItem, child);
        }
        child.addSequence(candidate, candidateIndex, depth + 1, this, allCandidates);
    }

    @Override
    public void replaceNode(Item whichItem, HashTreeNode replacement) {
        this.children.put(whichItem, replacement);
    }

    @Override
    public void countCoveredCandidates(DataSequence sequence, double t, CountingInformations counting) {
        double minTransactionTime = t - counting.windowSize;
        double maxTransactionTime = t + Math.max(counting.windowSize, counting.maxGap);
        for (Transaction transaction : sequence) {
            double transactionTime = transaction.getTime();
            if (!(transactionTime < maxTransactionTime) || !(transactionTime > minTransactionTime)) continue;
            for (Item item : transaction) {
                HashTreeNode child = this.children.get(item);
                if (child == null) continue;
                child.countCoveredCandidates(sequence, transactionTime, counting);
            }
        }
    }
}

