/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.associations.gsp;

import com.rapidminer.operator.ResultObjectAdapter;
import com.rapidminer.operator.learner.associations.gsp.Sequence;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.container.Tupel;
import java.util.TreeSet;

public class GSPSet
extends ResultObjectAdapter {
    private static final long serialVersionUID = 4739128489323129098L;
    private TreeSet<Tupel<Sequence, Double>> sequences = new TreeSet();
    private int maxTransactions = 0;

    public void addSequence(Sequence sequence, double support) {
        this.sequences.add(new Tupel<Sequence, Double>(sequence, support));
        this.maxTransactions = Math.max(this.maxTransactions, sequence.size());
    }

    public int getMaxTransactions() {
        return this.maxTransactions;
    }

    public int getNumberOfSequences() {
        return this.sequences.size();
    }

    public Sequence[] getSequenceArray() {
        Sequence[] sequences = new Sequence[this.sequences.size()];
        int i = 0;
        for (Tupel<Sequence, Double> tupel : this.sequences) {
            sequences[i] = tupel.getFirst();
            ++i;
        }
        return sequences;
    }

    public double[] getSupportArray() {
        double[] supports = new double[this.sequences.size()];
        int i = 0;
        for (Tupel<Sequence, Double> tupel : this.sequences) {
            supports[i] = tupel.getSecond();
            ++i;
        }
        return supports;
    }

    public String toString() {
        return "Set of generalized sequential patterns" + Tools.getLineSeparator() + "Set contains " + this.sequences.size() + " patterns.";
    }

    @Override
    public String toResultString() {
        StringBuffer buffer = new StringBuffer();
        for (Tupel<Sequence, Double> sequencePair : this.sequences) {
            buffer.append(Tools.formatNumber(sequencePair.getSecond(), 3) + ": " + sequencePair.getFirst().toString() + Tools.getLineSeparator());
        }
        return buffer.toString();
    }
}

