/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.associations.gsp;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.example.set.SortedExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.learner.associations.gsp.CountingInformations;
import com.rapidminer.operator.learner.associations.gsp.DataSequence;
import com.rapidminer.operator.learner.associations.gsp.GSPSet;
import com.rapidminer.operator.learner.associations.gsp.HashTreeRootNode;
import com.rapidminer.operator.learner.associations.gsp.Item;
import com.rapidminer.operator.learner.associations.gsp.Sequence;
import com.rapidminer.operator.learner.associations.gsp.Transaction;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.AttributeParameterPrecondition;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.SimplePrecondition;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Ontology;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;

public class GSPOperator
extends Operator {
    public static final String TIME_ROLE = "time";
    public static final String CUSTOMER_ROLE = "customer";
    public static final String PARAMETER_CUSTOMER_ATTRIBUTE = "customer_id";
    public static final String PARAMETER_TIME_ATTRIBUTE = "time_attribute";
    public static final String PARAMETER_WINDOW_SIZE = "window_size";
    public static final String PARAMETER_MAX_GAP = "max_gap";
    public static final String PARAMETER_MIN_GAP = "min_gap";
    public static final String PARAMETER_POSITIVE_VALUE = "positive_value";
    public static final String PARAMETER_MIN_SUPPORT = "min_support";
    private InputPort exampleSetInput = (InputPort)this.getInputPorts().createPort("example set");
    private OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set");
    private OutputPort patternOutput = (OutputPort)this.getOutputPorts().createPort("patterns");

    public GSPOperator(OperatorDescription description) {
        super(description);
        this.exampleSetInput.addPrecondition(new SimplePrecondition(this.exampleSetInput, new ExampleSetMetaData(), true){

            @Override
            public void makeAdditionalChecks(MetaData metaData) {
                if (metaData instanceof ExampleSetMetaData) {
                    ExampleSetMetaData emd = (ExampleSetMetaData)metaData;
                    String customerAttribute = "";
                    String timeAttribute = "";
                    try {
                        customerAttribute = GSPOperator.this.getParameterAsString(GSPOperator.PARAMETER_CUSTOMER_ATTRIBUTE);
                        timeAttribute = GSPOperator.this.getParameterAsString(GSPOperator.PARAMETER_TIME_ATTRIBUTE);
                    }
                    catch (UndefinedParameterError e) {
                        // empty catch block
                    }
                    for (AttributeMetaData amd : emd.getAllAttributes()) {
                        if (amd.isSpecial() || amd.getName().equals(customerAttribute) || amd.getName().equals(timeAttribute) || Ontology.ATTRIBUTE_VALUE_TYPE.isA(amd.getValueType(), 1)) continue;
                        this.createError(ProcessSetupError.Severity.ERROR, "regular_type_mismatch", Ontology.ATTRIBUTE_VALUE_TYPE.mapIndex(6));
                        break;
                    }
                }
            }
        });
        this.exampleSetInput.addPrecondition(new AttributeParameterPrecondition(this.exampleSetInput, this, PARAMETER_CUSTOMER_ATTRIBUTE));
        this.exampleSetInput.addPrecondition(new AttributeParameterPrecondition(this.exampleSetInput, this, PARAMETER_TIME_ATTRIBUTE, 2));
        this.getTransformer().addPassThroughRule(this.exampleSetInput, this.exampleSetOutput);
        this.getTransformer().addGenerationRule(this.patternOutput, GSPSet.class);
    }

    @Override
    public void doWork() throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)this.exampleSetInput.getData();
        Attributes attributes = exampleSet.getAttributes();
        String timeAttributeName = this.getParameterAsString(PARAMETER_TIME_ATTRIBUTE);
        String customerAttributeName = this.getParameterAsString(PARAMETER_CUSTOMER_ATTRIBUTE);
        if (timeAttributeName.equals("")) {
            throw new UserError((Operator)this, 205, PARAMETER_TIME_ATTRIBUTE);
        }
        if (customerAttributeName.equals("")) {
            throw new UserError((Operator)this, 205, PARAMETER_CUSTOMER_ATTRIBUTE);
        }
        double minSupport = this.getParameterAsDouble(PARAMETER_MIN_SUPPORT);
        double maxGap = this.getParameterAsDouble(PARAMETER_MAX_GAP);
        double minGap = this.getParameterAsDouble(PARAMETER_MIN_GAP);
        double windowSize = this.getParameterAsDouble(PARAMETER_WINDOW_SIZE);
        Attribute timeAttribute = attributes.get(timeAttributeName);
        Attribute customerAttribute = attributes.get(customerAttributeName);
        if (timeAttribute == null) {
            throw new UserError((Operator)this, 111, timeAttributeName);
        }
        if (customerAttribute == null) {
            throw new UserError((Operator)this, 111, customerAttributeName);
        }
        if (!timeAttribute.isNumerical()) {
            throw new UserError((Operator)this, 144, timeAttribute.getName(), "GSP");
        }
        attributes.setSpecialAttribute(timeAttribute, TIME_ROLE);
        attributes.setSpecialAttribute(customerAttribute, CUSTOMER_ROLE);
        Tools.onlyNominalAttributes(exampleSet, "GSP");
        double[] positiveIndices = new double[attributes.size()];
        Arrays.fill(positiveIndices, 1.0);
        if (this.isParameterSet(PARAMETER_POSITIVE_VALUE)) {
            int attributeIndex = 0;
            for (Attribute attribute : attributes) {
                positiveIndices[attributeIndex] = attribute.getMapping().mapString(this.getParameterAsString(PARAMETER_POSITIVE_VALUE));
                ++attributeIndex;
            }
        }
        Item[] items = new Item[attributes.size()];
        int i = 0;
        for (Attribute attribute : attributes) {
            items[i] = new Item(attribute.getName(), i);
            ++i;
        }
        ArrayList<DataSequence> dataSequences = this.buildSequences(exampleSet, attributes, timeAttribute, customerAttribute, positiveIndices, items);
        double numberOfSequences = dataSequences.size();
        if (numberOfSequences * minSupport < 5.0) {
            LogService.getGlobal().log("Found only " + numberOfSequences + " sequences. Together with the small minimal support, this could result in very many patterns and a long calculation time.", 5);
        }
        int minFrequency = (int)Math.floor(numberOfSequences * minSupport);
        LinkedHashSet<Item> frequentItems = this.findFrequentItems(dataSequences, items, minFrequency);
        Iterator<DataSequence> sequenceIterator = dataSequences.iterator();
        while (sequenceIterator.hasNext()) {
            DataSequence sequence = sequenceIterator.next();
            Iterator transactionIterator = sequence.iterator();
            while (transactionIterator.hasNext()) {
                Transaction transaction = (Transaction)transactionIterator.next();
                Iterator itemIterator = transaction.iterator();
                while (itemIterator.hasNext()) {
                    Item item = (Item)itemIterator.next();
                    if (frequentItems.contains(item)) continue;
                    itemIterator.remove();
                }
                if (!transaction.isEmpty()) continue;
                transactionIterator.remove();
            }
            if (!sequence.isEmpty()) continue;
            sequenceIterator.remove();
        }
        HashSet<Sequence> seeds = this.buildSeeds(frequentItems);
        GSPSet model = new GSPSet();
        int round = 0;
        while (seeds.size() > 0) {
            this.checkForStop();
            ArrayList<Sequence> candidates = GSPOperator.generateCandidates(seeds, round == 0);
            if (candidates.size() == 0) break;
            this.checkForStop();
            int[] supportCounter = this.countSupportingCustomer(candidates, dataSequences, windowSize, maxGap, minGap, minSupport);
            Iterator<Sequence> iterator = candidates.iterator();
            for (i = 0; i < supportCounter.length; ++i) {
                Sequence currentSequence = iterator.next();
                double support = (double)supportCounter[i] / numberOfSequences;
                if (support >= minSupport) {
                    model.addSequence(currentSequence, support);
                    continue;
                }
                iterator.remove();
            }
            LogService.getGlobal().log("Filtered Candidates. Remaining: " + candidates.size(), 3);
            seeds.clear();
            seeds.addAll(candidates);
            ++round;
        }
        this.exampleSetOutput.deliver(exampleSet);
        this.patternOutput.deliver(model);
    }

    private int[] countSupportingCustomer(ArrayList<Sequence> candidates, ArrayList<DataSequence> dataSequences, double windowSize, double maxGap, double minGap, double minSupport) {
        LogService.getGlobal().log("Building Hashtree for counting candidates of length " + candidates.get(0).getNumberOfItems(), 3);
        HashTreeRootNode root = new HashTreeRootNode();
        int i = 0;
        for (Sequence candidate : candidates) {
            root.addSequence(candidate, i, 0, null, candidates);
            ++i;
        }
        LogService.getGlobal().log("Counting supporting sequences for candidates of length " + candidates.get(0).getNumberOfItems(), 3);
        int[] counter = new int[candidates.size()];
        boolean[] occurs = new boolean[candidates.size()];
        CountingInformations countingInformations = new CountingInformations(occurs, candidates, windowSize, maxGap, minGap);
        for (DataSequence dataSequence : dataSequences) {
            root.countCoveredCandidates(dataSequence, 0.0, countingInformations);
            for (i = 0; i < occurs.length; ++i) {
                int n = i;
                counter[n] = counter[n] + (occurs[i] ? 1 : 0);
                occurs[i] = false;
            }
        }
        return counter;
    }

    private static ArrayList<Sequence> generateCandidates(HashSet<Sequence> seeds, boolean isFirstRound) {
        LogService.getGlobal().log("Generating Candidates of length " + seeds.iterator().next().getNumberOfItems(), 3);
        ArrayList<Sequence> candidates = new ArrayList<Sequence>();
        int pruneCheckCounter = 0;
        for (Sequence sequence1 : seeds) {
            for (Sequence sequence2 : seeds) {
                Sequence candidate;
                if (!sequence1.equals(0, sequence2, sequence2.getNumberOfItems() - 1)) continue;
                if (isFirstRound || sequence2.getLastTransaction().size() == 1) {
                    candidate = Sequence.appendTransaction(sequence1, sequence2.getLastTransaction());
                    if (++pruneCheckCounter % 10000 == 0) {
                        LogService.getGlobal().log("....................................................................................................", 3);
                    }
                    if (!GSPOperator.isPruned(seeds, candidate)) {
                        candidates.add(candidate);
                    }
                }
                if (!isFirstRound && sequence2.getLastTransaction().size() <= 1) continue;
                candidate = Sequence.appendItem(sequence1, sequence2.getLastTransaction().getLastItem());
                if (++pruneCheckCounter % 10000 == 0) {
                    LogService.getGlobal().log("....................................................................................................", 3);
                }
                if (GSPOperator.isPruned(seeds, candidate)) continue;
                candidates.add(candidate);
            }
        }
        LogService.getGlobal().log("Generated " + candidates.size() + " candidates", 3);
        return candidates;
    }

    private static boolean isPruned(HashSet<Sequence> seeds, Sequence candidate) {
        if (candidate.getNumberOfItems() < seeds.iterator().next().getNumberOfItems() + 1) {
            return true;
        }
        boolean contained = true;
        for (int i = 0; i < ((Transaction)candidate.get(0)).size(); ++i) {
            if (GSPOperator.isFrequent(Sequence.removeItem(candidate, 0, i), seeds)) continue;
            return true;
        }
        if (contained) {
            int lastIndex = candidate.size() - 1;
            for (int i = 0; i < ((Transaction)candidate.get(lastIndex)).size(); ++i) {
                if (GSPOperator.isFrequent(Sequence.removeItem(candidate, lastIndex, i), seeds)) continue;
                return true;
            }
        }
        if (contained) {
            for (int transactionIndex = 1; transactionIndex < candidate.size() - 1; ++transactionIndex) {
                int transactionSize = ((Transaction)candidate.get(transactionIndex)).size();
                if (transactionSize <= 1) continue;
                for (int i = 0; i < transactionSize; ++i) {
                    if (GSPOperator.isFrequent(Sequence.removeItem(candidate, transactionIndex, i), seeds)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isFrequent(Sequence testCandidate, HashSet<Sequence> seeds) {
        return seeds.contains(testCandidate);
    }

    private HashSet<Sequence> buildSeeds(LinkedHashSet<Item> frequentItems) {
        HashSet<Sequence> seeds = new HashSet<Sequence>(frequentItems.size());
        for (Item item : frequentItems) {
            Transaction transaction = new Transaction(Double.NaN, new Item[0]);
            transaction.add(item);
            Sequence sequence = new Sequence();
            sequence.add(transaction);
            seeds.add(sequence);
        }
        return seeds;
    }

    private LinkedHashSet<Item> findFrequentItems(ArrayList<DataSequence> sequences, Item[] items, int minFrequency) {
        int[] itemCounters = new int[items.length];
        for (DataSequence sequence : sequences) {
            boolean[] itemCounted = new boolean[items.length];
            for (Transaction transaction : sequence) {
                for (Item item : transaction) {
                    int index = item.getIndex();
                    if (itemCounted[index]) continue;
                    int n = index;
                    itemCounters[n] = itemCounters[n] + 1;
                    itemCounted[index] = true;
                }
            }
        }
        LinkedHashSet<Item> frequentItems = new LinkedHashSet<Item>();
        for (int i = 0; i < items.length; ++i) {
            if (itemCounters[i] <= minFrequency) continue;
            frequentItems.add(items[i]);
        }
        return frequentItems;
    }

    private ArrayList<DataSequence> buildSequences(ExampleSet exampleSet, Attributes attributes, Attribute timeAttribute, Attribute customerAttribute, double[] positiveIndices, Item[] items) {
        ArrayList<DataSequence> sequences = new ArrayList<DataSequence>();
        SortedExampleSet sortedSet = new SortedExampleSet(exampleSet, timeAttribute, 0);
        sortedSet = new SortedExampleSet(sortedSet, customerAttribute, 0);
        double lastCustomerId = Double.NEGATIVE_INFINITY;
        DataSequence currentSequence = null;
        for (Example example : sortedSet) {
            double customerId = example.getValue(customerAttribute);
            if (lastCustomerId != customerId) {
                if (currentSequence != null) {
                    currentSequence.buildAccessStructure();
                }
                currentSequence = new DataSequence(items.length);
                sequences.add(currentSequence);
                lastCustomerId = customerId;
            }
            Transaction currentSet = new Transaction(example.getValue(timeAttribute), new Item[0]);
            int attributeIndex = 0;
            for (Attribute attribute : attributes) {
                if (example.getValue(attribute) == positiveIndices[attributeIndex]) {
                    currentSet.add(items[attributeIndex]);
                }
                ++attributeIndex;
            }
            if (currentSet.size() <= 0) continue;
            currentSequence.add(currentSet);
        }
        currentSequence.buildAccessStructure();
        return sequences;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeAttribute(PARAMETER_CUSTOMER_ATTRIBUTE, "This attribute will be used to identify the customer of a transaction.", this.exampleSetInput, false);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeAttribute(PARAMETER_TIME_ATTRIBUTE, "This numerical attribute specifies the time of a transaction.", this.exampleSetInput, false, 2);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_MIN_SUPPORT, "This specifies the minimal support of a pattern", 0.0, 1.0, 0.9);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_WINDOW_SIZE, "This specifies the window size", 0.0, Double.POSITIVE_INFINITY);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_MAX_GAP, "This specifies the maximal gap", 0.0, Double.POSITIVE_INFINITY);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_MIN_GAP, "This specifies the minimal gap", 0.0, Double.POSITIVE_INFINITY);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeString(PARAMETER_POSITIVE_VALUE, "This parameter determines, which value of the binominal attributes is treated as positive. Attributes with that value are considered as part of a transaction. If left blank, the example set determines, which is value is used.", true);
        types.add(type);
        return types;
    }
}

