/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.associations.gsp;

import com.rapidminer.operator.learner.associations.gsp.CountingInformations;
import com.rapidminer.operator.learner.associations.gsp.Item;
import com.rapidminer.operator.learner.associations.gsp.Sequence;
import com.rapidminer.operator.learner.associations.gsp.Transaction;
import com.rapidminer.operator.learner.associations.gsp.TransactionSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;

public class DataSequence
extends Sequence {
    private static final long serialVersionUID = -7914523040469057204L;
    private double[][] times;

    public DataSequence(int numberOfItems) {
        this.times = new double[numberOfItems][];
    }

    public void buildAccessStructure() {
        int[] itemCount = new int[this.times.length];
        Iterator<Item> itemIterator = this.itemIterator();
        while (itemIterator.hasNext()) {
            int itemIndex;
            int n = itemIndex = itemIterator.next().getIndex();
            itemCount[n] = itemCount[n] + 1;
        }
        for (int i = 0; i < this.times.length; ++i) {
            this.times[i] = new double[itemCount[i]];
            itemCount[i] = 0;
        }
        for (Transaction transaction : this) {
            double time = transaction.getTime();
            for (Item item : transaction) {
                int itemIndex;
                int n = itemIndex = item.getIndex();
                int n2 = itemCount[n];
                itemCount[n] = n2 + 1;
                this.times[itemIndex][n2] = time;
            }
        }
    }

    private TransactionSet findTransaction(Transaction findWhat, double t, CountingInformations countingInformations) {
        TransactionSet result = new TransactionSet();
        while (true) {
            for (Item item : findWhat) {
                double foundTime = this.firstOccurenceAfter(item, t);
                if (Double.isNaN(foundTime)) {
                    return null;
                }
                result.addTimeOfTransaction(foundTime);
            }
            if (!(result.getEndTime() - result.getStartTime() > countingInformations.windowSize)) break;
            t = result.getEndTime() - countingInformations.windowSize;
            result.reset();
        }
        return result;
    }

    private double firstOccurenceAfter(Item item, double currentTime) {
        int itemIndex = item.getIndex();
        for (int i = 0; i < this.times[itemIndex].length; ++i) {
            if (!(this.times[itemIndex][i] > currentTime)) continue;
            return this.times[itemIndex][i];
        }
        return Double.NaN;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean containsSequence(DataSequence data, Sequence candidate, CountingInformations countingInformations) {
        ListIterator candidateIterator = candidate.listIterator();
        LinkedList matches = new LinkedList();
        ListIterator<TransactionSet> matchesIterator = matches.listIterator();
        double t = Double.NEGATIVE_INFINITY;
        while (true) {
            block10: {
                TransactionSet currentSet;
                Transaction currentTransaction;
                if (candidateIterator.hasNext()) {
                    currentTransaction = (Transaction)candidateIterator.next();
                    currentSet = data.findTransaction(currentTransaction, t, countingInformations);
                    if (currentSet == null) {
                        return false;
                    }
                    double difference = currentSet.getEndTime() - t;
                    if (matches.isEmpty() || difference < countingInformations.maxGap && difference > 0.0) {
                        matchesIterator.add(currentSet);
                        t = currentSet.getEndTime();
                        continue;
                    }
                    t = currentSet.getEndTime();
                }
                if (!candidateIterator.hasNext()) {
                    return true;
                }
                candidateIterator.previous();
                if (!matchesIterator.hasPrevious()) {
                    return false;
                }
                matchesIterator.previous();
                while (true) {
                    if ((currentSet = data.findTransaction(currentTransaction = (Transaction)candidateIterator.previous(), t - countingInformations.maxGap, countingInformations)) == null) {
                        return false;
                    }
                    if (!matchesIterator.hasPrevious()) break;
                    TransactionSet last = (TransactionSet)matchesIterator.previous();
                    double difference = currentSet.getStartTime() - last.getEndTime();
                    if (difference < countingInformations.maxGap && difference > countingInformations.minGap && difference > 0.0 || !candidateIterator.hasPrevious()) {
                        t = currentSet.getEndTime();
                        matchesIterator.add(currentSet);
                        break block10;
                    }
                    t = currentSet.getStartTime();
                }
                matchesIterator.add(currentSet);
                t = currentSet.getEndTime();
            }
            while (matchesIterator.hasNext()) {
                matchesIterator.next();
                matchesIterator.remove();
            }
            matchesIterator.previous();
            candidateIterator.next();
        }
    }
}

