/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.associations.fpgrowth;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessStoppedException;
import com.rapidminer.operator.learner.associations.BooleanAttributeItem;
import com.rapidminer.operator.learner.associations.FrequentItemSet;
import com.rapidminer.operator.learner.associations.FrequentItemSets;
import com.rapidminer.operator.learner.associations.Item;
import com.rapidminer.operator.learner.associations.fpgrowth.FPTree;
import com.rapidminer.operator.learner.associations.fpgrowth.FPTreeNode;
import com.rapidminer.operator.learner.associations.fpgrowth.Header;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.ExampleSetPrecondition;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FPGrowth
extends Operator {
    public static final String PARAMETER_FIND_MIN_NUMBER_OF_ITEMSETS = "find_min_number_of_itemsets";
    public static final String PARAMETER_MIN_NUMBER_OF_ITEMSETS = "min_number_of_itemsets";
    public static final String PARAMETER_MAX_REDUCTION_STEPS = "max_number_of_retries";
    public static final String PARAMETER_POSITIVE_VALUE = "positive_value";
    public static final String PARAMETER_MIN_SUPPORT = "min_support";
    public static final String PARAMETER_MAX_ITEMS = "max_items";
    private static final String PARAMETER_MUST_CONTAIN = "must_contain";
    private static final String PARAMETER_KEEP_EXAMPLE_SET = "keep_example_set";
    private final InputPort exampleSetInput = (InputPort)this.getInputPorts().createPort("example set");
    private final OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set");
    private final OutputPort frequentSetsOutput = (OutputPort)this.getOutputPorts().createPort("frequent sets");

    public FPGrowth(OperatorDescription description) {
        super(description);
        this.exampleSetInput.addPrecondition(new ExampleSetPrecondition(this.exampleSetInput, 6, new String[0]));
        this.getTransformer().addGenerationRule(this.frequentSetsOutput, FrequentItemSets.class);
        this.getTransformer().addPassThroughRule(this.exampleSetInput, this.exampleSetOutput);
    }

    @Override
    public void doWork() throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)this.exampleSetInput.getData();
        Tools.onlyNominalAttributes(exampleSet, "FPGrowth");
        boolean shouldFindMinimumNumber = this.getParameterAsBoolean(PARAMETER_FIND_MIN_NUMBER_OF_ITEMSETS);
        int maximalNumberOfRetries = shouldFindMinimumNumber ? this.getParameterAsInt(PARAMETER_MAX_REDUCTION_STEPS) : 1;
        int minimumNumberOfItemsets = shouldFindMinimumNumber ? this.getParameterAsInt(PARAMETER_MIN_NUMBER_OF_ITEMSETS) : 1;
        int maxItems = this.getParameterAsInt(PARAMETER_MAX_ITEMS);
        double currentSupport = this.getParameterAsDouble(PARAMETER_MIN_SUPPORT);
        FrequentItemSets sets = null;
        for (int retryCount = 0; sets == null || sets.size() < minimumNumberOfItemsets && retryCount < maximalNumberOfRetries; ++retryCount) {
            int currentMinTotalSupport = (int)Math.ceil(currentSupport * (double)exampleSet.size());
            ExampleSet workingSet = this.preprocessExampleSet(exampleSet);
            Attribute[] attributes = new Attribute[workingSet.getAttributes().size()];
            double[] positiveIndices = new double[workingSet.getAttributes().size()];
            int i = 0;
            Iterator<Attribute> i$ = workingSet.getAttributes().iterator();
            while (i$.hasNext()) {
                Attribute attribute;
                attributes[i] = attribute = i$.next();
                positiveIndices[i] = attribute.getMapping().getPositiveIndex();
                String positiveValueString = null;
                try {
                    positiveValueString = this.getParameterAsString(PARAMETER_POSITIVE_VALUE);
                }
                catch (UndefinedParameterError err) {
                    // empty catch block
                }
                if (positiveValueString != null && !positiveValueString.equals("")) {
                    positiveIndices[i] = attribute.getMapping().mapString(positiveValueString);
                }
                ++i;
            }
            Map<Attribute, Item> itemMapping = this.getAttributeMapping(workingSet);
            this.getItemFrequency(workingSet, attributes, positiveIndices, itemMapping);
            this.removeNonFrequentItems(itemMapping, currentMinTotalSupport, workingSet);
            FPTree tree = this.getFPTree(workingSet, attributes, positiveIndices, itemMapping);
            sets = new FrequentItemSets(workingSet.size());
            String mustContainItems = this.getParameterAsString(PARAMETER_MUST_CONTAIN);
            if (mustContainItems == null) {
                this.mineTree(tree, sets, 0, currentMinTotalSupport, maxItems);
            } else {
                FrequentItemSet conditionalItems = new FrequentItemSet();
                Pattern pattern = Pattern.compile(mustContainItems);
                int depth = 0;
                for (Map.Entry<Attribute, Item> attributeEntry : itemMapping.entrySet()) {
                    Matcher matcher = pattern.matcher(attributeEntry.getKey().getName());
                    if (!matcher.matches()) continue;
                    Item targetItem = attributeEntry.getValue();
                    Header targetItemHeader = tree.getHeaderTable().get(targetItem);
                    for (FPTreeNode node : targetItemHeader.getSiblingChain()) {
                        int frequency = node.getFrequency(depth);
                        if (frequency <= 0) continue;
                        for (FPTreeNode currentNode = node.getFather(); currentNode != tree; currentNode = currentNode.getFather()) {
                            currentNode.increaseFrequency(depth + 1, frequency);
                            tree.getHeaderTable().get(currentNode.getNodeItem()).getFrequencies().increaseFrequency(depth + 1, frequency);
                        }
                    }
                    int itemSupport = targetItemHeader.getFrequencies().getFrequency(depth);
                    conditionalItems.addItem(targetItem, itemSupport);
                    ++depth;
                }
                sets.addFrequentSet(conditionalItems);
                this.mineTree(tree, sets, depth, conditionalItems, currentMinTotalSupport, maxItems);
            }
            currentSupport *= 0.9;
        }
        this.exampleSetOutput.deliver(exampleSet);
        this.frequentSetsOutput.deliver(sets);
    }

    private ExampleSet preprocessExampleSet(ExampleSet exampleSet) {
        ExampleSet workingSet = (ExampleSet)exampleSet.clone();
        int oldAttributeCount = workingSet.getAttributes().size();
        this.removeNonBooleanAttributes(workingSet);
        int newAttributeCount = workingSet.getAttributes().size();
        if (oldAttributeCount != newAttributeCount) {
            int removeCount = oldAttributeCount - newAttributeCount;
            String message = null;
            message = removeCount == 1 ? "Removed 1 non-binominal attribute, frequent item set mining is only supported for the positive values of binominal attributes." : "Removed " + removeCount + " non-binominal attributes, frequent item set mining is only supported for the positive values of binominal attributes.";
            this.logWarning(message);
        }
        return workingSet;
    }

    private void mineTree(FPTree tree, FrequentItemSets sets, int recursionDepth, int minTotalSupport, int maxItems) throws ProcessStoppedException {
        this.mineTree(tree, sets, recursionDepth, new FrequentItemSet(), minTotalSupport, maxItems);
    }

    private void mineTree(FPTree tree, FrequentItemSets sets, int recursionDepth, FrequentItemSet conditionalItems, int minTotalSupport, int maxItems) throws ProcessStoppedException {
        this.checkForStop();
        if (!this.treeIsEmpty(tree, recursionDepth)) {
            if (maxItems > 0 && recursionDepth >= maxItems) {
                return;
            }
            Map<Item, Header> headerTable = tree.getHeaderTable();
            for (Map.Entry<Item, Header> headerEntry : headerTable.entrySet()) {
                FPTreeNode currentNode;
                Item item = headerEntry.getKey();
                Header itemHeader = headerEntry.getValue();
                int itemSupport = itemHeader.getFrequencies().getFrequency(recursionDepth);
                if (itemSupport < minTotalSupport) continue;
                for (FPTreeNode node : itemHeader.getSiblingChain()) {
                    int frequency = node.getFrequency(recursionDepth);
                    if (frequency <= 0) continue;
                    for (currentNode = node.getFather(); currentNode != tree; currentNode = currentNode.getFather()) {
                        currentNode.increaseFrequency(recursionDepth + 1, frequency);
                        headerTable.get(currentNode.getNodeItem()).getFrequencies().increaseFrequency(recursionDepth + 1, frequency);
                    }
                }
                FrequentItemSet recursivConditionalItems = (FrequentItemSet)conditionalItems.clone();
                recursivConditionalItems.addItem(item, itemSupport);
                sets.addFrequentSet(recursivConditionalItems);
                this.mineTree(tree, sets, recursionDepth + 1, recursivConditionalItems, minTotalSupport, maxItems);
                for (FPTreeNode node : itemHeader.getSiblingChain()) {
                    for (currentNode = node.getFather(); currentNode != tree; currentNode = currentNode.getFather()) {
                        currentNode.popFrequency(recursionDepth + 1);
                    }
                }
                for (Header currentItemHeader : headerTable.values()) {
                    currentItemHeader.getFrequencies().popFrequency(recursionDepth + 1);
                }
            }
        }
    }

    private void removeNonBooleanAttributes(ExampleSet exampleSet) {
        ArrayList<Attribute> deleteAttributes = new ArrayList<Attribute>();
        for (Attribute attribute : exampleSet.getAttributes()) {
            if (attribute.isNominal() && attribute.getMapping().size() == 2) continue;
            deleteAttributes.add(attribute);
        }
        for (Attribute attribute : deleteAttributes) {
            exampleSet.getAttributes().remove(attribute);
        }
    }

    private Map<Attribute, Item> getAttributeMapping(ExampleSet exampleSet) {
        HashMap<Attribute, Item> mapping = new HashMap<Attribute, Item>();
        for (Attribute attribute : exampleSet.getAttributes()) {
            mapping.put(attribute, new BooleanAttributeItem(attribute));
        }
        return mapping;
    }

    private void getItemFrequency(ExampleSet exampleSet, Attribute[] attributes, double[] positiveIndices, Map<Attribute, Item> mapping) {
        for (Example currentExample : exampleSet) {
            int i = 0;
            for (Attribute attribute : attributes) {
                if (currentExample.getValue(attribute) == positiveIndices[i]) {
                    mapping.get(attribute).increaseFrequency();
                }
                ++i;
            }
        }
    }

    private void removeNonFrequentItems(Map<Attribute, Item> mapping, int minFrequency, ExampleSet exampleSet) {
        ArrayList<Attribute> deleteMappings = new ArrayList<Attribute>();
        for (Map.Entry<Attribute, Item> entry : mapping.entrySet()) {
            if (entry.getValue().getFrequency() >= minFrequency) continue;
            deleteMappings.add(entry.getKey());
        }
        for (Attribute attribute : deleteMappings) {
            exampleSet.getAttributes().remove(attribute);
        }
    }

    private FPTree getFPTree(ExampleSet exampleSet, Attribute[] attributes, double[] positiveIndices, Map<Attribute, Item> mapping) {
        FPTree tree = new FPTree();
        for (Example currentExample : exampleSet) {
            ArrayList<Item> itemSet = new ArrayList<Item>();
            int i = 0;
            for (Attribute currentAttribute : attributes) {
                if (currentExample.getValue(currentAttribute) == positiveIndices[i]) {
                    itemSet.add(mapping.get(currentAttribute));
                }
                ++i;
            }
            Collections.sort(itemSet);
            tree.addItemSet(itemSet, 1);
        }
        return tree;
    }

    private boolean treeIsEmpty(FPTree tree, int recursionDepth) {
        for (FPTreeNode node : tree.getChildren().values()) {
            if (node.getFrequency(recursionDepth) <= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeBoolean(PARAMETER_FIND_MIN_NUMBER_OF_ITEMSETS, "Indicates if the mininmal support should be decreased automatically until the specified minimum number of frequent item sets is found. The defined minimal support is lowered by 20 percent each time.", true);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_MIN_NUMBER_OF_ITEMSETS, "Indicates the minimum number of itemsets which should be determined if the corresponding parameter is activated.", 0, Integer.MAX_VALUE, 100);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_FIND_MIN_NUMBER_OF_ITEMSETS, true, false));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_MAX_REDUCTION_STEPS, "This determines how many times the operator lowers min support to find the minimal number of item sets. Each time the minimal support is lowered by 20 percent.", 2, Integer.MAX_VALUE, 15);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_FIND_MIN_NUMBER_OF_ITEMSETS, false, false));
        type.setExpert(true);
        types.add(type);
        type = new ParameterTypeString(PARAMETER_POSITIVE_VALUE, "This parameter determines, which value of the binominal attributes is treated as positive. Attributes with that value are considered as part of a transaction. If left blank, the example set determines, which is value is used.", true);
        type.setExpert(true);
        types.add(type);
        types.add(new ParameterTypeDouble(PARAMETER_MIN_SUPPORT, "The minimal support necessary in order to be a frequent item (set).", 0.0, 1.0, 0.95));
        types.add(new ParameterTypeInt(PARAMETER_MAX_ITEMS, "The upper bound for the length of the item sets (-1: no upper bound)", -1, Integer.MAX_VALUE, -1));
        types.add(new ParameterTypeString(PARAMETER_MUST_CONTAIN, "The items any generated rule must contain as regular expression. Empty if none."));
        type = new ParameterTypeBoolean(PARAMETER_KEEP_EXAMPLE_SET, "indicates if example set is kept", false);
        type.setDeprecated();
        types.add(type);
        return types;
    }
}

