/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.associations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class PowerSet<ItemT>
implements Iterable<Collection<ItemT>>,
Iterator<Collection<ItemT>> {
    private ArrayList<ItemT> set;
    private boolean[] subSetIndicator;

    public PowerSet(Collection<ItemT> collection) {
        this.set = new ArrayList<ItemT>(collection);
    }

    @Override
    public Iterator<Collection<ItemT>> iterator() {
        return new PowerSet<ItemT>(this.set);
    }

    public Collection<ItemT> getComplement(Collection<ItemT> collection) {
        ArrayList<ItemT> complement = new ArrayList<ItemT>(this.set.size() - collection.size());
        Iterator<ItemT> iterator = this.set.iterator();
        for (ItemT item : collection) {
            ItemT currentSetItem;
            while (iterator.hasNext() && (currentSetItem = iterator.next()) != item) {
                complement.add(currentSetItem);
            }
        }
        while (iterator.hasNext()) {
            complement.add(iterator.next());
        }
        return complement;
    }

    @Override
    public boolean hasNext() {
        if (this.subSetIndicator == null) {
            return true;
        }
        for (int i = 0; i < this.subSetIndicator.length; ++i) {
            if (this.subSetIndicator[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<ItemT> next() {
        if (this.subSetIndicator == null) {
            this.subSetIndicator = new boolean[this.set.size()];
        } else {
            for (int i = 0; i < this.subSetIndicator.length; ++i) {
                if (!this.subSetIndicator[i]) {
                    this.subSetIndicator[i] = true;
                    break;
                }
                this.subSetIndicator[i] = false;
            }
        }
        ArrayList<ItemT> subset = new ArrayList<ItemT>();
        for (int i = 0; i < this.subSetIndicator.length; ++i) {
            if (!this.subSetIndicator[i]) continue;
            subset.add(this.set.get(i));
        }
        return subset;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("The 'remove' operation is not supported by power sets!");
    }
}

