/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.associations;

import com.rapidminer.operator.ResultObjectAdapter;
import com.rapidminer.operator.learner.associations.FrequentItemSet;
import com.rapidminer.tools.Tools;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;

public class FrequentItemSets
extends ResultObjectAdapter
implements Iterable<FrequentItemSet> {
    private static final long serialVersionUID = -6195363961857170621L;
    private static final int MAX_NUMBER_OF_ITEMSETS = 100;
    private int numberOfTransactions;
    private int maximumSetSize = 0;
    private ArrayList<FrequentItemSet> frequentSets;

    public FrequentItemSets(int numberOfTransactions) {
        this.numberOfTransactions = numberOfTransactions;
        this.frequentSets = new ArrayList();
    }

    public void addFrequentSet(FrequentItemSet itemSet) {
        this.frequentSets.add(itemSet);
        this.maximumSetSize = Math.max(itemSet.getNumberOfItems(), this.maximumSetSize);
    }

    public String getExtension() {
        return "frq";
    }

    public String getFileDescription() {
        return "frequent item set";
    }

    public int getMaximumSetSize() {
        return this.maximumSetSize;
    }

    @Override
    public Iterator<FrequentItemSet> iterator() {
        return this.frequentSets.iterator();
    }

    public FrequentItemSet getItemSet(int index) {
        return this.frequentSets.get(index);
    }

    public void sortSets() {
        Collections.sort(this.frequentSets);
    }

    public void sortSets(Comparator<FrequentItemSet> comparator) {
        Collections.sort(this.frequentSets, comparator);
    }

    public int size() {
        return this.frequentSets.size();
    }

    public int getNumberOfTransactions() {
        return this.numberOfTransactions;
    }

    @Override
    public String toResultString() {
        if (this.size() > 100) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.toString(100));
            stringBuilder.append("... (" + (this.size() - 100) + " more)");
            return stringBuilder.toString();
        }
        return this.toString(-1);
    }

    public String toString() {
        return this.toString(100);
    }

    public String toString(int maxNumber) {
        StringBuffer output = new StringBuffer("Frequent Item Sets (" + this.size() + "):" + Tools.getLineSeparator());
        if (this.frequentSets.size() == 0) {
            output.append("no itemsets found");
        } else {
            int counter = 0;
            for (FrequentItemSet set : this.frequentSets) {
                if (maxNumber > 0 && ++counter > maxNumber) {
                    output.append("... " + (this.size() - maxNumber) + " additional item sets ...");
                    break;
                }
                output.append(set.getItemsAsString());
                output.append(" / ");
                output.append(Tools.formatNumber((double)set.getFrequency() / (double)this.numberOfTransactions));
                output.append(Tools.getLineSeparator());
            }
        }
        return output.toString();
    }
}

