/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.associations;

import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.associations.FrequentItemSet;
import com.rapidminer.operator.learner.associations.FrequentItemSets;
import com.rapidminer.operator.learner.associations.Item;
import com.rapidminer.operator.ports.PortPairExtender;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.tools.container.Tupel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public class FrequentItemSetUnificator
extends Operator {
    private PortPairExtender portExtender = new PortPairExtender("frequent item sets", this.getInputPorts(), this.getOutputPorts(), new MetaData(FrequentItemSets.class));

    public FrequentItemSetUnificator(OperatorDescription description) {
        super(description);
        this.portExtender.ensureMinimumNumberOfPorts(2);
        this.getTransformer().addRule(this.portExtender.makePassThroughRule());
        this.portExtender.start();
    }

    @Override
    public void doWork() throws OperatorException {
        List sets = this.portExtender.getData();
        for (FrequentItemSets set : sets) {
            set.sortSets(new FrequencyIgnoringSetComparator());
            sets.add(set);
        }
        ArrayList<Tupel<FrequentItemSet, Iterator<FrequentItemSet>>> iteratorTupels = new ArrayList<Tupel<FrequentItemSet, Iterator<FrequentItemSet>>>(2);
        for (FrequentItemSets classSets : sets) {
            Iterator<FrequentItemSet> iterator = classSets.iterator();
            iteratorTupels.add(new Tupel<Comparable, Iterator<FrequentItemSet>>(iterator.next(), iterator));
        }
        while (this.haveNext(iteratorTupels)) {
            TreeSet<FrequentItemSet> currentSets = new TreeSet<FrequentItemSet>(new FrequencyIgnoringSetComparator());
            for (Tupel<FrequentItemSet, Iterator<FrequentItemSet>> tupel : iteratorTupels) {
                currentSets.add(tupel.getFirst());
            }
            if (currentSets.size() == 1) {
                ArrayList<Tupel<Comparable, Iterator<FrequentItemSet>>> newTupels = new ArrayList<Tupel<Comparable, Iterator<FrequentItemSet>>>(2);
                for (Tupel<FrequentItemSet, Iterator<FrequentItemSet>> tupel : iteratorTupels) {
                    Iterator<FrequentItemSet> currentIterator = tupel.getSecond();
                    currentIterator.remove();
                    if (!currentIterator.hasNext()) continue;
                    newTupels.add(new Tupel<Comparable, Iterator<FrequentItemSet>>(currentIterator.next(), currentIterator));
                }
                iteratorTupels = newTupels;
                continue;
            }
            Collections.sort(iteratorTupels, new TupelComparator());
            Iterator<FrequentItemSet> currentIterator = iteratorTupels.get(0).getSecond();
            if (currentIterator.hasNext()) {
                iteratorTupels.add(new Tupel<Comparable, Iterator<FrequentItemSet>>(currentIterator.next(), currentIterator));
            }
            iteratorTupels.remove(0);
        }
        this.portExtender.deliver(sets);
    }

    private boolean haveNext(ArrayList<Tupel<FrequentItemSet, Iterator<FrequentItemSet>>> iterators) {
        boolean hasNext = iterators.size() > 0;
        for (Tupel<FrequentItemSet, Iterator<FrequentItemSet>> iterator : iterators) {
            hasNext = hasNext || iterator.getSecond().hasNext();
        }
        return hasNext;
    }

    private class TupelComparator
    implements Comparator<Tupel<FrequentItemSet, Iterator<FrequentItemSet>>> {
        private TupelComparator() {
        }

        @Override
        public int compare(Tupel<FrequentItemSet, Iterator<FrequentItemSet>> o1, Tupel<FrequentItemSet, Iterator<FrequentItemSet>> o2) {
            FrequencyIgnoringSetComparator comparator = new FrequencyIgnoringSetComparator();
            return comparator.compare(o1.getFirst(), o2.getFirst());
        }
    }

    private static class FrequencyIgnoringSetComparator
    implements Comparator<FrequentItemSet> {
        private FrequencyIgnoringSetComparator() {
        }

        @Override
        public int compare(FrequentItemSet o1, FrequentItemSet o2) {
            Collection<Item> items = o1.getItems();
            Collection<Item> hisItems = o2.getItems();
            if (items.size() < hisItems.size()) {
                return -1;
            }
            if (items.size() > hisItems.size()) {
                return 1;
            }
            Iterator<Item> iterator = hisItems.iterator();
            for (Item myCurrentItem : items) {
                int relation = ((Object)myCurrentItem).toString().compareTo(((Object)iterator.next()).toString());
                if (relation == 0) continue;
                return relation;
            }
            return 0;
        }
    }
}

