/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.associations;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.associations.FrequentItemSet;
import com.rapidminer.operator.learner.associations.FrequentItemSets;
import com.rapidminer.operator.learner.associations.Item;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.ExampleSetPassThroughRule;
import com.rapidminer.operator.ports.metadata.SetRelation;
import java.util.ArrayList;
import java.util.HashMap;

public class FrequentItemSetAttributeCreator
extends Operator {
    private InputPort exampleSetInput = this.getInputPorts().createPort("example set", ExampleSet.class);
    private InputPort frequentItemSetsInput = this.getInputPorts().createPort("frequent item sets", FrequentItemSets.class);
    private OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set");

    public FrequentItemSetAttributeCreator(OperatorDescription description) {
        super(description);
        this.getTransformer().addRule(new ExampleSetPassThroughRule(this.exampleSetInput, this.exampleSetOutput, SetRelation.SUPERSET));
    }

    @Override
    public void doWork() throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)this.exampleSetInput.getData();
        FrequentItemSets sets = (FrequentItemSets)this.frequentItemSetsInput.getData();
        HashMap<String, Attribute> attributeMap = new HashMap<String, Attribute>();
        for (Attribute attribute : exampleSet.getAttributes()) {
            attributeMap.put(attribute.getName(), attribute);
        }
        HashMap<FrequentItemSet, Attribute> setAttributeMap = new HashMap<FrequentItemSet, Attribute>();
        ArrayList<Attribute> newAttributes = new ArrayList<Attribute>(sets.size());
        for (FrequentItemSet set : sets) {
            Attribute newAttribute = AttributeFactory.createAttribute(set.toString(), 2);
            newAttributes.add(newAttribute);
            setAttributeMap.put(set, newAttribute);
            exampleSet.getAttributes().addRegular(newAttribute);
        }
        MemoryExampleTable table = (MemoryExampleTable)exampleSet.getExampleTable();
        table.addAttributes(newAttributes);
        for (Example example : exampleSet) {
            for (FrequentItemSet set : sets) {
                example.setValue((Attribute)setAttributeMap.get(set), this.checkConditions(example, set, attributeMap));
            }
        }
        this.exampleSetOutput.deliver(exampleSet);
    }

    private double checkConditions(Example example, FrequentItemSet set, HashMap<String, Attribute> attributeMap) {
        boolean matches = true;
        for (Item item : set.getItems()) {
            Attribute conditionAttribute = attributeMap.get(((Object)item).toString());
            if (conditionAttribute != null) {
                double conditionValue = conditionAttribute.getMapping().mapString("true");
                matches = matches && example.getValue(conditionAttribute) == conditionValue;
                continue;
            }
            matches = false;
        }
        if (matches) {
            return 1.0;
        }
        return 0.0;
    }
}

