/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.associations;

import com.rapidminer.example.Attribute;
import com.rapidminer.operator.learner.associations.Item;

public class BooleanAttributeItem
implements Item {
    private static final long serialVersionUID = -7963677912091349984L;
    private int frequency = 0;
    private String name;

    public BooleanAttributeItem(Attribute item) {
        this.name = item.getName();
    }

    @Override
    public int getFrequency() {
        return this.frequency;
    }

    @Override
    public void increaseFrequency() {
        ++this.frequency;
    }

    public void increaseFrequency(double value) {
        this.frequency = (int)((double)this.frequency + value);
    }

    public boolean equals(Object other) {
        if (!(other instanceof BooleanAttributeItem)) {
            return false;
        }
        BooleanAttributeItem o = (BooleanAttributeItem)other;
        return this.name.equals(o.name) && this.frequency == o.frequency;
    }

    public int hashCode() {
        return this.name.hashCode() ^ Double.valueOf(this.frequency).hashCode();
    }

    @Override
    public int compareTo(Item arg0) {
        Item comparer = arg0;
        if (comparer.getFrequency() == this.getFrequency()) {
            return -1 * this.name.compareTo(((Object)arg0).toString());
        }
        if (comparer.getFrequency() < this.getFrequency()) {
            return -1;
        }
        return 1;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public void increaseFrequency(int value) {
        this.frequency += value;
    }
}

