/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.associations;

import com.rapidminer.operator.ResultObjectAdapter;
import com.rapidminer.operator.learner.associations.AssociationRule;
import com.rapidminer.operator.learner.associations.Item;
import com.rapidminer.tools.Tools;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public class AssociationRules
extends ResultObjectAdapter
implements Iterable<AssociationRule> {
    private static final long serialVersionUID = 3734387908954857589L;
    private static final int MAXIMUM_NUMBER_OF_RULES_IN_OUTPUT = 100;
    private List<AssociationRule> associationRules = new ArrayList<AssociationRule>();

    public void addItemRule(AssociationRule rule) {
        this.associationRules.add(rule);
    }

    public int getNumberOfRules() {
        return this.associationRules.size();
    }

    public AssociationRule getRule(int index) {
        return this.associationRules.get(index);
    }

    public String getExtension() {
        return "asr";
    }

    public String getFileDescription() {
        return "Association Rules";
    }

    @Override
    public String toResultString() {
        return this.toString(100);
    }

    public String toString() {
        return this.toString(100);
    }

    public String toString(int maxNumber) {
        Collections.sort(this.associationRules);
        StringBuffer buffer = new StringBuffer("Association Rules" + Tools.getLineSeparator());
        int counter = 0;
        for (AssociationRule rule : this.associationRules) {
            if (maxNumber >= 0 && counter > maxNumber) {
                buffer.append("... " + (this.associationRules.size() - maxNumber) + " other rules ...");
                break;
            }
            buffer.append(rule.toString());
            buffer.append(Tools.getLineSeparator());
            ++counter;
        }
        return buffer.toString();
    }

    @Override
    public Iterator<AssociationRule> iterator() {
        return this.associationRules.iterator();
    }

    public Item[] getAllConclusionItems() {
        TreeSet<Item> conclusions = new TreeSet<Item>();
        for (AssociationRule rule : this) {
            Iterator<Item> i = rule.getConclusionItems();
            while (i.hasNext()) {
                conclusions.add(i.next());
            }
        }
        Item[] itemArray = new Item[conclusions.size()];
        conclusions.toArray(itemArray);
        return itemArray;
    }
}

