/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.associations;

import com.rapidminer.operator.learner.associations.Item;
import com.rapidminer.tools.Tools;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;

public class AssociationRule
implements Serializable,
Comparable<AssociationRule> {
    private static final long serialVersionUID = -4788528227281876533L;
    private double confidence;
    private double totalSupport;
    private double lift;
    private double laplace;
    private double gain;
    private double ps;
    private double conviction;
    private Collection<Item> premise;
    private Collection<Item> conclusion;

    public AssociationRule(Collection<Item> premise, Collection<Item> conclusion, double totalSupport) {
        this.premise = premise;
        this.conclusion = conclusion;
        this.totalSupport = totalSupport;
    }

    public double getGain() {
        return this.gain;
    }

    public void setGain(double gain) {
        this.gain = gain;
    }

    public double getConviction() {
        return this.conviction;
    }

    public void setConviction(double conviction) {
        this.conviction = conviction;
    }

    public double getLaplace() {
        return this.laplace;
    }

    public void setLaplace(double laplace) {
        this.laplace = laplace;
    }

    public double getLift() {
        return this.lift;
    }

    public void setLift(double lift) {
        this.lift = lift;
    }

    public double getPs() {
        return this.ps;
    }

    public void setPs(double ps) {
        this.ps = ps;
    }

    public void setConfidence(double confidence) {
        this.confidence = confidence;
    }

    public double getConfidence() {
        return this.confidence;
    }

    public double getTotalSupport() {
        return this.totalSupport;
    }

    public Iterator<Item> getPremiseItems() {
        return this.premise.iterator();
    }

    public Iterator<Item> getConclusionItems() {
        return this.conclusion.iterator();
    }

    public String toPremiseString() {
        return this.premise.toString();
    }

    public String toConclusionString() {
        return this.conclusion.toString();
    }

    @Override
    public int compareTo(AssociationRule o) {
        return Double.compare(this.confidence, o.confidence);
    }

    public boolean equals(Object o) {
        if (!(o instanceof AssociationRule)) {
            return false;
        }
        AssociationRule other = (AssociationRule)o;
        return this.premise.toString().equals(other.premise.toString()) && this.conclusion.toString().equals(other.conclusion.toString()) && this.confidence == other.confidence;
    }

    public int hashCode() {
        return this.premise.toString().hashCode() ^ this.conclusion.toString().hashCode() ^ Double.valueOf(this.confidence).hashCode();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.premise.toString());
        buffer.append(" --> ");
        buffer.append(this.conclusion.toString());
        buffer.append(" (confidence: ");
        buffer.append(Tools.formatNumber(this.confidence));
        buffer.append(")");
        return buffer.toString();
    }
}

