/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCapability;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.learner.CapabilityProvider;

public class CapabilityCheck {
    private CapabilityProvider capabilityProvider;
    private boolean onlyWarn;

    public CapabilityCheck(CapabilityProvider provider, boolean onlyWarn) {
        this.capabilityProvider = provider;
        this.onlyWarn = onlyWarn;
    }

    public void checkLearnerCapabilities(Operator learningOperator, ExampleSet exampleSet) throws OperatorException {
        try {
            if (Tools.containsValueType(exampleSet, 1)) {
                if (Tools.containsValueType(exampleSet, 6)) {
                    if (!this.capabilityProvider.supportsCapability(OperatorCapability.BINOMINAL_ATTRIBUTES)) {
                        throw new UserError(learningOperator, 501, learningOperator.getName(), OperatorCapability.BINOMINAL_ATTRIBUTES.getDescription());
                    }
                } else if (!this.capabilityProvider.supportsCapability(OperatorCapability.POLYNOMINAL_ATTRIBUTES)) {
                    throw new UserError(learningOperator, 501, learningOperator.getName(), OperatorCapability.POLYNOMINAL_ATTRIBUTES.getDescription());
                }
            }
            if (Tools.containsValueType(exampleSet, 2) && !this.capabilityProvider.supportsCapability(OperatorCapability.NUMERICAL_ATTRIBUTES)) {
                throw new UserError(learningOperator, 501, learningOperator.getName(), OperatorCapability.NUMERICAL_ATTRIBUTES.getDescription());
            }
            Attribute labelAttribute = exampleSet.getAttributes().getLabel();
            if (labelAttribute != null) {
                if (labelAttribute.isNominal()) {
                    if (labelAttribute.getMapping().size() == 1) {
                        if (!this.capabilityProvider.supportsCapability(OperatorCapability.ONE_CLASS_LABEL)) {
                            throw new UserError(learningOperator, 502, learningOperator.getName());
                        }
                    } else if (labelAttribute.getMapping().size() == 2) {
                        if (!this.capabilityProvider.supportsCapability(OperatorCapability.BINOMINAL_LABEL)) {
                            throw new UserError(learningOperator, 501, learningOperator.getName(), OperatorCapability.BINOMINAL_LABEL.getDescription());
                        }
                    } else if (!this.capabilityProvider.supportsCapability(OperatorCapability.POLYNOMINAL_LABEL)) {
                        throw new UserError(learningOperator, 501, learningOperator.getName(), OperatorCapability.POLYNOMINAL_LABEL.getDescription());
                    }
                } else if (labelAttribute.isNumerical() && !this.capabilityProvider.supportsCapability(OperatorCapability.NUMERICAL_LABEL)) {
                    throw new UserError(learningOperator, 501, learningOperator.getName(), OperatorCapability.NUMERICAL_LABEL.getDescription());
                }
            } else if (!this.capabilityProvider.supportsCapability(OperatorCapability.NO_LABEL)) {
                throw new UserError(learningOperator, 501, learningOperator.getName(), OperatorCapability.NO_LABEL.getDescription());
            }
        }
        catch (UserError e) {
            if (this.onlyWarn) {
                learningOperator.logWarning(e.getMessage());
            }
            throw e;
        }
    }
}

