/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner;

import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.learner.CapabilityCheck;
import com.rapidminer.operator.learner.Learner;
import com.rapidminer.operator.learner.PredictionModel;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.metadata.GenerateNewMDRule;
import com.rapidminer.operator.ports.metadata.GeneratePredictionModelTransformationRule;
import com.rapidminer.operator.ports.metadata.LearnerPrecondition;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.MetaDataError;
import com.rapidminer.operator.ports.metadata.PassThroughRule;
import com.rapidminer.operator.ports.metadata.SimpleMetaDataError;
import com.rapidminer.tools.Tools;

public abstract class AbstractLearner
extends Operator
implements Learner {
    private final InputPort exampleSetInput = (InputPort)this.getInputPorts().createPort("training set");
    private final OutputPort modelOutput = (OutputPort)this.getOutputPorts().createPort("model");
    private final OutputPort performanceOutput = (OutputPort)this.getOutputPorts().createPort("estimated performance", this.canEstimatePerformance());
    private final OutputPort weightsOutput = (OutputPort)this.getOutputPorts().createPort("weights", this.canCalculateWeights());
    private final OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("exampleSet");

    public AbstractLearner(OperatorDescription description) {
        super(description);
        this.exampleSetInput.addPrecondition(new LearnerPrecondition(this, this.exampleSetInput));
        this.getTransformer().addRule(new GeneratePredictionModelTransformationRule(this.exampleSetInput, this.modelOutput, this.getModelClass()));
        this.getTransformer().addRule(new GenerateNewMDRule(this.performanceOutput, new MetaData(PerformanceVector.class)){

            @Override
            public MetaData modifyMetaData(MetaData unmodifiedMetaData) {
                if (AbstractLearner.this.canEstimatePerformance()) {
                    return unmodifiedMetaData;
                }
                return null;
            }
        });
        this.getTransformer().addRule(new GenerateNewMDRule(this.weightsOutput, new MetaData(AttributeWeights.class)){

            @Override
            public MetaData modifyMetaData(MetaData unmodifiedMetaData) {
                if (AbstractLearner.this.canCalculateWeights()) {
                    return unmodifiedMetaData;
                }
                if (AbstractLearner.this.weightsOutput.isConnected()) {
                    AbstractLearner.this.weightsOutput.addError(AbstractLearner.this.getWeightCalculationError(AbstractLearner.this.weightsOutput));
                }
                return null;
            }
        });
        this.getTransformer().addRule(new PassThroughRule(this.exampleSetInput, this.exampleSetOutput, false));
    }

    @Override
    public boolean shouldAutoConnect(OutputPort outputPort) {
        if (outputPort == this.performanceOutput) {
            return this.shouldEstimatePerformance();
        }
        if (outputPort == this.weightsOutput) {
            return this.shouldCalculateWeights();
        }
        if (outputPort == this.exampleSetOutput) {
            return this.getParameterAsBoolean("keep_example_set");
        }
        return super.shouldAutoConnect(outputPort);
    }

    public Model doWork(ExampleSet exampleSet) throws OperatorException {
        this.exampleSetInput.receive(exampleSet);
        this.doWork();
        return (Model)this.modelOutput.getData();
    }

    public AttributeWeights getWeights() throws OperatorException {
        return (AttributeWeights)this.weightsOutput.getData();
    }

    public Class<? extends PredictionModel> getModelClass() {
        return PredictionModel.class;
    }

    @Override
    public void doWork() throws OperatorException {
        AttributeWeights weights;
        ExampleSet exampleSet = (ExampleSet)this.exampleSetInput.getData();
        if (exampleSet.getAttributes().getLabel() == null) {
            throw new UserError((Operator)this, 105);
        }
        if (exampleSet.getAttributes().size() == 0) {
            throw new UserError((Operator)this, 106);
        }
        if (exampleSet.size() == 0) {
            throw new UserError((Operator)this, 117);
        }
        CapabilityCheck check = new CapabilityCheck(this, Tools.booleanValue(System.getProperty("rapidminer.general.capabilities.warn"), true) || this.onlyWarnForNonSufficientCapabilities());
        check.checkLearnerCapabilities(this, exampleSet);
        Model model = this.learn(exampleSet);
        this.modelOutput.deliver(model);
        if (this.canCalculateWeights() && this.weightsOutput.isConnected() && (weights = this.getWeights(exampleSet)) != null) {
            this.weightsOutput.deliver(weights);
        }
        if (this.canEstimatePerformance() && this.performanceOutput.isConnected()) {
            PerformanceVector perfVector = null;
            perfVector = this.shouldDeliverOptimizationPerformance() ? this.getOptimizationPerformance() : this.getEstimatedPerformance();
            this.performanceOutput.deliver(perfVector);
        }
        this.exampleSetOutput.deliver(exampleSet);
    }

    @Override
    @Deprecated
    public boolean shouldEstimatePerformance() {
        return false;
    }

    public boolean canEstimatePerformance() {
        return false;
    }

    @Override
    @Deprecated
    public boolean shouldCalculateWeights() {
        return false;
    }

    public boolean canCalculateWeights() {
        return false;
    }

    public MetaDataError getWeightCalculationError(OutputPort weightPort) {
        return new SimpleMetaDataError(ProcessSetupError.Severity.ERROR, (Port)weightPort, "parameters.incompatible_for_delivering", "AttributeWeights");
    }

    public boolean shouldDeliverOptimizationPerformance() {
        return false;
    }

    @Override
    public PerformanceVector getEstimatedPerformance() throws OperatorException {
        throw new UserError((Operator)this, 912, this.getName(), "estimation of performance not supported.");
    }

    public PerformanceVector getOptimizationPerformance() throws OperatorException {
        throw new UserError((Operator)this, 912, this.getName(), "delivering the original optimization performance is not supported.");
    }

    @Override
    public AttributeWeights getWeights(ExampleSet exampleSet) throws OperatorException {
        throw new UserError((Operator)this, 916, this.getName(), "calculation of weights not supported.");
    }

    public boolean onlyWarnForNonSufficientCapabilities() {
        return false;
    }

    public InputPort getExampleSetInputPort() {
        return this.exampleSetInput;
    }
}

