/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.io;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.io.AbstractExampleSetWriter;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.io.Encoding;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class XrffExampleSetWriter
extends AbstractExampleSetWriter {
    public static final String PARAMETER_EXAMPLE_SET_FILE = "example_set_file";
    public static final String PARAMETER_COMPRESS = "compress";

    public XrffExampleSetWriter(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet write(ExampleSet exampleSet) throws OperatorException {
        try {
            File xrffFile = this.getParameterAsFile(PARAMETER_EXAMPLE_SET_FILE, true);
            Charset encoding = Encoding.getEncoding(this);
            FileOutputStream outputStream = new FileOutputStream(xrffFile);
            XrffExampleSetWriter.writeXrff(exampleSet, outputStream, encoding);
        }
        catch (IOException e) {
            throw new UserError((Operator)this, (Throwable)e, 303, this.getParameterAsString(PARAMETER_EXAMPLE_SET_FILE), e.getMessage());
        }
        return exampleSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeXrff(ExampleSet exampleSet, OutputStream outputStream, Charset encoding) {
        PrintWriter out = null;
        try {
            out = new PrintWriter(new OutputStreamWriter(outputStream, encoding));
            out.println("<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>");
            out.println("<dataset name=\"RapidMinerData\" version=\"3.5.4\">");
            out.println("  <header>");
            out.println("    <attributes>");
            Iterator<AttributeRole> a = exampleSet.getAttributes().allAttributeRoles();
            while (a.hasNext()) {
                AttributeRole role = a.next();
                if (role.getSpecialName() != null && role.getSpecialName().equals("weight")) continue;
                Attribute attribute = role.getAttribute();
                boolean label = role.getSpecialName() != null && role.getSpecialName().equals("label");
                XrffExampleSetWriter.printAttribute(attribute, out, label);
            }
            out.println("    </attributes>");
            out.println("  </header>");
            out.println("  <body>");
            out.println("    <instances>");
            Attribute weightAttribute = exampleSet.getAttributes().getWeight();
            for (Example example : exampleSet) {
                String weightString = "";
                if (weightAttribute != null) {
                    weightString = " weight=\"" + example.getValue(weightAttribute) + "\"";
                }
                out.println("      <instance" + weightString + ">");
                a = exampleSet.getAttributes().allAttributeRoles();
                while (a.hasNext()) {
                    AttributeRole role = a.next();
                    if (role.getSpecialName() != null && role.getSpecialName().equals("weight")) continue;
                    Attribute attribute = role.getAttribute();
                    out.println("        <value>" + Tools.escapeXML(example.getValueAsString(attribute)) + "</value>");
                }
                out.println("      </instance>");
            }
            out.println("    </instances>");
            out.println("  </body>");
            out.println("</dataset>");
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private static void printAttribute(Attribute attribute, PrintWriter out, boolean isClass) {
        String classString;
        String string = classString = isClass ? "class=\"yes\" " : "";
        if (attribute.isNominal()) {
            out.println("      <attribute name=\"" + Tools.escapeXML(attribute.getName()) + "\" " + classString + "type=\"nominal\">");
            out.println("        <labels>");
            for (String s : attribute.getMapping().getValues()) {
                out.println("          <label>" + Tools.escapeXML(s) + "</label>");
            }
            out.println("        </labels>");
            out.println("      </attribute>");
        } else {
            out.println("      <attribute name=\"" + Tools.escapeXML(attribute.getName()) + "\" " + classString + "type=\"numeric\"/>");
        }
    }

    @Override
    protected boolean supportsEncoding() {
        return true;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        types.add(new ParameterTypeFile(PARAMETER_EXAMPLE_SET_FILE, "File to save the example set to.", "xrff", false));
        types.addAll(super.getParameterTypes());
        return types;
    }
}

