/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.io;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AbstractExampleTable;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.io.AbstractExampleSource;
import com.rapidminer.operator.preprocessing.GuessValueTypes;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.tools.OperatorService;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.io.Encoding;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;

public class URLExampleSource
extends AbstractExampleSource {
    public static final String PARAMETER_URL = "url";
    public static final String PARAMETER_COLUMN_SEPARATORS = "column_separators";
    public static final String PARAMETER_DECIMAL_POINT_CHARACTER = "decimal_point_character";
    public static final String PARAMETER_READ_ATTRIBUTE_NAMES = "read_attribute_names";
    public static final String PARAMETER_SKIP_ERROR_LINES = "skip_error_lines";

    public URLExampleSource(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet createExampleSet() throws OperatorException {
        boolean readAttributeNames = this.getParameterAsBoolean(PARAMETER_READ_ATTRIBUTE_NAMES);
        boolean skipErrorLines = this.getParameterAsBoolean(PARAMETER_SKIP_ERROR_LINES);
        char decimalPointCharacter = this.getParameterAsString(PARAMETER_DECIMAL_POINT_CHARACTER).charAt(0);
        AbstractExampleTable table = null;
        BufferedReader in = null;
        try {
            InputStream inputStream = this.getParameterAsInputStream(PARAMETER_URL);
            in = new BufferedReader(new InputStreamReader(inputStream, Encoding.getEncoding(this)));
            String line = null;
            Pattern separatorPattern = Pattern.compile(this.getParameterAsString(PARAMETER_COLUMN_SEPARATORS));
            int rowLength = -1;
            int lineCounter = 1;
            ArrayList<Attribute> attributes = new ArrayList<Attribute>();
            while ((line = in.readLine()) != null) {
                if (line.trim().length() == 0) continue;
                String[] row = Tools.quotedSplit(line, separatorPattern);
                if (rowLength >= 0 && rowLength != row.length) {
                    if (skipErrorLines) {
                        this.logWarning("Wrong number of columns in line " + lineCounter + ": was " + row.length + ", expected " + rowLength);
                        continue;
                    }
                    throw new UserError((Operator)this, 302, this.getParameter(PARAMETER_URL), "Wrong number of columns in line " + lineCounter + ": was " + row.length + ", expected " + rowLength);
                }
                if (rowLength < 0) {
                    rowLength = row.length;
                }
                boolean skipLine = false;
                if (table == null) {
                    int attCounter = 1;
                    for (String r : row) {
                        if (readAttributeNames) {
                            attributes.add(AttributeFactory.createAttribute(r, 1));
                        } else {
                            attributes.add(AttributeFactory.createAttribute("Att" + attCounter, 1));
                        }
                        ++attCounter;
                    }
                    table = new MemoryExampleTable(attributes);
                    if (readAttributeNames) {
                        skipLine = true;
                    }
                }
                if (!skipLine) {
                    double[] data = new double[row.length];
                    for (int i = 0; i < data.length; ++i) {
                        data[i] = ((Attribute)attributes.get(i)).getMapping().mapString(row[i]);
                    }
                    ((MemoryExampleTable)table).addDataRow(new DoubleArrayDataRow(data));
                }
                ++lineCounter;
            }
        }
        catch (IOException e) {
            throw new UserError((Operator)this, 302, this.getParameter(PARAMETER_URL), e.getMessage());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        ExampleSet exampleSet = table.createExampleSet();
        try {
            GuessValueTypes guessValuesTypes = OperatorService.createOperator(GuessValueTypes.class);
            guessValuesTypes.setParameter(PARAMETER_DECIMAL_POINT_CHARACTER, Character.toString(decimalPointCharacter));
            exampleSet = guessValuesTypes.apply(exampleSet);
        }
        catch (OperatorCreationException e) {
            throw new OperatorException("Cannot create GuessValueTypes: " + e, e);
        }
        return exampleSet;
    }

    @Override
    protected boolean supportsEncoding() {
        return true;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        types.add(new ParameterTypeString(PARAMETER_URL, "The url to read the data from.", false));
        ParameterTypeSingle type = new ParameterTypeString(PARAMETER_COLUMN_SEPARATORS, "Column separators for data files (regular expression)", ",\\s*|;\\s*|\\s+");
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_READ_ATTRIBUTE_NAMES, "Read attribute names from file (assumes the attribute names are in the first line of the file).", false);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeBoolean(PARAMETER_SKIP_ERROR_LINES, "Indicates if lines which can not be read should be skipped instead of letting this operator fail its execution.", false));
        types.add(new ParameterTypeString(PARAMETER_DECIMAL_POINT_CHARACTER, "Character that is used as decimal point.", "."));
        types.addAll(super.getParameterTypes());
        return types;
    }
}

