/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.io;

import com.rapidminer.RapidMiner;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.io.AbstractWriter;
import com.rapidminer.operator.postprocessing.Threshold;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.tools.io.Encoding;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.List;

public class ThresholdWriter
extends AbstractWriter<Threshold> {
    public static final String PARAMETER_THRESHOLD_FILE = "threshold_file";

    public ThresholdWriter(OperatorDescription description) {
        super(description, Threshold.class);
    }

    @Override
    public Threshold write(Threshold threshold) throws OperatorException {
        File thresholdFile = this.getParameterAsFile(PARAMETER_THRESHOLD_FILE, true);
        PrintWriter out = null;
        try {
            out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(thresholdFile), Encoding.getEncoding(this)));
            out.println("<?xml version=\"1.0\" encoding=\"" + Encoding.getEncoding(this) + "\"?>");
            out.println("<threshold version=\"" + RapidMiner.getShortVersion() + "\" value=\"" + threshold.getThreshold() + "\" first=\"" + threshold.getZeroClass() + "\" second=\"" + threshold.getOneClass() + "\"/>");
            out.close();
        }
        catch (IOException e) {
            throw new UserError((Operator)this, (Throwable)e, 303, thresholdFile, e.getMessage());
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        return threshold;
    }

    @Override
    protected boolean supportsEncoding() {
        return true;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        types.add(new ParameterTypeFile(PARAMETER_THRESHOLD_FILE, "Filename for the threshold file.", "thr", false));
        types.addAll(super.getParameterTypes());
        return types;
    }
}

