/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.io;

import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.io.AbstractReader;
import com.rapidminer.operator.postprocessing.Threshold;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class ThresholdLoader
extends AbstractReader<Threshold> {
    public static final String PARAMETER_THRESHOLD_FILE = "threshold_file";

    public ThresholdLoader(OperatorDescription description) {
        super(description, Threshold.class);
    }

    @Override
    public Threshold read() throws OperatorException {
        File thresholdFile = this.getParameterAsFile(PARAMETER_THRESHOLD_FILE);
        Threshold threshold = null;
        try {
            FileInputStream in = new FileInputStream(thresholdFile);
            Document document = null;
            try {
                document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(in);
            }
            catch (SAXException e1) {
                throw new IOException(e1.getMessage());
            }
            catch (ParserConfigurationException e1) {
                throw new IOException(e1.getMessage());
            }
            Element thresholdElement = document.getDocumentElement();
            if (!thresholdElement.getTagName().equals("threshold")) {
                throw new IOException("Outer tag of threshold file must be <threshold>");
            }
            String thresholdValueString = thresholdElement.getAttribute("value");
            String thresholdFirst = thresholdElement.getAttribute("first");
            String thresholdSecond = thresholdElement.getAttribute("second");
            double thresholdValue = Double.parseDouble(thresholdValueString);
            threshold = new Threshold(thresholdValue, thresholdFirst, thresholdSecond);
            ((InputStream)in).close();
        }
        catch (IOException e) {
            throw new UserError((Operator)this, (Throwable)e, 303, thresholdFile, e.getMessage());
        }
        return threshold;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeFile(PARAMETER_THRESHOLD_FILE, "Filename for the threshold file.", "thr", false));
        return types;
    }
}

