/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.io;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.DataRowFactory;
import com.rapidminer.example.table.DataRowReader;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.io.BytewiseExampleSource;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.RandomGenerator;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.att.AttributeSet;
import com.rapidminer.tools.math.sampling.OrderedSamplingWithoutReplacement;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;

public class StataExampleSource
extends BytewiseExampleSource {
    public static final String PARAMETER_ATTRIBUTE_NAMING_MODE = "attribute_naming_mode";
    public static final String PARAMETER_HANDLE_VALUE_LABELS = "handle_value_labels";
    public static final String PARAMETER_SAMPLE_RATIO = "sample_ratio";
    public static final String PARAMETER_SAMPLE_SIZE = "sample_size";
    private static final String STATA_FILE_SUFFIX = "dta";
    public static final int USE_VAR_NAME = 0;
    public static final int USE_VAR_LABEL = 1;
    public static final int USE_VAR_NAME_LABELED = 2;
    public static final int USE_VAR_LABEL_NAMED = 3;
    public static final String[] ATTRIBUTE_NAMING_MODES = new String[]{"name", "label", "name (label)", "label (name)"};
    public static final int FORCE_NUMERIC = 0;
    public static final int IGNORE = 1;
    public static final int USE_ADDITIONALLY = 2;
    public static final int USE_EXCLUSIVELY = 3;
    public static final String[] HANDLE_VALUE_LABELS_MODES = new String[]{"force numeric", "ignore", "use additionally", "use exclusively"};
    private static final int CODE_STRING_TERMINATOR = 0;
    private static final int CODE_DS_FORMAT_VERSION_113 = 113;
    private static final int CODE_DS_FORMAT_VERSION_114 = 114;
    private static final int CODE_BYTEORDER_HILO = 1;
    private static final int CODE_BYTEORDER_LOHI = 2;
    private static final int CODE_FILETYPE = 1;
    private static final int LENGTH_HEADER = 109;
    private static final int INDEX_HEADER_DS_FORMAT = 0;
    private static final int INDEX_HEADER_BYTEORDER = 1;
    private static final int INDEX_HEADER_FILETYPE = 2;
    private static final int INDEX_HEADER_NUMBER_OF_ATTRIBUTES = 4;
    private static final int INDEX_HEADER_NUMBER_OF_EXAMPLES = 6;
    private static final int CODE_TYPE_BYTE = 251;
    private static final int CODE_TYPE_INT = 252;
    private static final int CODE_TYPE_LONG = 253;
    private static final int CODE_TYPE_FLOAT = 254;
    private static final int CODE_TYPE_DOUBLE = 255;
    private static final int LENGTH_TYPE_BYTE = 1;
    private static final int LENGTH_TYPE_INT = 2;
    private static final int LENGTH_TYPE_LONG = 4;
    private static final int LENGTH_TYPE_FLOAT = 4;
    private static final int LENGTH_TYPE_DOUBLE = 8;
    private static final int LENGTH_ATTRIBUTE_NAME = 33;
    private static final int LENGTH_ATTRIBUTE_FORMAT_VERSION_113 = 12;
    private static final int LENGTH_ATTRIBUTE_FORMAT_VERSION_114 = 49;
    private static final int LENGTH_ATTRIBUTE_VALUE_LABEL_IDENTIFIER = 33;
    private static final int LENGTH_ATTRIBUTE_LABEL = 81;
    private static final int LENGTH_EXPANSION_FIELD_HEADER = 5;
    private static final int INDEX_EXPANSION_FIELD_HEADER_TYPE = 0;
    private static final int INDEX_EXPANSION_FIELD_HEADER_LENGTH = 1;
    private static final int LENGTH_VALUE_LABEL_HEADER = 40;
    private static final int INDEX_VALUE_LABEL_HEADER_LENGTH = 0;
    private static final int INDEX_VALUE_LABEL_HEADER_NAME = 4;
    private static final int LENGTH_VALUE_LABEL_HEADER_NAME = 33;
    private static final int INDEX_VALUE_LABEL_TABLE_NUMBER_OF_ENTRIES = 0;
    private static final int INDEX_VALUE_LABEL_TABLE_TEXT_LENGTH = 4;
    private static final int INDEX_VALUE_LABEL_TABLE_OFFSETS = 8;
    private static final byte CODE_MAXIMUM_NONMISSING_BYTE = 100;
    private static final int CODE_MAXIMUM_NONMISSING_INT = 32740;
    private static final int CODE_MAXIMUM_NONMISSING_LONG = 2147483620;
    private static final double CODE_MAXIMUM_NONMISSING_FLOAT = 1.701E38;
    private static final double CODE_MAXIMUM_NONMISSING_DOUBLE = 8.988E307;

    public StataExampleSource(OperatorDescription description) {
        super(description);
    }

    @Override
    protected String getFileSuffix() {
        return STATA_FILE_SUFFIX;
    }

    @Override
    protected ExampleSet readStream(InputStream inputStream, DataRowFactory dataRowFactory) throws IOException, UndefinedParameterError {
        int i;
        int attributeNamingMode = this.getParameterAsInt(PARAMETER_ATTRIBUTE_NAMING_MODE);
        int handleValueLabelsMode = this.getParameterAsInt(PARAMETER_HANDLE_VALUE_LABELS);
        double sampleRatio = this.getParameterAsDouble(PARAMETER_SAMPLE_RATIO);
        int sampleSize = this.getParameterAsInt(PARAMETER_SAMPLE_SIZE);
        RandomGenerator randomGenerator = RandomGenerator.getRandomGenerator(this);
        byte[] buffer = new byte[500];
        boolean reverseEndian = false;
        this.read(inputStream, buffer, 109);
        int dataSetFormat = 0xFF & buffer[0];
        if (dataSetFormat != 113 && dataSetFormat != 114) {
            throw new IOException("Unsupported data set format");
        }
        if (buffer[2] != 1) {
            throw new IOException("Wrong file format");
        }
        byte byteOrder = buffer[1];
        if (byteOrder != 2 && byteOrder != 1) {
            throw new IOException("Wrong file format");
        }
        reverseEndian = byteOrder == 2;
        int numberOfAttributes = this.extract2ByteInt(buffer, 4, reverseEndian);
        int numberOfExamples = this.extractInt(buffer, 6, reverseEndian);
        byte[] attributeTypes = new byte[numberOfAttributes];
        this.read(inputStream, buffer, numberOfAttributes);
        for (int i2 = 0; i2 < numberOfAttributes; ++i2) {
            attributeTypes[i2] = buffer[i2];
        }
        String[] attributeNames = new String[numberOfAttributes];
        for (i = 0; i < numberOfAttributes; ++i) {
            this.read(inputStream, buffer, 33);
            String attributeNameString = new String(buffer, 0, 33);
            attributeNames[i] = attributeNameString.substring(0, attributeNameString.indexOf(0)).trim();
        }
        this.read(inputStream, buffer, 2 * (numberOfAttributes + 1));
        for (i = 0; i < numberOfAttributes; ++i) {
            if (dataSetFormat == 113) {
                this.read(inputStream, buffer, 12);
                continue;
            }
            if (dataSetFormat != 114) continue;
            this.read(inputStream, buffer, 49);
        }
        String[] valueLabelsIdentifiers = new String[numberOfAttributes];
        boolean[] labeled = new boolean[numberOfAttributes];
        for (int i3 = 0; i3 < numberOfAttributes; ++i3) {
            this.read(inputStream, buffer, 33);
            labeled[i3] = buffer[0] != 0;
            String valueLabelsIdentifierString = new String(buffer, 0, 33);
            valueLabelsIdentifiers[i3] = valueLabelsIdentifierString.substring(0, valueLabelsIdentifierString.indexOf(0)).trim();
            if (!valueLabelsIdentifiers[i3].equals("")) continue;
            valueLabelsIdentifiers[i3] = null;
        }
        String[] attributeLabels = new String[numberOfAttributes];
        for (int i4 = 0; i4 < numberOfAttributes; ++i4) {
            this.read(inputStream, buffer, 81);
            String attributeLabelString = new String(buffer, 0, 81);
            attributeLabels[i4] = attributeLabelString.substring(0, attributeLabelString.indexOf(0)).trim();
            if (!attributeLabels[i4].equals("")) continue;
            attributeLabels[i4] = null;
        }
        while (true) {
            this.read(inputStream, buffer, 5);
            int expansionFieldContentsLength = this.extractInt(buffer, 1, reverseEndian);
            if (buffer[0] == 0 && expansionFieldContentsLength == 0) break;
            this.read(inputStream, buffer, expansionFieldContentsLength);
        }
        LinkedHashMap attributeValueLabelIdentifiersMap = new LinkedHashMap();
        AttributeSet attributeSet = new AttributeSet(numberOfAttributes);
        for (int i5 = 0; i5 < numberOfAttributes; ++i5) {
            int valueType = 0;
            switch (0xFF & attributeTypes[i5]) {
                case 251: {
                    valueType = 3;
                    break;
                }
                case 252: {
                    valueType = 3;
                    break;
                }
                case 253: {
                    valueType = 3;
                    break;
                }
                case 254: {
                    valueType = 2;
                    break;
                }
                case 255: {
                    valueType = 2;
                    break;
                }
                default: {
                    valueType = 1;
                }
            }
            if (labeled[i5] && handleValueLabelsMode != 0) {
                valueType = 1;
            }
            String attributeName = null;
            switch (attributeNamingMode) {
                case 0: {
                    attributeName = attributeNames[i5];
                    break;
                }
                case 1: {
                    attributeName = attributeLabels[i5] == null ? attributeNames[i5] : attributeLabels[i5];
                    break;
                }
                case 2: {
                    attributeName = attributeLabels[i5] == null ? attributeNames[i5] : attributeNames[i5] + " (" + attributeLabels[i5] + ")";
                    break;
                }
                case 3: {
                    attributeName = attributeLabels[i5] == null ? attributeNames[i5] : attributeLabels[i5] + " (" + attributeNames[i5] + ")";
                    break;
                }
                default: {
                    attributeName = attributeNames[i5];
                }
            }
            Attribute attribute = AttributeFactory.createAttribute(attributeName, valueType);
            attributeSet.addAttribute(attribute);
            if (attributeValueLabelIdentifiersMap.get(valueLabelsIdentifiers[i5]) == null) {
                attributeValueLabelIdentifiersMap.put(valueLabelsIdentifiers[i5], new LinkedList());
            }
            if (valueLabelsIdentifiers[i5] == null) continue;
            ((List)attributeValueLabelIdentifiersMap.get(valueLabelsIdentifiers[i5])).add(attribute);
        }
        OrderedSamplingWithoutReplacement sampling = null;
        sampling = sampleSize != -1 ? new OrderedSamplingWithoutReplacement(randomGenerator, numberOfExamples, sampleSize) : new OrderedSamplingWithoutReplacement(randomGenerator, numberOfExamples, sampleRatio);
        MemoryExampleTable table = new MemoryExampleTable(attributeSet.getAllAttributes());
        for (int j = 0; j < numberOfExamples; ++j) {
            DataRow dataRow = dataRowFactory.create(numberOfAttributes);
            for (int i6 = 0; i6 < numberOfAttributes; ++i6) {
                Attribute attribute = attributeSet.getAttribute(i6);
                double value = Double.NaN;
                switch (0xFF & attributeTypes[i6]) {
                    case 251: {
                        this.read(inputStream, buffer, 1);
                        byte byteValue = buffer[0];
                        value = byteValue > 100 ? Double.NaN : (double)byteValue;
                        break;
                    }
                    case 252: {
                        this.read(inputStream, buffer, 2);
                        int intValue = this.extract2ByteInt(buffer, 0, reverseEndian);
                        value = intValue > 32740 ? Double.NaN : (double)intValue;
                        break;
                    }
                    case 253: {
                        this.read(inputStream, buffer, 4);
                        int longValue = this.extractInt(buffer, 0, reverseEndian);
                        value = longValue > 2147483620 ? Double.NaN : (double)longValue;
                        break;
                    }
                    case 254: {
                        this.read(inputStream, buffer, 4);
                        float floatValue = this.extractFloat(buffer, 0, reverseEndian);
                        value = (double)floatValue > 1.701E38 ? Double.NaN : (double)floatValue;
                        break;
                    }
                    case 255: {
                        this.read(inputStream, buffer, 8);
                        double doubleValue = this.extractDouble(buffer, 0, reverseEndian);
                        value = doubleValue > 8.988E307 ? Double.NaN : doubleValue;
                        break;
                    }
                    default: {
                        int length = 0xFF & attributeTypes[i6];
                        this.read(inputStream, buffer, length);
                        String stringValue = new String(buffer, 0, length);
                        int stringTerminatorIndex = stringValue.indexOf(0);
                        value = stringTerminatorIndex < 0 || stringTerminatorIndex >= length ? (double)attribute.getMapping().mapString(stringValue.trim()) : (double)attribute.getMapping().mapString(stringValue.substring(0, stringTerminatorIndex).trim());
                    }
                }
                dataRow.set(attribute, value);
            }
            if (sampling == null) {
                table.addDataRow(dataRow);
                continue;
            }
            if (!sampling.acceptElement()) continue;
            table.addDataRow(dataRow);
        }
        int readLength = -1;
        LinkedHashMap valueMappingsMap = new LinkedHashMap();
        do {
            if ((readLength = this.readWithoutLengthCheck(inputStream, buffer, 40)) <= 0) continue;
            int length = this.extractInt(buffer, 0, reverseEndian);
            String valueLabelIdentifierString = new String(buffer, 4, 33);
            String valueLabelIdentifier = valueLabelIdentifierString.substring(0, valueLabelIdentifierString.indexOf(0)).trim();
            LinkedHashMap<Double, String> valueMap = new LinkedHashMap<Double, String>();
            if (length > 500) {
                buffer = new byte[length];
            }
            this.read(inputStream, buffer, length);
            int numberOfEntries = this.extractInt(buffer, 0, reverseEndian);
            int textLength = this.extractInt(buffer, 4, reverseEndian);
            int[] offset = new int[numberOfEntries];
            for (int i7 = 0; i7 < numberOfEntries; ++i7) {
                offset[i7] = this.extractInt(buffer, 8 + i7 * 4, reverseEndian);
            }
            double[] values = new double[numberOfEntries];
            for (int i8 = 0; i8 < numberOfEntries; ++i8) {
                values[i8] = this.extractInt(buffer, 8 + numberOfEntries * 4 + i8 * 4, reverseEndian);
            }
            String[] nominalValues = new String[numberOfEntries];
            for (int i9 = 0; i9 < numberOfEntries; ++i9) {
                nominalValues[i9] = this.extractString(buffer, 8 + 2 * numberOfEntries * 4 + offset[i9], textLength - offset[i9]);
                int stringTerminatorIndex = nominalValues[i9].indexOf(0);
                if (stringTerminatorIndex < 0) {
                    valueMap.put(values[i9], nominalValues[i9].trim());
                    continue;
                }
                valueMap.put(values[i9], nominalValues[i9].substring(0, nominalValues[i9].indexOf(0)).trim());
            }
            for (Attribute attribute : (List)attributeValueLabelIdentifiersMap.get(valueLabelIdentifier)) {
                valueMappingsMap.put(attribute, valueMap);
            }
        } while (readLength >= 0);
        inputStream.close();
        if (handleValueLabelsMode != 0) {
            Attribute[] attributes = table.getAttributes();
            LinkedHashMap[] attributeValueMaps = new LinkedHashMap[numberOfAttributes];
            for (int i10 = 0; i10 < attributes.length; ++i10) {
                attributeValueMaps[i10] = (LinkedHashMap)valueMappingsMap.get(attributes[i10]);
            }
            DataRowReader iterator = table.getDataRowReader();
            while (iterator.hasNext()) {
                DataRow dataRow = (DataRow)iterator.next();
                for (int i11 = 0; i11 < attributes.length; ++i11) {
                    if (!labeled[i11] || attributeValueMaps[i11] == null) continue;
                    double originalValue = dataRow.get(attributes[i11]);
                    double value = Double.NaN;
                    switch (handleValueLabelsMode) {
                        case 1: {
                            value = attributes[i11].getMapping().mapString(Tools.formatIntegerIfPossible(originalValue));
                            break;
                        }
                        case 2: {
                            String nominalValue = (String)attributeValueMaps[i11].get(originalValue);
                            if (nominalValue != null) {
                                value = attributes[i11].getMapping().mapString(nominalValue);
                                break;
                            }
                            value = attributes[i11].getMapping().mapString(Tools.formatIntegerIfPossible(originalValue));
                            break;
                        }
                        case 3: {
                            String nominalValue = (String)attributeValueMaps[i11].get(originalValue);
                            value = nominalValue != null ? (double)attributes[i11].getMapping().mapString(nominalValue) : Double.NaN;
                        }
                    }
                    dataRow.set(attributes[i11], value);
                }
            }
        }
        ExampleSet exampleSet = table.createExampleSet();
        return exampleSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeCategory(PARAMETER_ATTRIBUTE_NAMING_MODE, "Determines which variable properties should be used for attribute naming.", ATTRIBUTE_NAMING_MODES, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeCategory(PARAMETER_HANDLE_VALUE_LABELS, "Specifies how to handle attributes with value labels, i.e. whether to ignore the labels or how to use them.", HANDLE_VALUE_LABELS_MODES, 2);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_SAMPLE_RATIO, "The fraction of the data set which should be read (1 = all; only used if sample_size = -1)", 0.0, 1.0, 1.0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_SAMPLE_SIZE, "The exact number of samples which should be read (-1 = all; if not -1, sample_ratio will not have any effect)", -1, Integer.MAX_VALUE, -1);
        type.setExpert(true);
        types.add(type);
        types.addAll(RandomGenerator.getRandomGeneratorParameters(this));
        return types;
    }
}

