/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.io;

import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleFormatter;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.FormatterException;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.io.AppendingExampleSetWriter;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.tools.io.Encoding;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.zip.GZIPOutputStream;

public class SpecialFormatExampleSetWriter
extends AppendingExampleSetWriter {
    public static final String PARAMETER_SPECIAL_FORMAT = "special_format";
    public static final String PARAMETER_EXAMPLE_SET_FILE = "example_set_file";
    public static final String PARAMETER_FRACTION_DIGITS = "fraction_digits";
    public static final String PARAMETER_QUOTE_NOMINAL_VALUES = "quote_nominal_values";
    public static final String PARAMETER_ZIPPED = "zipped";
    public static final String PARAMETER_OVERWRITE_MODE = "overwrite_mode";

    public SpecialFormatExampleSetWriter(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet write(ExampleSet ioobject) throws OperatorException {
        boolean zipped = this.getParameterAsBoolean(PARAMETER_ZIPPED);
        File dataFile = this.getParameterAsFile(PARAMETER_EXAMPLE_SET_FILE, true);
        if (zipped) {
            dataFile = new File(dataFile.getAbsolutePath() + ".gz");
        }
        boolean quoteNominal = this.getParameterAsBoolean(PARAMETER_QUOTE_NOMINAL_VALUES);
        int fractionDigits = this.getParameterAsInt(PARAMETER_FRACTION_DIGITS);
        if (fractionDigits < 0) {
            fractionDigits = -2;
        }
        Charset encoding = Encoding.getEncoding(this);
        this.writeSpecialFormat(ioobject, dataFile, fractionDigits, quoteNominal, zipped, this.shouldAppend(dataFile), encoding);
        return ioobject;
    }

    @Override
    protected boolean supportsEncoding() {
        return true;
    }

    private void writeSpecialFormat(ExampleSet exampleSet, File dataFile, int fractionDigits, boolean quoteNominal, boolean zipped, boolean append, Charset encoding) throws OperatorException {
        ExampleFormatter formatter;
        String format = this.getParameterAsString(PARAMETER_SPECIAL_FORMAT);
        if (format == null) {
            throw new UserError((Operator)this, 201, PARAMETER_SPECIAL_FORMAT, "format", PARAMETER_SPECIAL_FORMAT);
        }
        try {
            formatter = ExampleFormatter.compile(format, exampleSet, fractionDigits, quoteNominal);
        }
        catch (FormatterException e) {
            throw new UserError((Operator)this, 901, format, e.getMessage());
        }
        OutputStream out = null;
        PrintWriter writer = null;
        try {
            out = zipped ? new GZIPOutputStream(new FileOutputStream(dataFile, append)) : new FileOutputStream(dataFile, append);
            writer = new PrintWriter(new OutputStreamWriter(out, encoding));
            Iterator reader = exampleSet.iterator();
            while (reader.hasNext()) {
                writer.println(formatter.format((Example)reader.next()));
            }
        }
        catch (IOException e) {
            throw new UserError((Operator)this, 303, dataFile, e.getMessage());
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    this.getLogger().log(Level.WARNING, "Cannot close stream to file " + dataFile, e);
                }
            }
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        types.add(new ParameterTypeFile(PARAMETER_EXAMPLE_SET_FILE, "File to save the example set to.", "dat", false));
        types.add(new ParameterTypeString(PARAMETER_SPECIAL_FORMAT, "Format string to use for output.", false));
        types.add(new ParameterTypeInt(PARAMETER_FRACTION_DIGITS, "The number of fraction digits in the output file (-1: all possible digits).", -1, Integer.MAX_VALUE, -1));
        types.add(new ParameterTypeBoolean(PARAMETER_QUOTE_NOMINAL_VALUES, "Indicates if nominal values should be quoted with double quotes.", true));
        types.add(new ParameterTypeBoolean(PARAMETER_ZIPPED, "Indicates if the data file content should be zipped.", false));
        types.add(new ParameterTypeCategory(PARAMETER_OVERWRITE_MODE, "Indicates if an existing table should be overwritten or if data should be appended.", OVERWRITE_MODES, 1));
        types.addAll(super.getParameterTypes());
        return types;
    }
}

