/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.io;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.DataRowFactory;
import com.rapidminer.example.table.FileDataRowReader;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.gui.tools.dialogs.wizards.dataimport.csv.CSVFileReader;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.io.AbstractExampleSource;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeChar;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.tools.LineParser;
import com.rapidminer.tools.RandomGenerator;
import com.rapidminer.tools.StrictDecimalFormat;
import com.rapidminer.tools.att.AttributeDataSource;
import com.rapidminer.tools.att.AttributeDataSourceCreator;
import com.rapidminer.tools.att.AttributeDataSources;
import com.rapidminer.tools.att.AttributeSet;
import com.rapidminer.tools.io.Encoding;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;

@Deprecated
public class SimpleExampleSource
extends AbstractExampleSource {
    public static final String PARAMETER_LABEL_NAME = "label_name";
    public static final String PARAMETER_LABEL_COLUMN = "label_column";
    public static final String PARAMETER_ID_NAME = "id_name";
    public static final String PARAMETER_ID_COLUMN = "id_column";
    public static final String PARAMETER_WEIGHT_NAME = "weight_name";
    public static final String PARAMETER_WEIGHT_COLUMN = "weight_column";
    public static final String PARAMETER_SAMPLE_RATIO = "sample_ratio";
    public static final String PARAMETER_SAMPLE_SIZE = "sample_size";
    public static final String PARAMETER_FILENAME = "file_name";
    public static final String PARAMETER_USE_FIRST_ROW_AS_ATTRIBUTE_NAMES = "use_first_row_as_attribute_names";
    public static final String PARAMETER_TRIM_LINES = "trim_lines";
    public static final String PARAMETER_SKIP_COMMENTS = "skip_comments";
    public static final String PARAMETER_COMMENT_CHARS = "comment_characters";
    public static final String PARAMETER_USE_QUOTES = "use_quotes";
    public static final String PARAMETER_QUOTES_CHARACTER = "quotes_character";
    public static final String PARAMETER_COLUMN_SEPARATORS = "column_separators";

    public SimpleExampleSource(OperatorDescription description) {
        super(description);
    }

    public CSVFileReader createReader(File file) throws UndefinedParameterError {
        LineParser parser = new LineParser();
        parser.setTrimLine(this.getParameterAsBoolean(PARAMETER_TRIM_LINES));
        parser.setSkipComments(this.getParameterAsBoolean(PARAMETER_SKIP_COMMENTS));
        try {
            parser.setSplitExpression(this.getParameterAsString(PARAMETER_COLUMN_SEPARATORS));
        }
        catch (OperatorException e) {
            throw new UndefinedParameterError(e.getMessage());
        }
        parser.setUseQuotes(this.getParameterAsBoolean(PARAMETER_USE_QUOTES));
        parser.setQuoteCharacter(this.getParameterAsChar(PARAMETER_QUOTES_CHARACTER));
        parser.setCommentCharacters(this.getParameterAsString(PARAMETER_COMMENT_CHARS));
        StrictDecimalFormat numberFormat = StrictDecimalFormat.getInstance(this);
        CSVFileReader reader = new CSVFileReader(file, this.getParameterAsBoolean(PARAMETER_USE_FIRST_ROW_AS_ATTRIBUTE_NAMES), parser, numberFormat);
        return reader;
    }

    @Override
    public MetaData getGeneratedMetaData() throws OperatorException {
        File file = this.getParameterAsFile(PARAMETER_FILENAME);
        CSVFileReader reader = this.createReader(this.getParameterAsFile(PARAMETER_FILENAME));
        MetaData metaData = null;
        try {
            metaData = reader.getMetaData();
        }
        catch (FileNotFoundException e) {
            throw new UserError((Operator)this, 302, file, e.getMessage());
        }
        catch (IOException e) {
            // empty catch block
        }
        return metaData;
    }

    @Override
    public ExampleSet createExampleSet() throws OperatorException {
        File file = this.getParameterAsFile(PARAMETER_FILENAME);
        CSVFileReader reader = this.createReader(file);
        ExampleSet result = null;
        try {
            result = reader.createExampleSet();
        }
        catch (IOException e) {
            // empty catch block
        }
        return result;
    }

    public static ExampleSet createExampleSet(File file, boolean firstRowAsColumnNames, double sampleRatio, int maxLines, String separatorRegExpr, char[] comments, int dataRowType, boolean useQuotes, boolean trimLines, boolean skipErrorLines, char decimalPointCharacter, Charset encoding, String labelName, int labelColumn, String idName, int idColumn, String weightName, int weightColumn) throws IOException, UserError, IndexOutOfBoundsException {
        AttributeDataSourceCreator adsCreator = new AttributeDataSourceCreator();
        adsCreator.loadData(file, comments, separatorRegExpr, decimalPointCharacter, useQuotes, '\"', '\\', trimLines, firstRowAsColumnNames, -1, skipErrorLines, encoding, null);
        List<AttributeDataSource> attributeDataSources = adsCreator.getAttributeDataSources();
        SimpleExampleSource.resetAttributeType(attributeDataSources, labelName, labelColumn, "label");
        SimpleExampleSource.resetAttributeType(attributeDataSources, idName, idColumn, "id");
        SimpleExampleSource.resetAttributeType(attributeDataSources, weightName, weightColumn, "weight");
        FileDataRowReader reader = new FileDataRowReader(new DataRowFactory(dataRowType, decimalPointCharacter), attributeDataSources, sampleRatio, maxLines, separatorRegExpr, comments, useQuotes, '\"', '\\', trimLines, skipErrorLines, encoding, RandomGenerator.getGlobalRandomGenerator());
        if (firstRowAsColumnNames) {
            reader.skipLine();
        }
        AttributeSet attributeSet = new AttributeSet(new AttributeDataSources(attributeDataSources, file, encoding));
        MemoryExampleTable table = new MemoryExampleTable(attributeSet.getAllAttributes(), reader);
        ExampleSet result = table.createExampleSet(attributeSet);
        return result;
    }

    private static void resetAttributeType(List<AttributeDataSource> attributeDataSources, String attribute, int column, String typeName) throws IndexOutOfBoundsException {
        block4: {
            block3: {
                if (attribute != null && attribute.length() != 0) break block3;
                if (column == 0) break block4;
                if (column < 0) {
                    column = attributeDataSources.size() + column + 1;
                }
                if (column < 1 || column >= attributeDataSources.size() + 1) {
                    throw new IndexOutOfBoundsException("column = " + column + " as label");
                }
                attributeDataSources.get(--column).setType(typeName);
                break block4;
            }
            for (AttributeDataSource ads : attributeDataSources) {
                if (!ads.getAttribute().getName().equals(attribute)) continue;
                ads.setType(typeName);
                break;
            }
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeFile(PARAMETER_FILENAME, "Name of the file to read the data from.", "dat", false));
        types.addAll(Encoding.getParameterTypes(this));
        types.add(new ParameterTypeBoolean(PARAMETER_TRIM_LINES, "Indicates if lines should be trimmed (empty spaces are removed at the beginning and the end) before the column split is performed.", false));
        types.add(new ParameterTypeBoolean(PARAMETER_SKIP_COMMENTS, "Indicates if qa comment character should be used.", true));
        ParameterTypeSingle type = new ParameterTypeString(PARAMETER_COMMENT_CHARS, "Lines beginning with these characters are ignored.", "#", true);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_SKIP_COMMENTS, false, true));
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_USE_FIRST_ROW_AS_ATTRIBUTE_NAMES, "Read attribute names from file (assumes the attribute names are in the first line of the file).", false);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeBoolean(PARAMETER_USE_QUOTES, "Indicates if quotes should be regarded (slower!).", false));
        type = new ParameterTypeChar(PARAMETER_QUOTES_CHARACTER, "The quotes character.", '\"', true);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_USE_QUOTES, false, true));
        types.add(type);
        types.add(new ParameterTypeString(PARAMETER_COLUMN_SEPARATORS, "Column separators for data files (regular expression)", ",\\s*|;\\s*|\\s+"));
        types.addAll(StrictDecimalFormat.getParameterTypes(this));
        type = new ParameterTypeString(PARAMETER_LABEL_NAME, "Name of the label attribute (if empty, the column defined by label_column will be used)", true);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_LABEL_COLUMN, "Column number of the label attribute (only used if label_name is empty; 0 = none; negative values are counted from the last column)", Integer.MIN_VALUE, Integer.MAX_VALUE, 0);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeString(PARAMETER_ID_NAME, "Name of the id attribute (if empty, the column defined by id_column will be used)", true));
        types.add(new ParameterTypeInt(PARAMETER_ID_COLUMN, "Column number of the id attribute (only used if id_name is empty; 0 = none; negative values are counted from the last column)", Integer.MIN_VALUE, Integer.MAX_VALUE, 0));
        types.add(new ParameterTypeString(PARAMETER_WEIGHT_NAME, "Name of the weight attribute (if empty, the column defined by weight_column will be used)", true));
        types.add(new ParameterTypeInt(PARAMETER_WEIGHT_COLUMN, "Column number of the weight attribute (only used if weight_name is empty; 0 = none, negative values are counted from the last column)", Integer.MIN_VALUE, Integer.MAX_VALUE, 0));
        types.add(new ParameterTypeDouble(PARAMETER_SAMPLE_RATIO, "The fraction of the data set which should be read (1 = all; only used if sample_size = -1)", 0.0, 1.0, 1.0));
        types.add(new ParameterTypeInt(PARAMETER_SAMPLE_SIZE, "The exact number of samples which should be read (-1 = use sample ratio; if not -1, sample_ratio will not have any effect)", -1, Integer.MAX_VALUE, -1));
        return types;
    }
}

