/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.io;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ResultObject;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.PortPairExtender;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.tools.ResultService;
import com.rapidminer.tools.io.Encoding;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.List;

public class ResultWriter
extends Operator {
    public static final String PARAMETER_RESULT_FILE = "result_file";
    private boolean firstRun = true;
    private PortPairExtender portExtender = new PortPairExtender("input", this.getInputPorts(), this.getOutputPorts());

    public ResultWriter(OperatorDescription description) {
        super(description);
        this.portExtender.start();
        this.getTransformer().addRule(this.portExtender.makePassThroughRule());
    }

    @Override
    public void doWork() throws OperatorException {
        IOObject[] input = this.portExtender.getData().toArray(new IOObject[0]);
        File file = this.getParameterAsFile(PARAMETER_RESULT_FILE, true);
        if (file != null) {
            PrintWriter out = null;
            try {
                out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, !this.firstRun), Encoding.getEncoding(this)));
                this.firstRun = false;
            }
            catch (IOException e) {
                throw new UserError((Operator)this, 301, file);
            }
            if (out != null) {
                ResultService.logResult("Results of ResultWriter '" + this.getName() + "' [" + this.getApplyCount() + "]: ", out);
                for (int i = 0; i < input.length; ++i) {
                    if (!(input[i] instanceof ResultObject)) continue;
                    ResultService.logResult((ResultObject)input[i], out);
                }
                out.close();
            }
        } else {
            ResultService.logResult("Results of ResultWriter '" + this.getName() + "' [" + this.getApplyCount() + "]: ");
            for (int i = 0; i < input.length; ++i) {
                if (!(input[i] instanceof ResultObject)) continue;
                ResultService.logResult((ResultObject)input[i]);
            }
        }
        this.portExtender.passDataThrough();
    }

    @Override
    public void processStarts() throws OperatorException {
        super.processStarts();
        this.firstRun = true;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeFile type = new ParameterTypeFile(PARAMETER_RESULT_FILE, "Appends the descriptions of the input objects to this file. If empty, use the general file defined in the process root operator.", "res", true);
        type.setExpert(false);
        types.add(type);
        types.addAll(Encoding.getParameterTypes(this));
        return types;
    }
}

