/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.io;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.SimpleProcessSetupError;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.io.AbstractReader;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeRepositoryLocation;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.repository.Entry;
import com.rapidminer.repository.IOObjectEntry;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.RepositoryLocation;
import java.util.List;
import java.util.logging.Level;

public class RepositorySource
extends AbstractReader<IOObject> {
    public static final String PARAMETER_REPOSITORY_ENTRY = "repository_entry";

    public RepositorySource(OperatorDescription description) {
        super(description, IOObject.class);
    }

    @Override
    public MetaData getGeneratedMetaData() throws OperatorException {
        IOObjectEntry entry;
        try {
            entry = this.getRepositoryEntry();
        }
        catch (RepositoryException e) {
            this.addError(new SimpleProcessSetupError(ProcessSetupError.Severity.WARNING, this.getPortOwner(), "repository_access_error", this.getParameterAsRepositoryLocation(PARAMETER_REPOSITORY_ENTRY), e.getMessage()));
            return super.getGeneratedMetaData();
        }
        catch (UndefinedParameterError e) {
            return super.getGeneratedMetaData();
        }
        if (entry != null) {
            try {
                MetaData metaData = entry.retrieveMetaData().clone();
                if (metaData instanceof ExampleSetMetaData) {
                    for (AttributeMetaData amd : ((ExampleSetMetaData)metaData).getAllAttributes()) {
                        if (!amd.isNominal()) continue;
                        amd.shrinkValueSet();
                    }
                }
                return metaData;
            }
            catch (RepositoryException e) {
                this.getLogger().log(Level.INFO, "Error retrieving meta data from " + entry.getLocation() + ": " + e, e);
                return super.getGeneratedMetaData();
            }
        }
        this.addError(new SimpleProcessSetupError(ProcessSetupError.Severity.WARNING, this.getPortOwner(), "repository_location_does_not_exist", this.getParameterAsRepositoryLocation(PARAMETER_REPOSITORY_ENTRY)));
        return super.getGeneratedMetaData();
    }

    private IOObjectEntry getRepositoryEntry() throws RepositoryException, UserError {
        RepositoryLocation location = this.getParameterAsRepositoryLocation(PARAMETER_REPOSITORY_ENTRY);
        Entry entry = location.locateEntry();
        if (entry == null) {
            throw new RepositoryException("Entry '" + location + "' does not exist.");
        }
        if (entry instanceof IOObjectEntry) {
            return (IOObjectEntry)entry;
        }
        throw new RepositoryException("Entry '" + location + "' is not a data entry, but " + entry.getType());
    }

    @Override
    public IOObject read() throws OperatorException {
        try {
            return this.getRepositoryEntry().retrieveData(null);
        }
        catch (RepositoryException e) {
            throw new UserError((Operator)this, (Throwable)e, 312, this.getParameterAsString(PARAMETER_REPOSITORY_ENTRY), e.getMessage());
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeRepositoryLocation type = new ParameterTypeRepositoryLocation(PARAMETER_REPOSITORY_ENTRY, "Repository entry.", false);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

