/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.io;

import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.io.AbstractWriter;
import com.rapidminer.operator.meta.ParameterSet;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.tools.io.Encoding;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.List;

public class ParameterSetWriter
extends AbstractWriter<ParameterSet> {
    public static final String PARAMETER_PARAMETER_FILE = "parameter_file";

    public ParameterSetWriter(OperatorDescription description) {
        super(description, ParameterSet.class);
    }

    @Override
    public ParameterSet write(ParameterSet parameterSet) throws OperatorException {
        File parameterFile = this.getParameterAsFile(PARAMETER_PARAMETER_FILE, true);
        PrintWriter out = null;
        try {
            out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(parameterFile), Encoding.getEncoding(this)));
            parameterSet.writeParameterSet(out, Encoding.getEncoding(this));
        }
        catch (IOException e) {
            throw new UserError((Operator)this, 303, e, new Object[]{parameterFile, e.getMessage()});
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        return parameterSet;
    }

    @Override
    protected boolean supportsEncoding() {
        return true;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        types.add(new ParameterTypeFile(PARAMETER_PARAMETER_FILE, "A file containing a parameter set.", "par", false));
        types.addAll(super.getParameterTypes());
        return types;
    }
}

