/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.io;

import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.io.AbstractWriter;
import com.rapidminer.operator.io.OutputTypes;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeFile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.GZIPOutputStream;

public class ModelWriter
extends AbstractWriter<Model> {
    public static final String PARAMETER_MODEL_FILE = "model_file";
    public static final String PARAMETER_OVERWRITE_EXISTING_FILE = "overwrite_existing_file";
    public static final String PARAMETER_OUTPUT_TYPE = "output_type";

    public ModelWriter(OperatorDescription description) {
        super(description, Model.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Model write(Model model) throws OperatorException {
        File modelFile = this.getParameterAsFile(PARAMETER_MODEL_FILE, true);
        if (!this.getParameterAsBoolean(PARAMETER_OVERWRITE_EXISTING_FILE) && modelFile.exists()) {
            File newFile = null;
            String fileName = modelFile.getAbsolutePath();
            int counter = 1;
            while (true) {
                String[] extension = fileName.split("\\.");
                int n = extension.length - 2;
                extension[n] = extension[n] + "_" + counter + ".";
                String newFileName = this.stringArrayToString(extension);
                newFile = new File(newFileName);
                if (!newFile.exists()) {
                    modelFile = newFile;
                    break;
                }
                ++counter;
            }
        }
        int outputType = this.getParameterAsInt(PARAMETER_OUTPUT_TYPE);
        switch (outputType) {
            case 0: {
                OutputStream out = null;
                try {
                    out = new FileOutputStream(modelFile);
                    model.write(out);
                    if (out == null) return model;
                }
                catch (IOException e) {
                    try {
                        throw new UserError((Operator)this, (Throwable)e, 303, modelFile, e.getMessage());
                    }
                    catch (Throwable throwable) {
                        if (out == null) throw throwable;
                        try {
                            out.close();
                            throw throwable;
                        }
                        catch (IOException e2) {
                            this.logError("Cannot close stream to file " + modelFile);
                        }
                        throw throwable;
                    }
                }
                try {
                    out.close();
                    return model;
                }
                catch (IOException e) {
                    this.logError("Cannot close stream to file " + modelFile);
                    return model;
                }
            }
            case 1: {
                OutputStream out = null;
                try {
                    out = new GZIPOutputStream(new FileOutputStream(modelFile));
                    model.write(out);
                    if (out == null) return model;
                }
                catch (IOException e) {
                    try {
                        throw new UserError((Operator)this, (Throwable)e, 303, modelFile, e.getMessage());
                    }
                    catch (Throwable throwable) {
                        if (out == null) throw throwable;
                        try {
                            out.close();
                            throw throwable;
                        }
                        catch (IOException e3) {
                            this.logError("Cannot close stream to file " + modelFile);
                        }
                        throw throwable;
                    }
                }
                try {
                    out.close();
                    return model;
                }
                catch (IOException e) {
                    this.logError("Cannot close stream to file " + modelFile);
                    return model;
                }
            }
            case 2: {
                ObjectOutputStream objectOut = null;
                try {
                    objectOut = new ObjectOutputStream(new FileOutputStream(modelFile));
                    objectOut.writeObject(model);
                    if (objectOut == null) return model;
                }
                catch (IOException e) {
                    try {
                        throw new UserError((Operator)this, (Throwable)e, 303, modelFile, e.getMessage());
                    }
                    catch (Throwable throwable) {
                        if (objectOut == null) throw throwable;
                        try {
                            objectOut.close();
                            throw throwable;
                        }
                        catch (IOException e4) {
                            this.logError("Cannot close stream to file " + modelFile);
                        }
                        throw throwable;
                    }
                }
                try {
                    objectOut.close();
                    return model;
                }
                catch (IOException e) {
                    this.logError("Cannot close stream to file " + modelFile);
                    return model;
                }
            }
        }
        return model;
    }

    private String stringArrayToString(String[] filenameParts) {
        StringBuffer newString = new StringBuffer();
        for (int i = 0; i < filenameParts.length; ++i) {
            newString.append(filenameParts[i]);
        }
        return newString.toString();
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeFile(PARAMETER_MODEL_FILE, "Filename for the model file.", "mod", false));
        types.add(new ParameterTypeBoolean(PARAMETER_OVERWRITE_EXISTING_FILE, "Overwrite an existing file. If set to false then an index is appended to the filename.", true));
        types.add(new ParameterTypeCategory(PARAMETER_OUTPUT_TYPE, "Indicates the type of the output", OutputTypes.OUTPUT_TYPES, 1));
        return types;
    }
}

