/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.io;

import com.rapidminer.operator.AbstractIOObject;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.io.AbstractModelLoader;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.parameter.UndefinedParameterError;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class ModelLoader
extends AbstractModelLoader {
    public static final String PARAMETER_MODEL_FILE = "model_file";

    public ModelLoader(OperatorDescription description) {
        super(description);
    }

    @Override
    public Model read() throws OperatorException {
        IOObject model;
        this.getParameter(PARAMETER_MODEL_FILE);
        AbstractIOObject.InputStreamProvider inputStreamProvider = new AbstractIOObject.InputStreamProvider(){

            @Override
            public InputStream getInputStream() throws IOException {
                try {
                    return ModelLoader.this.getParameterAsInputStream(ModelLoader.PARAMETER_MODEL_FILE);
                }
                catch (UndefinedParameterError e) {
                    throw new IOException(e);
                }
            }
        };
        try {
            model = AbstractIOObject.read(inputStreamProvider);
        }
        catch (IOException e) {
            throw new UserError((Operator)this, (Throwable)e, 302, this.getParameter(PARAMETER_MODEL_FILE), e);
        }
        if (!(model instanceof Model)) {
            throw new UserError((Operator)this, 942, this.getParameter(PARAMETER_MODEL_FILE), "Model", model.getClass().getSimpleName());
        }
        return (Model)model;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeFile(PARAMETER_MODEL_FILE, "Filename containing the model to load.", "mod", false));
        return types;
    }
}

