/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.io;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.io.OutputTypes;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.PassThroughRule;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeFile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.GZIPOutputStream;

public class IOObjectWriter
extends Operator {
    private InputPort objectInput = this.getInputPorts().createPort("object", IOObject.class);
    private OutputPort objectOutput = (OutputPort)this.getOutputPorts().createPort("object");
    public static final String PARAMETER_OBJECT_FILE = "object_file";
    public static final String PARAMETER_OUTPUT_TYPE = "output_type";
    public static final String PARAMETER_CONTINUE_ON_ERROR = "continue_on_error";

    public IOObjectWriter(OperatorDescription description) {
        super(description);
        this.getTransformer().addRule(new PassThroughRule(this.objectInput, this.objectOutput, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void doWork() throws OperatorException {
        Object object = this.objectInput.getData();
        File objectFile = this.getParameterAsFile(PARAMETER_OBJECT_FILE, true);
        int outputType = this.getParameterAsInt(PARAMETER_OUTPUT_TYPE);
        switch (outputType) {
            case 0: {
                FileOutputStream out = null;
                out = new FileOutputStream(objectFile);
                object.write(out);
                if (out == null) break;
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException e) {
                    this.logError("Cannot close stream to file " + objectFile);
                }
                break;
                catch (IOException e) {
                    try {
                        if (!this.getParameterAsBoolean(PARAMETER_CONTINUE_ON_ERROR)) {
                            throw new UserError((Operator)this, (Throwable)e, 303, objectFile, e.getMessage());
                        }
                        this.logError("Could not write IO Object to file " + objectFile + ": " + e.getMessage());
                        if (out == null) break;
                    }
                    catch (Throwable throwable) {
                        if (out != null) {
                            try {
                                ((OutputStream)out).close();
                            }
                            catch (IOException e2) {
                                this.logError("Cannot close stream to file " + objectFile);
                            }
                        }
                        throw throwable;
                    }
                    try {
                        ((OutputStream)out).close();
                    }
                    catch (IOException e3) {
                        this.logError("Cannot close stream to file " + objectFile);
                    }
                    break;
                }
            }
            case 1: {
                OutputStream out = null;
                out = new GZIPOutputStream(new FileOutputStream(objectFile));
                object.write(out);
                if (out == null) break;
                try {
                    out.close();
                }
                catch (IOException e) {
                    this.logError("Cannot close stream to file " + objectFile);
                }
                break;
                catch (IOException e) {
                    try {
                        if (!this.getParameterAsBoolean(PARAMETER_CONTINUE_ON_ERROR)) {
                            throw new UserError((Operator)this, (Throwable)e, 303, objectFile, e.getMessage());
                        }
                        this.logError("Could not write IO Object to file " + objectFile + ": " + e.getMessage());
                        if (out == null) break;
                    }
                    catch (Throwable throwable) {
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (IOException e4) {
                                this.logError("Cannot close stream to file " + objectFile);
                            }
                        }
                        throw throwable;
                    }
                    try {
                        out.close();
                    }
                    catch (IOException e5) {
                        this.logError("Cannot close stream to file " + objectFile);
                    }
                    break;
                }
            }
            case 2: {
                ObjectOutputStream objectOut = null;
                objectOut = new ObjectOutputStream(new FileOutputStream(objectFile));
                objectOut.writeObject(object);
                if (objectOut == null) break;
                try {
                    objectOut.close();
                }
                catch (IOException e) {
                    this.logError("Cannot close stream to file " + objectFile);
                }
                break;
                catch (IOException e) {
                    try {
                        if (!this.getParameterAsBoolean(PARAMETER_CONTINUE_ON_ERROR)) {
                            throw new UserError((Operator)this, (Throwable)e, 303, objectFile, e.getMessage());
                        }
                        this.logError("Could not write IO Object to file " + objectFile + ": " + e.getMessage());
                        if (objectOut == null) break;
                    }
                    catch (Throwable throwable) {
                        if (objectOut != null) {
                            try {
                                objectOut.close();
                            }
                            catch (IOException e6) {
                                this.logError("Cannot close stream to file " + objectFile);
                            }
                        }
                        throw throwable;
                    }
                    try {
                        objectOut.close();
                    }
                    catch (IOException e7) {
                        this.logError("Cannot close stream to file " + objectFile);
                    }
                    break;
                }
            }
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeFile(PARAMETER_OBJECT_FILE, "Filename of the object file.", "ioo", false));
        types.add(new ParameterTypeCategory(PARAMETER_OUTPUT_TYPE, "Indicates the type of the output", OutputTypes.OUTPUT_TYPES, 1));
        types.add(new ParameterTypeBoolean(PARAMETER_CONTINUE_ON_ERROR, "Defines behavior on errors", false));
        return types;
    }
}

