/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.io;

import com.rapidminer.operator.AbstractIOObject;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.io.AbstractReader;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.tools.OperatorService;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Set;

public class IOObjectReader
extends AbstractReader<IOObject> {
    public static final String PARAMETER_OBJECT_FILE = "object_file";
    public static final String PARAMETER_IO_OBJECT = "io_object";
    public static final String PARAMETER_IGNORE_TYPE = "ignore_type";
    private String[] objectArray = null;

    public IOObjectReader(OperatorDescription description) {
        super(description, IOObject.class);
    }

    @Override
    public MetaData getGeneratedMetaData() throws OperatorException {
        if (this.getParameterAsBoolean(PARAMETER_IGNORE_TYPE)) {
            return super.getGeneratedMetaData();
        }
        try {
            return new MetaData(this.getSelectedClass());
        }
        catch (UndefinedParameterError e) {
            return super.getGeneratedMetaData();
        }
    }

    @Override
    public IOObject read() throws OperatorException {
        IOObject object;
        this.getParameter(PARAMETER_OBJECT_FILE);
        AbstractIOObject.InputStreamProvider inputStreamProvider = new AbstractIOObject.InputStreamProvider(){

            @Override
            public InputStream getInputStream() throws IOException {
                try {
                    return IOObjectReader.this.getParameterAsInputStream(IOObjectReader.PARAMETER_OBJECT_FILE);
                }
                catch (UndefinedParameterError e) {
                    throw new IOException(e);
                }
            }
        };
        try {
            object = AbstractIOObject.read(inputStreamProvider);
        }
        catch (IOException e) {
            throw new UserError((Operator)this, (Throwable)e, 302, this.getParameter(PARAMETER_OBJECT_FILE), e);
        }
        if (object == null) {
            throw new UserError((Operator)this, 302, this.getParameter(PARAMETER_OBJECT_FILE), "cannot load object file");
        }
        Class<? extends IOObject> clazz = this.getSelectedClass();
        if (!clazz.isInstance(object) && !this.getParameterAsBoolean(PARAMETER_IGNORE_TYPE)) {
            throw new UserError((Operator)this, 942, this.getParameter(PARAMETER_OBJECT_FILE), clazz.getSimpleName(), object.getClass().getSimpleName());
        }
        return object;
    }

    private Class<? extends IOObject> getSelectedClass() throws UndefinedParameterError {
        int ioType = this.getParameterAsInt(PARAMETER_IO_OBJECT);
        if (this.getIOObjectNames() != null) {
            if (ioType != -1) {
                return OperatorService.getIOObjectClass(this.getIOObjectNames()[ioType]);
            }
            return IOObject.class;
        }
        return null;
    }

    private String[] getIOObjectNames() {
        if (this.objectArray == null) {
            Set<String> ioObjects = OperatorService.getIOObjectsNames();
            this.objectArray = ioObjects.toArray(new String[ioObjects.size()]);
        }
        return this.objectArray;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeFile(PARAMETER_OBJECT_FILE, "Filename of the object file.", "ioo", false));
        types.add(new ParameterTypeBoolean(PARAMETER_IGNORE_TYPE, "Indicates if the execution should be aborted if type of read object does not match selected type.", false));
        ParameterTypeCategory type = new ParameterTypeCategory(PARAMETER_IO_OBJECT, "The class of the object(s) which should be saved.", this.getIOObjectNames(), 0, false);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_IGNORE_TYPE, false, false));
        types.add(type);
        return types;
    }

    static {
        AbstractReader.registerReaderDescription(new AbstractReader.ReaderDescription("ioo", IOObjectReader.class, PARAMETER_OBJECT_FILE));
    }
}

