/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.io;

import com.rapidminer.gui.tools.dialogs.wizards.dataimport.excel.ExcelImportWizard;
import com.rapidminer.operator.Annotations;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.io.AbstractDataReader;
import com.rapidminer.operator.io.AbstractReader;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeConfiguration;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.UndefinedParameterError;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeSet;
import jxl.Cell;
import jxl.CellType;
import jxl.DateCell;
import jxl.NumberCell;
import jxl.Sheet;
import jxl.Workbook;
import jxl.read.biff.BiffException;

public class ExcelExampleSource
extends AbstractDataReader {
    public static final String ANNOTATION_NAME = "Name";
    public static final String ANNOTATION_NAMES_FROM_DOCUMENT = "Name from document";
    public static final String PARAMETER_EXCEL_FILE = "excel_file";
    public static final String PARAMETER_SHEET_NUMBER = "sheet_number";
    public static final String PARAMETER_FIRST_ROW_AS_NAMES = "first_row_as_names";
    public static final String PARAMETER_LABEL_COLUMN = "label_column";
    public static final String PARAMETER_ID_COLUMN = "id_column";
    public static final String PARAMETER_DATAMANAGEMENT = "datamanagement";
    public static final String PARAMETER_COLUMN_OFFSET = "column_offset";
    public static final String PARAMETER_ROW_OFFSET = "row_offset";
    public static final String PARAMETER_CREATE_LABEL = "create_label";
    public static final String PARAMETER_CREATE_ID = "create_id";
    public static final String PARAMETER_ANNOTATIONS = "annotations";
    private Workbook workbook = null;
    private boolean keepWorkbookOpen = false;
    private ExcelDataSet cacheDataSet = null;
    private boolean skipAnnotationRows = false;
    private int nameRowF = -1;
    private Map<Integer, String> annotationsMap;
    private Set<Integer> annotationRows;

    public ExcelExampleSource(OperatorDescription description) {
        super(description);
        this.getParameters().addObserver(new AbstractDataReader.CacheResetParameterObserver(PARAMETER_EXCEL_FILE), false);
    }

    @Override
    public void writeMetaDataInParameter() {
        try {
            List<String[]> annotations = this.getParameterList(PARAMETER_ANNOTATIONS);
            LinkedList<String[]> cleanedAnnotations = new LinkedList<String[]>();
            for (String[] pair : annotations) {
                if (!pair[1].equals(ANNOTATION_NAME)) {
                    cleanedAnnotations.add(pair);
                    continue;
                }
                pair[1] = ANNOTATION_NAMES_FROM_DOCUMENT;
                cleanedAnnotations.add(pair);
            }
            this.setParameter(PARAMETER_ANNOTATIONS, ParameterTypeList.transformList2String(cleanedAnnotations));
        }
        catch (UndefinedParameterError e) {
            e.printStackTrace();
        }
        super.writeMetaDataInParameter();
    }

    public void keepWorkbookOpen() {
        this.keepWorkbookOpen = true;
    }

    public void closeWorkbook() {
        if (this.workbook != null) {
            this.workbook.close();
        }
    }

    public void resetWorkbook() {
        this.closeWorkbook();
        this.workbook = null;
        this.cacheDataSet = null;
    }

    public void skipNameAnnotationRow(boolean flag) {
        this.skipAnnotationRows = flag;
    }

    @Override
    protected ExcelDataSet getDataSet() throws OperatorException {
        if (this.cacheDataSet != null) {
            this.cacheDataSet.setCurrentRow(0);
            return this.cacheDataSet;
        }
        List<String[]> allAnnotations = this.getParameterList(PARAMETER_ANNOTATIONS);
        this.annotationRows = new HashSet<Integer>();
        this.annotationsMap = new HashMap<Integer, String>();
        boolean nameFound = false;
        int lastAnnotatedRow = -1;
        int nameRow = -1;
        for (String[] pair : allAnnotations) {
            try {
                int row = Integer.parseInt(pair[0]);
                if (row > lastAnnotatedRow) {
                    lastAnnotatedRow = row;
                }
                this.annotationsMap.put(row, pair[1]);
                if (ANNOTATION_NAME.equals(pair[1])) {
                    nameFound = true;
                    nameRow = row;
                }
                this.annotationRows.add(row);
            }
            catch (NumberFormatException e) {
                throw new OperatorException("row_number entries in parameter list annotations must be integers.", e);
            }
        }
        if (nameFound && this.getParameterAsBoolean(PARAMETER_FIRST_ROW_AS_NAMES)) {
            throw new OperatorException("If first_row_as_names is set to true, you cannot use Name entries in parameter list annotations.");
        }
        if (this.getParameterAsBoolean(PARAMETER_FIRST_ROW_AS_NAMES)) {
            this.annotationsMap.put(0, ANNOTATION_NAME);
            this.annotationRows.add(0);
            nameRow = 0;
        }
        this.nameRowF = nameRow;
        return new ExcelDataSet();
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        ParameterTypeConfiguration type = new ParameterTypeConfiguration(ExcelImportWizard.ExcelExampleSourceConfigurationWizardCreator.class, this);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeFile(PARAMETER_EXCEL_FILE, "Name of the excel file to read the data from.", "xls", false));
        types.add(new ParameterTypeInt(PARAMETER_SHEET_NUMBER, "The number of the sheet which should be imported.", 1, Integer.MAX_VALUE, 1, false));
        types.add(new ParameterTypeInt(PARAMETER_ROW_OFFSET, "The number of rows to skip at top of sheet as they contain no usable data.", 0, 65535, 0, true));
        types.add(new ParameterTypeInt(PARAMETER_COLUMN_OFFSET, "The number of columns to skip at left side of sheet as they contain no usable data.", 0, 255, 0, true));
        types.add(new ParameterTypeBoolean(PARAMETER_FIRST_ROW_AS_NAMES, "Indicates if the first row should be used for the attribute names.", true, true));
        LinkedList<String> annotations = new LinkedList<String>();
        annotations.add(ANNOTATION_NAME);
        annotations.addAll(Arrays.asList(Annotations.ALL_KEYS_ATTRIBUTE));
        types.add(new ParameterTypeList(PARAMETER_ANNOTATIONS, "Maps row numbers to annotation names.", (ParameterType)new ParameterTypeInt("row_number", "Row number which contains an annotation", 0, Integer.MAX_VALUE), (ParameterType)new ParameterTypeCategory("annotation", "Name of the annotation to assign this row.", annotations.toArray(new String[annotations.size()]), 0)));
        types.addAll(super.getParameterTypes());
        return types;
    }

    static {
        AbstractReader.registerReaderDescription(new AbstractReader.ReaderDescription("xls", ExcelExampleSource.class, PARAMETER_EXCEL_FILE));
    }

    private class ExcelDataSet
    extends AbstractDataReader.DataSet {
        private Sheet sheet = null;
        private Cell[] cells = null;
        private SortedSet<Integer> emptyRows = new TreeSet<Integer>();
        private SortedSet<Integer> emptyColumns = new TreeSet<Integer>();
        private int rowOffset = 0;
        private int columnOffset = 0;
        private int numberOfRows = 0;
        private int numberOfColumns = 0;
        private int currentRow;

        public ExcelDataSet() throws OperatorException {
            int c;
            int r;
            this.rowOffset = ExcelExampleSource.this.getParameterAsInt(ExcelExampleSource.PARAMETER_ROW_OFFSET);
            this.columnOffset = ExcelExampleSource.this.getParameterAsInt(ExcelExampleSource.PARAMETER_COLUMN_OFFSET);
            this.currentRow = this.rowOffset;
            if (ExcelExampleSource.this.workbook != null) {
                // empty if block
            }
            try {
                ExcelExampleSource.this.workbook = Workbook.getWorkbook((InputStream)ExcelExampleSource.this.getParameterAsInputStream(ExcelExampleSource.PARAMETER_EXCEL_FILE));
            }
            catch (IOException e) {
                throw new UserError((Operator)ExcelExampleSource.this, 302, ExcelExampleSource.this.getParameter(ExcelExampleSource.PARAMETER_EXCEL_FILE), e.getMessage());
            }
            catch (BiffException e) {
                throw new UserError((Operator)ExcelExampleSource.this, 302, ExcelExampleSource.this.getParameter(ExcelExampleSource.PARAMETER_EXCEL_FILE), e.getMessage());
            }
            try {
                this.sheet = ExcelExampleSource.this.workbook.getSheet(ExcelExampleSource.this.getParameterAsInt(ExcelExampleSource.PARAMETER_SHEET_NUMBER) - 1);
            }
            catch (IndexOutOfBoundsException e) {
                throw new UserError((Operator)ExcelExampleSource.this, 953, ExcelExampleSource.this.getParameter(ExcelExampleSource.PARAMETER_SHEET_NUMBER));
            }
            this.numberOfColumns = this.sheet.getColumns();
            this.numberOfRows = this.sheet.getRows();
            boolean contentFound = false;
            for (r = this.rowOffset; r < this.numberOfRows; ++r) {
                for (int c2 = this.columnOffset; c2 < this.numberOfColumns; ++c2) {
                    if (this.sheet.getCell(c2, r).getType() == CellType.EMPTY || "".equals(this.sheet.getCell(c2, r).getContents().trim())) continue;
                    this.columnOffset = c2;
                    contentFound = true;
                    break;
                }
                if (!contentFound) continue;
                this.rowOffset = r;
                break;
            }
            if (!contentFound) {
                throw new UserError((Operator)ExcelExampleSource.this, 302, ExcelExampleSource.this.getParameter(ExcelExampleSource.PARAMETER_EXCEL_FILE), "spreadsheet seems to be empty");
            }
            for (r = this.rowOffset; r < this.numberOfRows; ++r) {
                boolean rowEmpty = true;
                for (c = this.columnOffset; c < this.numberOfColumns; ++c) {
                    if (this.sheet.getCell(c, r).getType() == CellType.EMPTY || "".equals(this.sheet.getCell(c, r).getContents().trim())) continue;
                    rowEmpty = false;
                    break;
                }
                if (!rowEmpty) continue;
                this.emptyRows.add(r);
            }
            for (int c3 = this.columnOffset; c3 < this.numberOfColumns; ++c3) {
                boolean columnEmpty = true;
                for (int r2 = this.rowOffset; r2 < this.numberOfRows; ++r2) {
                    if (this.sheet.getCell(c3, r2).getType() == CellType.EMPTY || "".equals(this.sheet.getCell(c3, r2).getContents().trim())) continue;
                    columnEmpty = false;
                    break;
                }
                if (!columnEmpty) continue;
                this.emptyColumns.add(c3);
            }
            if (ExcelExampleSource.this.nameRowF != -1) {
                String[] attributeNames = new String[this.numberOfColumns - this.columnOffset - this.emptyColumns.size()];
                int columnCounter = 0;
                for (c = this.columnOffset; c < this.numberOfColumns; ++c) {
                    if (this.emptyColumns.contains(c)) continue;
                    Cell cell = this.sheet.getCell(c, this.rowOffset + ExcelExampleSource.this.nameRowF);
                    attributeNames[columnCounter++] = cell.getContents();
                }
                ExcelExampleSource.this.setAttributeNames(attributeNames);
                ++this.currentRow;
            }
            int columnCounter = 0;
            Annotations[] annotations = new Annotations[this.numberOfColumns - this.columnOffset - this.emptyColumns.size()];
            boolean foundAnnotations = false;
            for (int c4 = this.columnOffset; c4 < this.numberOfColumns; ++c4) {
                if (this.emptyColumns.contains(c4)) continue;
                annotations[columnCounter] = new Annotations();
                for (Map.Entry entry : ExcelExampleSource.this.annotationsMap.entrySet()) {
                    if (ExcelExampleSource.ANNOTATION_NAME.equals(entry.getValue())) continue;
                    Cell cell = this.sheet.getCell(c4, this.rowOffset + (Integer)entry.getKey());
                    annotations[columnCounter].put((String)entry.getValue(), cell.getContents());
                    foundAnnotations = true;
                }
                ++columnCounter;
            }
            if (foundAnnotations) {
                ExcelExampleSource.this.setAnnotations(annotations);
            }
        }

        @Override
        public int getNumberOfColumnsInCurrentRow() {
            return this.numberOfColumns - this.columnOffset - this.emptyColumns.size();
        }

        @Override
        public boolean isMissing(int columnIndex) {
            return this.cells[columnIndex].getType() == CellType.EMPTY || this.cells[columnIndex].getType() == CellType.ERROR || this.cells[columnIndex].getType() == CellType.FORMULA_ERROR || this.cells[columnIndex].getContents() == null || "".equals(this.cells[columnIndex].getContents().trim());
        }

        @Override
        public Number getNumber(int columnIndex) {
            try {
                if (this.cells[columnIndex].getType() == CellType.NUMBER) {
                    return ((NumberCell)this.cells[columnIndex]).getValue();
                }
                return Double.valueOf(this.cells[columnIndex].getContents());
            }
            catch (ClassCastException e) {
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return null;
        }

        @Override
        public Date getDate(int columnIndex) {
            try {
                Date date = ((DateCell)this.cells[columnIndex]).getDate();
                if (date == null) {
                    return null;
                }
                int offset = TimeZone.getDefault().getOffset(date.getTime());
                return new Date(date.getTime() - (long)offset);
            }
            catch (ClassCastException classCastException) {
                return null;
            }
        }

        @Override
        public String getString(int columnIndex) {
            return this.cells[columnIndex].getContents();
        }

        @Override
        public boolean next() {
            while ((this.emptyRows.contains(this.currentRow) || ExcelExampleSource.this.skipAnnotationRows && ExcelExampleSource.this.annotationRows.contains(this.currentRow)) && this.currentRow < this.numberOfRows) {
                ++this.currentRow;
            }
            if (this.currentRow >= this.numberOfRows) {
                return false;
            }
            this.cells = new Cell[this.numberOfColumns - this.columnOffset - this.emptyColumns.size()];
            int columnCounter = 0;
            for (int c = this.columnOffset; c < this.numberOfColumns; ++c) {
                if (this.emptyColumns.contains(c)) continue;
                this.cells[columnCounter] = this.sheet.getCell(c, this.currentRow);
                ++columnCounter;
            }
            ++this.currentRow;
            return true;
        }

        @Override
        public void close() throws OperatorException {
            if (!ExcelExampleSource.this.keepWorkbookOpen) {
                ExcelExampleSource.this.workbook.close();
            }
        }

        public void setCurrentRow(int currentRow) {
            this.currentRow = currentRow;
        }
    }
}

