/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.io;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.io.AbstractExampleSetWriter;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.tools.Ontology;
import com.rapidminer.tools.io.Encoding;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.biff.DisplayFormat;
import jxl.format.CellFormat;
import jxl.write.DateFormat;
import jxl.write.DateTime;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.NumberFormat;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;

public class ExcelExampleSetWriter
extends AbstractExampleSetWriter {
    public static final String PARAMETER_EXCEL_FILE = "excel_file";

    public ExcelExampleSetWriter(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet write(ExampleSet exampleSet) throws OperatorException {
        File file = this.getParameterAsFile(PARAMETER_EXCEL_FILE, true);
        WorkbookSettings ws = new WorkbookSettings();
        Charset encoding = Encoding.getEncoding(this);
        ws.setEncoding(encoding.name());
        ws.setLocale(Locale.US);
        try {
            FileOutputStream out = new FileOutputStream(file);
            ExcelExampleSetWriter.write(exampleSet, encoding, out);
        }
        catch (Exception e) {
            throw new UserError((Operator)this, 303, file.getName(), e.getMessage());
        }
        return exampleSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(ExampleSet exampleSet, Charset encoding, OutputStream out) throws IOException, WriteException {
        try {
            WorkbookSettings ws = new WorkbookSettings();
            ws.setEncoding(encoding.name());
            ws.setLocale(Locale.US);
            WritableWorkbook workbook = Workbook.createWorkbook((OutputStream)out, (WorkbookSettings)ws);
            WritableSheet s = workbook.createSheet("RapidMiner Data", 0);
            ExcelExampleSetWriter.writeDataSheet(s, exampleSet);
            workbook.write();
            workbook.close();
        }
        finally {
            try {
                out.close();
            }
            catch (Exception exception) {}
        }
    }

    private static void writeDataSheet(WritableSheet s, ExampleSet exampleSet) throws WriteException {
        WritableFont wf = new WritableFont(WritableFont.ARIAL, 10, WritableFont.BOLD);
        WritableCellFormat cf = new WritableCellFormat(wf);
        Iterator<Attribute> a = exampleSet.getAttributes().allAttributes();
        int counter = 0;
        while (a.hasNext()) {
            Attribute attribute = a.next();
            s.addCell((WritableCell)new Label(counter++, 0, attribute.getName(), (CellFormat)cf));
        }
        NumberFormat nf = new NumberFormat("#.0");
        WritableCellFormat nfCell = new WritableCellFormat((DisplayFormat)nf);
        WritableFont wf2 = new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD);
        WritableCellFormat cf2 = new WritableCellFormat(wf2);
        DateFormat df = new DateFormat("yyyy-MM-dd hh:mm:ss");
        WritableCellFormat dfCell = new WritableCellFormat((DisplayFormat)df);
        int rowCounter = 1;
        for (Example example : exampleSet) {
            a = exampleSet.getAttributes().allAttributes();
            int columnCounter = 0;
            while (a.hasNext()) {
                Attribute attribute = a.next();
                if (!Double.isNaN(example.getValue(attribute))) {
                    if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), 1)) {
                        s.addCell((WritableCell)new Label(columnCounter, rowCounter, ExcelExampleSetWriter.replaceForbiddenChars(example.getValueAsString(attribute)), (CellFormat)cf2));
                    } else if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), 9)) {
                        DateTime dateTime = new DateTime(columnCounter, rowCounter, new Date((long)example.getValue(attribute)), (CellFormat)dfCell);
                        s.addCell((WritableCell)dateTime);
                    } else if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), 2)) {
                        Number number = new Number(columnCounter, rowCounter, example.getValue(attribute), (CellFormat)nfCell);
                        s.addCell((WritableCell)number);
                    } else {
                        s.addCell((WritableCell)new Label(columnCounter, rowCounter, ExcelExampleSetWriter.replaceForbiddenChars(example.getValueAsString(attribute)), (CellFormat)cf2));
                    }
                }
                ++columnCounter;
            }
            ++rowCounter;
        }
    }

    private static String replaceForbiddenChars(String originalValue) {
        return originalValue.replace('\u0000', ' ');
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeFile(PARAMETER_EXCEL_FILE, "The Excel spreadsheet file which should be written.", "xls", false));
        types.addAll(Encoding.getParameterTypes(this));
        return types;
    }
}

