/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.io;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.DataRowFactory;
import com.rapidminer.example.table.FileDataRowReader;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.gui.wizards.ExampleSourceConfigurationWizardCreator;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.io.AbstractExampleSource;
import com.rapidminer.operator.io.AbstractReader;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttributeFile;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeConfiguration;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.tools.RandomGenerator;
import com.rapidminer.tools.XMLException;
import com.rapidminer.tools.att.AttributeDataSource;
import com.rapidminer.tools.att.AttributeDataSources;
import com.rapidminer.tools.att.AttributeSet;
import com.rapidminer.tools.io.Encoding;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class ExampleSource
extends AbstractExampleSource {
    public static final String PARAMETER_ATTRIBUTES = "attributes";
    public static final String PARAMETER_SAMPLE_RATIO = "sample_ratio";
    public static final String PARAMETER_SAMPLE_SIZE = "sample_size";
    public static final String PARAMETER_PERMUTATE = "permute";
    public static final String PARAMETER_COLUMN_SEPARATORS = "column_separators";
    public static final String PARAMETER_USE_COMMENT_CHARACTERS = "use_comment_characters";
    public static final String PARAMETER_COMMENT_CHARS = "comment_chars";
    public static final String PARAMETER_DECIMAL_POINT_CHARACTER = "decimal_point_character";
    public static final String PARAMETER_USE_QUOTES = "use_quotes";
    public static final String PARAMETER_QUOTE_CHARACTER = "quote_character";
    public static final String PARAMETER_QUOTING_ESCAPE_CHARACTER = "quoting_escape_character";
    public static final String PARAMETER_TRIM_LINES = "trim_lines";
    public static final String PARAMETER_SKIP_ERROR_LINES = "skip_error_lines";
    public static final String PARAMETER_DATAMANAGEMENT = "datamanagement";

    public ExampleSource(OperatorDescription description) {
        super(description);
    }

    @Override
    public MetaData getGeneratedMetaData() throws OperatorException {
        AttributeDataSources attributeDataSources;
        this.getLogger().fine("Generating meta data for " + this.getName());
        File attributeFile = this.getParameterAsFile(PARAMETER_ATTRIBUTES);
        if (attributeFile == null) {
            return new ExampleSetMetaData();
        }
        try {
            attributeDataSources = AttributeDataSource.createAttributeDataSources(attributeFile, true, this);
        }
        catch (IOException e) {
            throw new UserError((Operator)this, (Throwable)e, 302, attributeFile, e.getMessage());
        }
        catch (XMLException e) {
            throw new UserError((Operator)this, (Throwable)e, 401, e.getMessage());
        }
        catch (ParserConfigurationException e) {
            throw new UserError((Operator)this, (Throwable)e, 401, e.toString());
        }
        catch (SAXException e) {
            throw new UserError((Operator)this, (Throwable)e, 401, e.toString());
        }
        AttributeSet attributeSet = new AttributeSet(attributeDataSources);
        ExampleSetMetaData emd = new ExampleSetMetaData();
        for (Map.Entry<String, Attribute> entry : attributeSet.getSpecialAttributes().entrySet()) {
            AttributeMetaData a = new AttributeMetaData(entry.getValue());
            a.setRole(entry.getKey());
            emd.addAttribute(a);
        }
        for (Attribute attribute : attributeSet.getRegularAttributes()) {
            emd.addAttribute(new AttributeMetaData(attribute));
        }
        return emd;
    }

    @Override
    protected boolean isMetaDataCacheable() {
        return true;
    }

    @Override
    public ExampleSet createExampleSet() throws OperatorException {
        AttributeDataSources attributeDataSources = null;
        FileDataRowReader reader = null;
        File attributeFile = this.getParameterAsFile(PARAMETER_ATTRIBUTES);
        try {
            attributeDataSources = AttributeDataSource.createAttributeDataSources(attributeFile, true, this);
            char[] commentCharacters = null;
            if (this.getParameterAsBoolean(PARAMETER_USE_COMMENT_CHARACTERS)) {
                commentCharacters = this.getParameterAsString(PARAMETER_COMMENT_CHARS).toCharArray();
            }
            reader = new FileDataRowReader(new DataRowFactory(this.getParameterAsInt(PARAMETER_DATAMANAGEMENT), this.getParameterAsString(PARAMETER_DECIMAL_POINT_CHARACTER).charAt(0)), attributeDataSources.getDataSources(), this.getParameterAsDouble(PARAMETER_SAMPLE_RATIO), this.getParameterAsInt(PARAMETER_SAMPLE_SIZE), this.getParameterAsString(PARAMETER_COLUMN_SEPARATORS), commentCharacters, this.getParameterAsBoolean(PARAMETER_USE_QUOTES), this.getParameterAsString(PARAMETER_QUOTE_CHARACTER).charAt(0), this.getParameterAsString(PARAMETER_QUOTING_ESCAPE_CHARACTER).charAt(0), this.getParameterAsBoolean(PARAMETER_TRIM_LINES), this.getParameterAsBoolean(PARAMETER_SKIP_ERROR_LINES), attributeDataSources.getEncoding() == null ? Encoding.getEncoding(this) : attributeDataSources.getEncoding(), RandomGenerator.getRandomGenerator(this.getParameterAsBoolean("use_local_random_seed"), this.getParameterAsInt("local_random_seed")));
        }
        catch (IOException e) {
            throw new UserError((Operator)this, (Throwable)e, 302, attributeFile, e.getMessage());
        }
        catch (XMLException e) {
            throw new UserError((Operator)this, (Throwable)e, 401, e.getMessage());
        }
        catch (ParserConfigurationException e) {
            throw new UserError((Operator)this, (Throwable)e, 401, e.toString());
        }
        catch (SAXException e) {
            throw new UserError((Operator)this, (Throwable)e, 401, e.toString());
        }
        AttributeSet attributeSet = new AttributeSet(attributeDataSources);
        MemoryExampleTable table = new MemoryExampleTable(attributeSet.getAllAttributes(), reader, this.getParameterAsBoolean(PARAMETER_PERMUTATE));
        ExampleSet result = table.createExampleSet(attributeSet);
        return result;
    }

    @Override
    protected boolean supportsEncoding() {
        return true;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        ParameterType type = new ParameterTypeConfiguration(ExampleSourceConfigurationWizardCreator.class, this);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeAttributeFile(PARAMETER_ATTRIBUTES, "Filename for the xml attribute description file. This file also contains the names of the files to read the data from.", false));
        type = new ParameterTypeDouble(PARAMETER_SAMPLE_RATIO, "The fraction of the data set which should be read (1 = all; only used if sample_size = -1)", 0.0, 1.0, 1.0);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeInt(PARAMETER_SAMPLE_SIZE, "The exact number of samples which should be read (-1 = use sample ratio; if not -1, sample_ratio will not have any effect)", -1, Integer.MAX_VALUE, -1));
        types.add(new ParameterTypeBoolean(PARAMETER_PERMUTATE, "Indicates if the loaded data should be permutated.", false));
        types.add(new ParameterTypeString(PARAMETER_DECIMAL_POINT_CHARACTER, "Character that is used as decimal point.", "."));
        types.add(new ParameterTypeString(PARAMETER_COLUMN_SEPARATORS, "Column separators for data files (regular expression)", ",\\s*|;\\s*|\\s+"));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_COMMENT_CHARACTERS, "Indicates if a comment character should be used.", true));
        type = new ParameterTypeString(PARAMETER_COMMENT_CHARS, "Any content in a line after one of these characters will be ignored.", "#");
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_USE_COMMENT_CHARACTERS, false, true));
        types.add(type);
        types.add(new ParameterTypeBoolean(PARAMETER_USE_QUOTES, "Indicates if quotes should be regarded.", true));
        type = new ParameterTypeString(PARAMETER_QUOTE_CHARACTER, "Specifies the character which should be used for quoting.", "\"");
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_USE_QUOTES, false, true));
        types.add(type);
        type = new ParameterTypeString(PARAMETER_QUOTING_ESCAPE_CHARACTER, "Specifies the character which should be used for escape the quoting.", "\\");
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_USE_QUOTES, false, true));
        types.add(type);
        types.add(new ParameterTypeBoolean(PARAMETER_TRIM_LINES, "Indicates if lines should be trimmed (empty spaces are removed at the beginning and the end) before the column split is performed.", false));
        types.add(new ParameterTypeBoolean(PARAMETER_SKIP_ERROR_LINES, "Indicates if lines which can not be read should be skipped instead of letting this operator fail its execution.", false));
        types.add(new ParameterTypeCategory(PARAMETER_DATAMANAGEMENT, "Determines, how the data is represented internally.", DataRowFactory.TYPE_NAMES, 0));
        types.addAll(super.getParameterTypes());
        types.addAll(RandomGenerator.getRandomGeneratorParameters(this));
        return types;
    }

    static {
        AbstractReader.registerReaderDescription(new AbstractReader.ReaderDescription("aml", ExampleSource.class, PARAMETER_ATTRIBUTES));
    }
}

