/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.io;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.SparseFormatDataRowReader;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.io.AppendingExampleSetWriter;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.tools.io.Encoding;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;

public class ExampleSetWriter
extends AppendingExampleSetWriter {
    public static final String PARAMETER_EXAMPLE_SET_FILE = "example_set_file";
    public static final String PARAMETER_ATTRIBUTE_DESCRIPTION_FILE = "attribute_description_file";
    public static final String PARAMETER_FORMAT = "format";
    public static final String PARAMETER_ZIPPED = "zipped";
    private static final String[] FORMAT_NAMES = new String[SparseFormatDataRowReader.FORMAT_NAMES.length + 1];
    private static final int DENSE_FORMAT = 0;

    public ExampleSetWriter(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet write(ExampleSet eSet) throws OperatorException {
        boolean zipped = this.getParameterAsBoolean(PARAMETER_ZIPPED);
        File dataFile = this.getParameterAsFile(PARAMETER_EXAMPLE_SET_FILE, true);
        if (zipped) {
            dataFile = new File(dataFile.getAbsolutePath() + ".gz");
        }
        File attFile = this.getParameterAsFile(PARAMETER_ATTRIBUTE_DESCRIPTION_FILE, true);
        boolean append = this.shouldAppend(dataFile);
        Charset encoding = Encoding.getEncoding(this);
        try {
            int format = this.getParameterAsInt(PARAMETER_FORMAT);
            this.getLogger().info("Writing example set in format '" + FORMAT_NAMES[format] + "'.");
            if (format == 0) {
                eSet.writeDataFile(dataFile, -2, true, zipped, append, encoding);
                if (attFile != null) {
                    eSet.writeAttributeFile(attFile, dataFile, encoding);
                }
            } else {
                eSet.writeSparseDataFile(dataFile, format - 1, -2, true, zipped, append, encoding);
                if (attFile != null) {
                    eSet.writeSparseAttributeFile(attFile, dataFile, format - 1, encoding);
                }
            }
        }
        catch (IOException e) {
            throw new UserError((Operator)this, (Throwable)e, 303, dataFile + " / " + attFile, e.getMessage());
        }
        return eSet;
    }

    @Override
    protected boolean supportsEncoding() {
        return true;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        types.add(new ParameterTypeFile(PARAMETER_EXAMPLE_SET_FILE, "File to save the example set to.", "dat", false));
        types.add(new ParameterTypeFile(PARAMETER_ATTRIBUTE_DESCRIPTION_FILE, "File to save the attribute descriptions to.", "aml", true));
        types.add(new ParameterTypeCategory(PARAMETER_FORMAT, "Format to use for output.", FORMAT_NAMES, 0));
        types.add(new ParameterTypeBoolean(PARAMETER_ZIPPED, "Indicates if the data file content should be zipped.", false));
        types.addAll(super.getParameterTypes());
        return types;
    }

    static {
        ExampleSetWriter.FORMAT_NAMES[0] = "dense";
        for (int i = 0; i < SparseFormatDataRowReader.FORMAT_NAMES.length; ++i) {
            ExampleSetWriter.FORMAT_NAMES[i + 1] = "sparse_" + SparseFormatDataRowReader.FORMAT_NAMES[i];
        }
    }
}

