/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.io;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.io.AbstractExampleSetWriter;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.tools.jdbc.DatabaseHandler;
import com.rapidminer.tools.jdbc.connection.ConnectionEntry;
import com.rapidminer.tools.jdbc.connection.ConnectionProvider;
import java.sql.SQLException;
import java.util.List;

public class DatabaseExampleSetWriter
extends AbstractExampleSetWriter
implements ConnectionProvider {
    public static final String PARAMETER_OVERWRITE_MODE = "overwrite_mode";
    public static final String PARAMETER_SET_DEFAULT_VARCHAR_LENGTH = "set_default_varchar_length";
    public static final String PARAMETER_DEFAULT_VARCHAR_LENGTH = "default_varchar_length";
    public static final String PARAMETER_GET_GENERATED_PRIMARY_KEYS = "add_generated_primary_keys";
    public static final String PARAMETER_GENERATED_KEYS_ATTRIBUTE_NAME = "db_key_attribute_name";

    public DatabaseExampleSetWriter(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet write(ExampleSet exampleSet) throws OperatorException {
        try {
            DatabaseHandler databaseHandler = DatabaseHandler.getConnectedDatabaseHandler(this);
            if (this.getParameterAsBoolean(PARAMETER_GET_GENERATED_PRIMARY_KEYS)) {
                exampleSet = (ExampleSet)exampleSet.clone();
            }
            databaseHandler.createTable(exampleSet, this.getParameterAsString("table_name"), this.getParameterAsInt(PARAMETER_OVERWRITE_MODE), this.getApplyCount() == 1, this.getParameterAsBoolean(PARAMETER_SET_DEFAULT_VARCHAR_LENGTH) ? this.getParameterAsInt(PARAMETER_DEFAULT_VARCHAR_LENGTH) : -1, this.getParameterAsBoolean(PARAMETER_GET_GENERATED_PRIMARY_KEYS), this.getParameterAsString(PARAMETER_GENERATED_KEYS_ATTRIBUTE_NAME));
            databaseHandler.disconnect();
        }
        catch (SQLException e) {
            throw new UserError((Operator)this, (Throwable)e, 304, e.getMessage());
        }
        return exampleSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.addAll(DatabaseHandler.getConnectionParameterTypes(this));
        types.addAll(DatabaseHandler.getQueryParameterTypes(this, true));
        types.add(new ParameterTypeCategory(PARAMETER_OVERWRITE_MODE, "Indicates if an existing table should be overwritten or if data should be appended.", DatabaseHandler.OVERWRITE_MODES, 0));
        types.add(new ParameterTypeBoolean(PARAMETER_SET_DEFAULT_VARCHAR_LENGTH, "Set varchar columns to default length.", false));
        ParameterTypeSingle type = new ParameterTypeInt(PARAMETER_DEFAULT_VARCHAR_LENGTH, "Default length of varchar columns.", 0, Integer.MAX_VALUE, 128);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_SET_DEFAULT_VARCHAR_LENGTH, true, true));
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_GET_GENERATED_PRIMARY_KEYS, "Indicates whether a new attribute holding the auto generated primary keys is added to the result set.", false);
        type.setExpert(true);
        types.add(type);
        type = new ParameterTypeString(PARAMETER_GENERATED_KEYS_ATTRIBUTE_NAME, "The name of the attribute for the auto generated primary keys", "generated_primary_key", true);
        type.setExpert(true);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_GET_GENERATED_PRIMARY_KEYS, true, true));
        types.add(type);
        return types;
    }

    @Override
    public ConnectionEntry getConnectionEntry() {
        return DatabaseHandler.getConnectionEntry(this);
    }
}

