/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.io;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.DataRowFactory;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.io.AbstractExampleSource;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Ontology;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.jdbc.ColumnIdentifier;
import com.rapidminer.tools.jdbc.DatabaseHandler;
import com.rapidminer.tools.jdbc.StatementCreator;
import com.rapidminer.tools.jdbc.connection.ConnectionEntry;
import com.rapidminer.tools.jdbc.connection.ConnectionProvider;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;

public class DatabaseDataReader
extends AbstractExampleSource
implements ConnectionProvider {
    public static final String PROPERTY_EVALUATE_MD_FOR_SQL_QUERIES = "rapidminer.gui.evaluate_meta_data_for_sql_queries";
    private DatabaseHandler databaseHandler;

    public DatabaseDataReader(OperatorDescription description) {
        super(description);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExampleSet read() throws OperatorException {
        try {
            ExampleSet result;
            ExampleSet exampleSet = result = super.read();
            return exampleSet;
        }
        finally {
            if (this.databaseHandler != null && this.databaseHandler.getConnection() != null) {
                try {
                    this.databaseHandler.getConnection().close();
                }
                catch (SQLException e) {
                    this.getLogger().log(Level.WARNING, "Error closing database connection: " + e, e);
                }
            }
        }
    }

    protected ResultSet getResultSet() throws OperatorException {
        try {
            DatabaseHandler databaseHandler = DatabaseHandler.getConnectedDatabaseHandler(this);
            String query = this.getQuery(databaseHandler.getStatementCreator());
            if (query == null) {
                throw new UserError((Operator)this, 202, "query", "query_file", "table_name");
            }
            return databaseHandler.executeStatement(query, true, this, this.getLogger());
        }
        catch (SQLException sqle) {
            throw new UserError((Operator)this, (Throwable)sqle, 304, sqle.getMessage());
        }
    }

    @Override
    public ExampleSet createExampleSet() throws OperatorException {
        MemoryExampleTable table;
        ResultSet resultSet = this.getResultSet();
        try {
            List<Attribute> attributes = this.getAttributes(resultSet);
            table = this.createExampleTable(resultSet, attributes);
        }
        catch (SQLException e) {
            throw new UserError((Operator)this, (Throwable)e, 304, e.getMessage());
        }
        finally {
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                this.getLogger().log(Level.WARNING, "DB error closing result set: " + e, e);
            }
        }
        return table.createExampleSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MetaData getGeneratedMetaData() throws OperatorException {
        ExampleSetMetaData metaData = new ExampleSetMetaData();
        try {
            DatabaseHandler databaseHandler = DatabaseHandler.getConnectedDatabaseHandler(this);
            switch (this.getParameterAsInt("define_query")) {
                case 2: {
                    List<ColumnIdentifier> columns = databaseHandler.getAllColumnNames(this.getParameterAsString("table_name"), databaseHandler.getConnection().getMetaData());
                    for (ColumnIdentifier column : columns) {
                        metaData.addAttribute(new AttributeMetaData(column.getColumnName(), DatabaseHandler.getRapidMinerTypeIndex(column.getSqlType())));
                    }
                    break;
                }
                default: {
                    if (!"false".equals(System.getProperty(PROPERTY_EVALUATE_MD_FOR_SQL_QUERIES))) {
                        String query = this.getQuery(databaseHandler.getStatementCreator());
                        PreparedStatement prepared = databaseHandler.getConnection().prepareStatement(query);
                        List<Attribute> attributes = this.getAttributes(prepared.getMetaData());
                        for (Attribute att : attributes) {
                            metaData.addAttribute(new AttributeMetaData(att));
                        }
                    }
                    break;
                }
            }
        }
        catch (SQLException e) {
            LogService.getRoot().log(Level.WARNING, "Failed to fetch meta data: " + e, e);
        }
        finally {
            try {
                if (this.databaseHandler != null && this.databaseHandler.getConnection() != null) {
                    this.databaseHandler.disconnect();
                }
            }
            catch (SQLException e) {
                this.getLogger().log(Level.WARNING, "DB error closing connection: " + e, e);
            }
        }
        return metaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MemoryExampleTable createExampleTable(ResultSet resultSet, List<Attribute> attributes) throws SQLException, OperatorException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        Attribute[] attributeArray = attributes.toArray(new Attribute[attributes.size()]);
        MemoryExampleTable table = new MemoryExampleTable(attributes);
        DataRowFactory factory = new DataRowFactory(this.getParameterAsInt("datamanagement"), '.');
        while (resultSet.next()) {
            DataRow dataRow = factory.create(attributeArray.length);
            for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                double value;
                Attribute attribute = attributeArray[i - 1];
                int valueType = attribute.getValueType();
                if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(valueType, 9)) {
                    Timestamp timestamp = resultSet.getTimestamp(i);
                    value = resultSet.wasNull() ? Double.NaN : (double)timestamp.getTime();
                } else if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(valueType, 2)) {
                    value = resultSet.getDouble(i);
                    if (resultSet.wasNull()) {
                        value = Double.NaN;
                    }
                } else if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(valueType, 1)) {
                    String valueString;
                    block22: {
                        if (metaData.getColumnType(i) == 2005) {
                            Clob clob = resultSet.getClob(i);
                            if (clob != null) {
                                BufferedReader in = null;
                                try {
                                    in = new BufferedReader(clob.getCharacterStream());
                                    String line = null;
                                    try {
                                        StringBuffer buffer = new StringBuffer();
                                        while ((line = in.readLine()) != null) {
                                            buffer.append(line + "\n");
                                        }
                                        valueString = buffer.toString();
                                        break block22;
                                    }
                                    catch (IOException e) {
                                        throw new OperatorException("Database error occurred: " + e, e);
                                    }
                                }
                                finally {
                                    try {
                                        in.close();
                                    }
                                    catch (IOException e) {}
                                }
                            }
                            valueString = null;
                        } else {
                            valueString = resultSet.getString(i);
                        }
                    }
                    value = resultSet.wasNull() || valueString == null ? Double.NaN : (double)attribute.getMapping().mapString(valueString);
                } else {
                    this.getLogger().warning("Unknown column type: " + attribute);
                    value = Double.NaN;
                }
                dataRow.set(attribute, value);
            }
            table.addDataRow(dataRow);
        }
        return table;
    }

    private List<Attribute> getAttributes(ResultSet resultSet) throws SQLException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        return this.getAttributes(metaData);
    }

    private List<Attribute> getAttributes(ResultSetMetaData metaData) throws SQLException {
        LinkedList<Attribute> result = new LinkedList<Attribute>();
        HashMap<String, Integer> duplicateNameMap = new HashMap<String, Integer>();
        for (int columnIndex = 1; columnIndex <= metaData.getColumnCount(); ++columnIndex) {
            String columnName = metaData.getColumnLabel(columnIndex);
            Integer duplicateCount = (Integer)duplicateNameMap.get(columnName);
            if (duplicateCount != null) {
                columnName = columnName + "_" + duplicateCount;
                Integer incremented = new Integer(duplicateCount + 1);
                duplicateNameMap.put(columnName, incremented);
            } else {
                duplicateNameMap.put(columnName, new Integer(1));
            }
            int attributeType = DatabaseHandler.getRapidMinerTypeIndex(metaData.getColumnType(columnIndex));
            Attribute attribute = AttributeFactory.createAttribute(columnName, attributeType);
            attribute.getAnnotations().setAnnotation("sql_type", metaData.getColumnTypeName(columnIndex));
            result.add(attribute);
        }
        return result;
    }

    private String getQuery(StatementCreator sc) throws OperatorException {
        switch (this.getParameterAsInt("define_query")) {
            case 0: {
                String query = this.getParameterAsString("query");
                if (query != null) {
                    query = query.trim();
                }
                return query;
            }
            case 1: {
                File queryFile = this.getParameterAsFile("query_file");
                if (queryFile != null) {
                    String query = null;
                    try {
                        query = Tools.readTextFile(queryFile);
                    }
                    catch (IOException ioe) {
                        throw new UserError((Operator)this, (Throwable)ioe, 302, queryFile, ioe.getMessage());
                    }
                    if (query == null || query.trim().length() == 0) {
                        throw new UserError((Operator)this, 205, queryFile);
                    }
                    return query;
                }
            }
            case 2: {
                String tableName = this.getParameterAsString("table_name");
                return "SELECT * FROM " + sc.makeIdentifier(tableName);
            }
        }
        return null;
    }

    @Override
    public ConnectionEntry getConnectionEntry() {
        return DatabaseHandler.getConnectionEntry(this);
    }

    @Override
    protected void addAnnotations(ExampleSet result) {
        try {
            if (this.databaseHandler != null) {
                result.getAnnotations().setAnnotation("Source", this.getQuery(this.databaseHandler.getStatementCreator()));
            }
        }
        catch (OperatorException operatorException) {
            // empty catch block
        }
    }

    @Override
    protected boolean isMetaDataCacheable() {
        return true;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> list = super.getParameterTypes();
        list.addAll(DatabaseHandler.getConnectionParameterTypes(this));
        list.addAll(DatabaseHandler.getQueryParameterTypes(this, false));
        list.addAll(DatabaseHandler.getStatementPreparationParamterTypes(this));
        list.add(new ParameterTypeCategory("datamanagement", "Determines, how the data is represented internally.", DataRowFactory.TYPE_NAMES, 0, false));
        return list;
    }
}

