/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.io;

import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.clustering.ClusterModelInterface;
import com.rapidminer.operator.io.AbstractWriter;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeFile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.GZIPOutputStream;

public class ClusterModelWriter
extends AbstractWriter<ClusterModelInterface> {
    public static final String PARAMETER_CLUSTER_MODEL_FILE = "cluster_model_file";

    public ClusterModelWriter(OperatorDescription description) {
        super(description, ClusterModelInterface.class);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeFile type = new ParameterTypeFile(PARAMETER_CLUSTER_MODEL_FILE, "the file to which the cluster model is stored", "clm", false);
        type.setExpert(false);
        types.add(type);
        return types;
    }

    @Override
    public ClusterModelInterface write(ClusterModelInterface model) throws OperatorException {
        File file = this.getParameterAsFile(PARAMETER_CLUSTER_MODEL_FILE, true);
        OutputStream out = null;
        try {
            out = new GZIPOutputStream(new FileOutputStream(file));
            model.write(out);
        }
        catch (IOException e) {
            throw new UserError((Operator)this, (Throwable)e, 303, file, e.getMessage());
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    this.logError("Cannot close stream to file " + file);
                }
            }
        }
        return model;
    }
}

