/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.io;

import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.clustering.ClusterModel;
import com.rapidminer.operator.io.AbstractReader;
import com.rapidminer.operator.io.IOObjectReader;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.tools.OperatorService;
import java.util.List;

public class ClusterModelReader
extends AbstractReader<ClusterModel> {
    public static final String PARAMETER_CLUSTER_MODEL_FILE = "cluster_model_file";
    public static final String PARAMETER_IS_HIERARCHICAL_MODEL_FILE = "is_hierarchical_model_file";

    public ClusterModelReader(OperatorDescription description) {
        super(description, ClusterModel.class);
    }

    @Override
    public ClusterModel read() throws OperatorException {
        try {
            IOObjectReader ioReader = OperatorService.createOperator(IOObjectReader.class);
            ioReader.setParameter("object_file", this.getParameterAsString(PARAMETER_CLUSTER_MODEL_FILE));
            if (this.getParameterAsBoolean(PARAMETER_IS_HIERARCHICAL_MODEL_FILE)) {
                ioReader.setParameter("io_object", "HierarchicalClusterModel");
            } else {
                ioReader.setParameter("io_object", "ClusterModel");
            }
            return (ClusterModel)ioReader.read();
        }
        catch (OperatorCreationException e) {
            throw new OperatorException("Cannot create IOObjectReader");
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeFile(PARAMETER_CLUSTER_MODEL_FILE, "the file from which the cluster model is read", "clm", false));
        types.add(new ParameterTypeBoolean(PARAMETER_IS_HIERARCHICAL_MODEL_FILE, "indicates that the stored model file is a hierarchical cluster model", false));
        return types;
    }
}

