/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.io;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.IndexCachedDatabaseExampleTable;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.io.AbstractExampleSource;
import com.rapidminer.operator.io.ResultSetExampleSource;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.tools.jdbc.DatabaseHandler;
import com.rapidminer.tools.jdbc.connection.ConnectionEntry;
import com.rapidminer.tools.jdbc.connection.ConnectionProvider;
import java.sql.SQLException;
import java.util.List;

public class CachedDatabaseExampleSource
extends AbstractExampleSource
implements ConnectionProvider {
    public static final String PARAMETER_RECREATE_INDEX = "recreate_index";
    private DatabaseHandler databaseHandler;

    public CachedDatabaseExampleSource(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet createExampleSet() throws OperatorException {
        try {
            this.databaseHandler = DatabaseHandler.getConnectedDatabaseHandler(this);
            String tableName = this.getParameterAsString("table_name");
            boolean recreateIndex = this.getParameterAsBoolean(PARAMETER_RECREATE_INDEX);
            IndexCachedDatabaseExampleTable table = new IndexCachedDatabaseExampleTable(this.databaseHandler, tableName, 0, recreateIndex, this);
            return ResultSetExampleSource.createExampleSet(table, this);
        }
        catch (SQLException e) {
            throw new UserError((Operator)this, (Throwable)e, 304, e.getMessage());
        }
    }

    @Override
    public void processFinished() {
        this.disconnect();
    }

    private void disconnect() {
        if (this.databaseHandler != null) {
            try {
                this.databaseHandler.disconnect();
                this.databaseHandler = null;
            }
            catch (SQLException e) {
                this.logWarning("Cannot disconnect from database: " + e);
            }
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.addAll(DatabaseHandler.getConnectionParameterTypes(this));
        types.addAll(DatabaseHandler.getQueryParameterTypes(this, true));
        types.add(new ParameterTypeBoolean(PARAMETER_RECREATE_INDEX, "Indicates if a recreation of the index or index mapping table should be forced.", false));
        ParameterTypeString type = new ParameterTypeString("label_attribute", "The (case sensitive) name of the label attribute");
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeString("id_attribute", "The (case sensitive) name of the id attribute"));
        types.add(new ParameterTypeString("weight_attribute", "The (case sensitive) name of the weight attribute"));
        return types;
    }

    @Override
    public ConnectionEntry getConnectionEntry() {
        return DatabaseHandler.getConnectionEntry(this);
    }
}

