/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.io;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.io.AbstractExampleSetWriter;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.tools.Ontology;
import com.rapidminer.tools.io.Encoding;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.sql.Date;
import java.text.DateFormat;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class CSVExampleSetWriter
extends AbstractExampleSetWriter {
    public static final String PARAMETER_CSV_FILE = "csv_file";
    public static final String PARAMETER_COLUMN_SEPARATOR = "column_separator";
    public static final String PARAMETER_WRITE_ATTRIBUTE_NAMES = "write_attribute_names";
    public static final String PARAMETER_QUOTE_NOMINAL_VALUES = "quote_nominal_values";
    public static final String PARAMETER_FORMAT_DATE = "format_date_attributes";

    public CSVExampleSetWriter(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet write(ExampleSet exampleSet) throws OperatorException {
        String columnSeparator = this.getParameterAsString(PARAMETER_COLUMN_SEPARATOR);
        File file = this.getParameterAsFile(PARAMETER_CSV_FILE, true);
        boolean quoteNominalValues = this.getParameterAsBoolean(PARAMETER_QUOTE_NOMINAL_VALUES);
        PrintWriter out = null;
        try {
            out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), Encoding.getEncoding(this)));
            if (this.getParameterAsBoolean(PARAMETER_WRITE_ATTRIBUTE_NAMES)) {
                Iterator<Attribute> a = exampleSet.getAttributes().allAttributes();
                boolean first = true;
                while (a.hasNext()) {
                    if (!first) {
                        out.print(columnSeparator);
                    }
                    Attribute attribute = a.next();
                    String name = attribute.getName();
                    if (quoteNominalValues) {
                        name = name.replaceAll("\"", "'");
                        name = "\"" + name + "\"";
                    }
                    out.print(name);
                    first = false;
                }
                out.println();
            }
            for (Example example : exampleSet) {
                Iterator<Attribute> a = exampleSet.getAttributes().allAttributes();
                boolean first = true;
                while (a.hasNext()) {
                    Attribute attribute = a.next();
                    if (!first) {
                        out.print(columnSeparator);
                    }
                    if (!Double.isNaN(example.getValue(attribute))) {
                        if (attribute.isNominal()) {
                            String stringValue = example.getValueAsString(attribute);
                            if (quoteNominalValues) {
                                stringValue = stringValue.replaceAll("\"", "'");
                                stringValue = "\"" + stringValue + "\"";
                            }
                            out.print(stringValue);
                        } else {
                            Double value = example.getValue(attribute);
                            if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), 9)) {
                                if (this.getParameterAsBoolean(PARAMETER_FORMAT_DATE)) {
                                    Date date = new Date(value.longValue());
                                    String s = DateFormat.getInstance().format(date);
                                    out.print(s);
                                } else {
                                    out.print(value);
                                }
                            } else {
                                out.print(value);
                            }
                        }
                    }
                    first = false;
                }
                out.println();
            }
        }
        catch (FileNotFoundException e) {
            throw new UserError((Operator)this, 301, file.getName());
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        return exampleSet;
    }

    @Override
    protected boolean supportsEncoding() {
        return true;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        types.add(new ParameterTypeFile(PARAMETER_CSV_FILE, "The CSV file which should be written.", "csv", false));
        types.add(new ParameterTypeString(PARAMETER_COLUMN_SEPARATOR, "The column separator.", ";", false));
        types.add(new ParameterTypeBoolean(PARAMETER_WRITE_ATTRIBUTE_NAMES, "Indicates if the attribute names should be written as first row.", true, false));
        types.add(new ParameterTypeBoolean(PARAMETER_QUOTE_NOMINAL_VALUES, "Indicates if nominal values should be quoted with double quotes.", true, false));
        types.add(new ParameterTypeBoolean(PARAMETER_FORMAT_DATE, "Indicates if date attributes are written as a formated string or as milliseconds past since January 1, 1970, 00:00:00 GMT", true, true));
        types.addAll(super.getParameterTypes());
        return types;
    }
}

