/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.io;

import com.rapidminer.gui.tools.dialogs.wizards.dataimport.csv.CSVImportWizard;
import com.rapidminer.gui.tools.dialogs.wizards.dataimport.csv.LineReader;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.io.AbstractDataReader;
import com.rapidminer.operator.io.AbstractReader;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeChar;
import com.rapidminer.parameter.ParameterTypeConfiguration;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.tools.CSVParseException;
import com.rapidminer.tools.DateParser;
import com.rapidminer.tools.LineParser;
import com.rapidminer.tools.StrictDecimalFormat;
import com.rapidminer.tools.io.Encoding;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class CSVDataReader
extends AbstractDataReader {
    public static final String PARAMETER_CSV_FILE = "file_name";
    public static final String PARAMETER_USE_FIRST_ROW_AS_ATTRIBUTE_NAMES = "use_first_row_as_attribute_names";
    public static final String PARAMETER_TRIM_LINES = "trim_lines";
    public static final String PARAMETER_SKIP_COMMENTS = "skip_comments";
    public static final String PARAMETER_COMMENT_CHARS = "comment_characters";
    public static final String PARAMETER_USE_QUOTES = "use_quotes";
    public static final String PARAMETER_QUOTES_CHARACTER = "quotes_character";
    public static final String PARAMETER_COLUMN_SEPARATORS = "column_separators";
    public static final String PARAMETER_ESCAPE_CHARACTER = "escape_character_for_quotes";

    public CSVDataReader(OperatorDescription description) {
        super(description);
        this.getParameters().addObserver(new AbstractDataReader.CacheResetParameterObserver(PARAMETER_CSV_FILE), false);
    }

    @Override
    protected AbstractDataReader.DataSet getDataSet() throws OperatorException {
        return new AbstractDataReader.DataSet(){
            private boolean firstRowAreNames;
            private LineReader reader;
            private String[] parsedLine;
            private final LineParser parser;
            private final NumberFormat numberFormat;
            private final DateFormat dateFormat;
            {
                this.firstRowAreNames = CSVDataReader.this.getParameterAsBoolean(CSVDataReader.PARAMETER_USE_FIRST_ROW_AS_ATTRIBUTE_NAMES);
                this.reader = null;
                this.parsedLine = null;
                this.parser = new LineParser();
                this.parser.setTrimLine(CSVDataReader.this.getParameterAsBoolean(CSVDataReader.PARAMETER_TRIM_LINES));
                this.parser.setSkipComments(CSVDataReader.this.getParameterAsBoolean(CSVDataReader.PARAMETER_SKIP_COMMENTS));
                this.parser.setSplitExpression(CSVDataReader.this.getParameterAsString(CSVDataReader.PARAMETER_COLUMN_SEPARATORS));
                this.parser.setUseQuotes(CSVDataReader.this.getParameterAsBoolean(CSVDataReader.PARAMETER_USE_QUOTES));
                this.parser.setQuoteCharacter(CSVDataReader.this.getParameterAsChar(CSVDataReader.PARAMETER_QUOTES_CHARACTER));
                this.parser.setQuoteEscapeCharacter(CSVDataReader.this.getParameterAsChar(CSVDataReader.PARAMETER_ESCAPE_CHARACTER));
                this.parser.setCommentCharacters(CSVDataReader.this.getParameterAsString(CSVDataReader.PARAMETER_COMMENT_CHARS));
                this.parser.setEncoding(Encoding.getEncoding(CSVDataReader.this));
                InputStream stream = null;
                try {
                    stream = CSVDataReader.this.getParameterAsInputStream(CSVDataReader.PARAMETER_CSV_FILE);
                }
                catch (IOException e) {
                    throw new UserError((Operator)CSVDataReader.this, (Throwable)e, 302, stream, e.getMessage());
                }
                this.reader = new LineReader(stream, Encoding.getEncoding(CSVDataReader.this));
                if (this.firstRowAreNames && !CSVDataReader.this.attributeNamesDefinedByUser()) {
                    String line = null;
                    try {
                        while ((line = this.reader.readLine()) != null) {
                            try {
                                this.parsedLine = this.parser.parse(line);
                            }
                            catch (IllegalArgumentException e) {
                                this.parsedLine = new String[]{line};
                            }
                            if (this.parsedLine == null) continue;
                        }
                        CSVDataReader.this.setAttributeNames(this.parsedLine);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } else if (this.firstRowAreNames) {
                    try {
                        this.reader.readLine();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                this.numberFormat = StrictDecimalFormat.getInstance(CSVDataReader.this, true);
                this.dateFormat = DateParser.getInstance(CSVDataReader.this);
            }

            @Override
            public boolean next() {
                String line = null;
                try {
                    do {
                        if ((line = this.reader.readLine()) == null) {
                            return false;
                        }
                        try {
                            this.parsedLine = this.parser.parse(line);
                        }
                        catch (CSVParseException e) {
                            if (!CSVDataReader.this.isErrorTolerant()) {
                                throw new IllegalArgumentException(e);
                            }
                            this.parsedLine = new String[]{line};
                        }
                    } while (this.parsedLine == null);
                    return true;
                }
                catch (IOException e) {
                    return false;
                }
            }

            @Override
            public int getNumberOfColumnsInCurrentRow() {
                return this.parsedLine.length;
            }

            @Override
            public boolean isMissing(int columnIndex) {
                return this.parsedLine[columnIndex] == null || this.parsedLine[columnIndex].isEmpty();
            }

            @Override
            public Number getNumber(int columnIndex) {
                if (this.numberFormat == null) {
                    return null;
                }
                try {
                    return this.numberFormat.parse(this.parsedLine[columnIndex].replace('e', 'E'));
                }
                catch (ParseException parseException) {
                    return null;
                }
            }

            @Override
            public String getString(int columnIndex) {
                return this.parsedLine[columnIndex];
            }

            @Override
            public Date getDate(int columnIndex) {
                try {
                    return this.dateFormat.parse(this.parsedLine[columnIndex]);
                }
                catch (ParseException parseException) {
                    return null;
                }
            }

            @Override
            public void close() throws OperatorException {
                try {
                    this.reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        ParameterType type = new ParameterTypeConfiguration(CSVImportWizard.CSVDataReaderWizardCreator.class, this);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeFile(PARAMETER_CSV_FILE, "Name of the file to read the data from.", "csv", false));
        types.addAll(Encoding.getParameterTypes(this));
        types.add(new ParameterTypeBoolean(PARAMETER_TRIM_LINES, "Indicates if lines should be trimmed (empty spaces are removed at the beginning and the end) before the column split is performed. This option might be problematic if TABs are used as a seperator.", false));
        types.add(new ParameterTypeBoolean(PARAMETER_SKIP_COMMENTS, "Indicates if a comment character should be used.", true));
        type = new ParameterTypeString(PARAMETER_COMMENT_CHARS, "Lines beginning with these characters are ignored.", "#", true);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_SKIP_COMMENTS, false, true));
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_USE_FIRST_ROW_AS_ATTRIBUTE_NAMES, "Read attribute names from file (assumes the attribute names are in the first line of the file).", true);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeBoolean(PARAMETER_USE_QUOTES, "Indicates if quotes should be regarded.", true));
        type = new ParameterTypeChar(PARAMETER_QUOTES_CHARACTER, "The quotes character.", '\"', true);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_USE_QUOTES, false, true));
        types.add(type);
        type = new ParameterTypeChar(PARAMETER_ESCAPE_CHARACTER, "The charcter that is used to escape quotes", '\\', true);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_USE_QUOTES, false, true));
        types.add(type);
        types.add(new ParameterTypeString(PARAMETER_COLUMN_SEPARATORS, "Column separators for data files (regular expression)", ";"));
        types.addAll(StrictDecimalFormat.getParameterTypes(this, true));
        types.addAll(DateParser.getParameterTypes(this));
        types.addAll(super.getParameterTypes());
        return types;
    }

    static {
        AbstractReader.registerReaderDescription(new AbstractReader.ReaderDescription("csv", CSVDataReader.class, PARAMETER_CSV_FILE));
    }
}

