/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.io;

import com.rapidminer.example.AttributeWeights;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.io.AbstractWriter;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.tools.io.Encoding;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class AttributeWeightsWriter
extends AbstractWriter<AttributeWeights> {
    public static final String PARAMETER_ATTRIBUTE_WEIGHTS_FILE = "attribute_weights_file";

    public AttributeWeightsWriter(OperatorDescription description) {
        super(description, AttributeWeights.class);
    }

    @Override
    public AttributeWeights write(AttributeWeights weights) throws OperatorException {
        File weightFile = this.getParameterAsFile(PARAMETER_ATTRIBUTE_WEIGHTS_FILE, true);
        try {
            weights.writeAttributeWeights(weightFile, Encoding.getEncoding(this));
        }
        catch (IOException e) {
            throw new UserError((Operator)this, (Throwable)e, 303, weightFile, e.getMessage());
        }
        return weights;
    }

    @Override
    protected boolean supportsEncoding() {
        return true;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        types.add(new ParameterTypeFile(PARAMETER_ATTRIBUTE_WEIGHTS_FILE, "Filename for the attribute weight file.", "wgt", false));
        types.addAll(super.getParameterTypes());
        return types;
    }
}

