/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.io;

import com.rapidminer.RapidMiner;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.io.AbstractWriter;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.tools.io.Encoding;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;

public class AttributeConstructionsWriter
extends AbstractWriter<ExampleSet> {
    public static final String PARAMETER_ATTRIBUTE_CONSTRUCTIONS_FILE = "attribute_constructions_file";

    public AttributeConstructionsWriter(OperatorDescription description) {
        super(description, ExampleSet.class);
    }

    @Override
    public ExampleSet write(ExampleSet eSet) throws OperatorException {
        File generatorFile = this.getParameterAsFile(PARAMETER_ATTRIBUTE_CONSTRUCTIONS_FILE, true);
        PrintWriter out = null;
        try {
            out = new PrintWriter(new FileWriter(generatorFile));
            out.println("<?xml version=\"1.0\" encoding=\"" + Encoding.getEncoding(this) + "\"?>");
            out.println("<constructions version=\"" + RapidMiner.getShortVersion() + "\">");
            for (Attribute attribute : eSet.getAttributes()) {
                out.println("    <attribute name=\"" + attribute.getName() + "\" construction=\"" + attribute.getConstruction() + "\"/>");
            }
            out.println("</constructions>");
        }
        catch (IOException e) {
            throw new UserError((Operator)this, (Throwable)e, 303, generatorFile, e.getMessage());
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        return eSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeFile(PARAMETER_ATTRIBUTE_CONSTRUCTIONS_FILE, "Filename for the attribute construction description file.", "att", false, false));
        types.addAll(Encoding.getParameterTypes(this));
        return types;
    }
}

