/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.io;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetPassThroughRule;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.math.function.ExpressionParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;

public class AttributeConstructionsLoader
extends Operator {
    private InputPort exampleSetInput = this.getInputPorts().createPort("example set", ExampleSet.class);
    private OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set");
    public static final String PARAMETER_ATTRIBUTE_CONSTRUCTIONS_FILE = "attribute_constructions_file";
    public static final String PARAMETER_KEEP_ALL = "keep_all";

    public AttributeConstructionsLoader(OperatorDescription description) {
        super(description);
        this.getTransformer().addRule(new ExampleSetPassThroughRule(this.exampleSetInput, this.exampleSetOutput, SetRelation.SUPERSET){

            @Override
            public ExampleSetMetaData modifyExampleSet(ExampleSetMetaData metaData) throws UndefinedParameterError {
                metaData.clearRegular();
                return metaData;
            }
        });
    }

    @Override
    public void doWork() throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)this.exampleSetInput.getData();
        boolean keepAll = this.getParameterAsBoolean(PARAMETER_KEEP_ALL);
        LinkedList<Attribute> oldAttributes = new LinkedList<Attribute>();
        for (Attribute attribute : exampleSet.getAttributes()) {
            oldAttributes.add(attribute);
        }
        File file = this.getParameterAsFile(PARAMETER_ATTRIBUTE_CONSTRUCTIONS_FILE);
        List<Object> generatedAttributes = new LinkedList();
        if (file != null) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(file);
                generatedAttributes = ExpressionParser.generateAll(this, exampleSet, in);
            }
            catch (IOException e) {
                throw new UserError((Operator)this, (Throwable)e, 302, file.getName(), e.getMessage());
            }
            finally {
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException e) {
                        this.getLogger().warning("Cannot close stream to file " + file);
                    }
                }
            }
        }
        if (!keepAll) {
            for (Attribute oldAttribute : oldAttributes) {
                if (generatedAttributes.contains(oldAttribute)) continue;
                exampleSet.getAttributes().remove(oldAttribute);
            }
        }
        this.exampleSetOutput.deliver(exampleSet);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeFile(PARAMETER_ATTRIBUTE_CONSTRUCTIONS_FILE, "Filename for the attribute constructions file.", "att", false, false));
        types.add(new ParameterTypeBoolean(PARAMETER_KEEP_ALL, "If set to true, all the original attributes are kept, otherwise they are removed from the example set.", false, false));
        return types;
    }
}

